/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.output.rankedgraph;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.interedition.collatex2.implementation.output.rankedgraph.IRankedVariantGraphVertex;
import eu.interedition.collatex2.implementation.output.rankedgraph.RankedVariantGraphVertex;
import eu.interedition.collatex2.interfaces.IVariantGraph;
import eu.interedition.collatex2.interfaces.IVariantGraphEdge;
import eu.interedition.collatex2.interfaces.IVariantGraphVertex;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class VariantGraphRanker {
    private final IVariantGraph graph;

    public VariantGraphRanker(IVariantGraph iVariantGraph) {
        this.graph = iVariantGraph;
    }

    public Iterator<IRankedVariantGraphVertex> iterator() {
        final LinkedHashMap<IVariantGraphVertex, Integer> linkedHashMap = Maps.newLinkedHashMap();
        final Iterator<IVariantGraphVertex> iterator = this.graph.iterator();
        IVariantGraphVertex iVariantGraphVertex = iterator.next();
        linkedHashMap.put(iVariantGraphVertex, 0);
        return new Iterator<IRankedVariantGraphVertex>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public IRankedVariantGraphVertex next() {
                IVariantGraphVertex iVariantGraphVertex = (IVariantGraphVertex)iterator.next();
                Set set = VariantGraphRanker.this.graph.incomingEdgesOf(iVariantGraphVertex);
                int n = -1;
                for (IVariantGraphEdge iVariantGraphEdge : set) {
                    IVariantGraphVertex iVariantGraphVertex2 = iVariantGraphEdge.getBeginVertex();
                    n = Math.max(n, (Integer)linkedHashMap.get(iVariantGraphVertex2));
                }
                int n2 = n + 1;
                linkedHashMap.put(iVariantGraphVertex, n2);
                return new RankedVariantGraphVertex(n2, iVariantGraphVertex.getNormalized());
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public List<IRankedVariantGraphVertex> getRankedVertices() {
        return Lists.newArrayList(this.iterator());
    }
}

