/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.output.table;

import eu.interedition.collatex2.implementation.output.table.VariantGraphBasedColumn;
import eu.interedition.collatex2.interfaces.ICell;
import eu.interedition.collatex2.interfaces.IInternalColumn;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import eu.interedition.collatex2.interfaces.IVariantGraphVertex;
import eu.interedition.collatex2.interfaces.Modification;

public class Cell
implements ICell {
    private final IInternalColumn column;
    private final String sigil;

    public Cell(IInternalColumn iInternalColumn, String string) {
        this.column = iInternalColumn;
        this.sigil = string;
    }

    @Override
    public IInternalColumn getColumn() {
        return this.column;
    }

    @Override
    public int getPosition() {
        return this.column.getPosition();
    }

    @Override
    public String getColor(String string) {
        IVariantGraphVertex iVariantGraphVertex = ((VariantGraphBasedColumn)this.column).findVertexForWitness(string);
        return iVariantGraphVertex == null ? "black" : this.color(iVariantGraphVertex.getVertexKey().hashCode());
    }

    private String color(int n) {
        return "#" + (Integer.toHexString(n) + "000000").substring(0, 6);
    }

    @Override
    public INormalizedToken getToken() {
        return this.column.getToken(this.sigil);
    }

    @Override
    public boolean isEmpty() {
        return !this.column.containsWitness(this.sigil);
    }

    @Override
    public Modification getModification(String string) {
        boolean bl;
        boolean bl2 = this.isEmpty();
        boolean bl3 = bl = !this.column.containsWitness(string);
        if (bl && bl2) {
            return Modification.NONE;
        }
        if (bl && !bl2) {
            return Modification.ADDITION;
        }
        if (!bl && bl2) {
            return Modification.OMISSION;
        }
        if (this.isMatch(string)) {
            return Modification.MATCH;
        }
        return Modification.REPLACEMENT;
    }

    private boolean isMatch(String string) {
        return this.column.isMatch(string, this.sigil);
    }
}

