/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.output.table;

import com.google.common.collect.Lists;
import eu.interedition.collatex2.interfaces.ColumnState;
import eu.interedition.collatex2.interfaces.IAlignmentTableVisitor;
import eu.interedition.collatex2.interfaces.IColumn;
import eu.interedition.collatex2.interfaces.IInternalColumn;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import eu.interedition.collatex2.interfaces.IVariantGraphVertex;
import eu.interedition.collatex2.interfaces.IWitness;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class VariantGraphBasedColumn
implements IColumn,
IInternalColumn {
    private final List<IVariantGraphVertex> vertices = Lists.newArrayList();
    private final int position;

    public VariantGraphBasedColumn(IVariantGraphVertex iVariantGraphVertex, int n) {
        this.position = n;
        this.addVertex(iVariantGraphVertex);
    }

    @Override
    public ColumnState getState() {
        if (this.vertices.size() == 1) {
            return ColumnState.INVARIANT;
        }
        return ColumnState.VARIANT;
    }

    @Override
    public INormalizedToken getToken(String string) {
        IVariantGraphVertex iVariantGraphVertex = this.findVertexForWitness(string);
        if (iVariantGraphVertex == null) {
            throw new NoSuchElementException("Witness " + string + " is not present in this column");
        }
        IWitness iWitness = iVariantGraphVertex.getWitnessForSigil(string);
        return iVariantGraphVertex.getToken(iWitness);
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public List<String> getSigli() {
        throw new UnsupportedOperationException("NOT IMPLEMENTED!");
    }

    @Override
    public List<String> getSigla() {
        ArrayList<String> arrayList = Lists.newArrayList();
        for (IVariantGraphVertex iVariantGraphVertex : this.vertices) {
            Set<IWitness> set = iVariantGraphVertex.getWitnesses();
            for (IWitness iWitness : set) {
                arrayList.add(iWitness.getSigil());
            }
        }
        return arrayList;
    }

    @Override
    public void addVertex(IVariantGraphVertex iVariantGraphVertex) {
        this.vertices.add(iVariantGraphVertex);
    }

    @Override
    public IInternalColumn getInternalColumn() {
        return this;
    }

    @Override
    public boolean containsWitness(String string) {
        IVariantGraphVertex iVariantGraphVertex = this.findVertexForWitness(string);
        return iVariantGraphVertex != null;
    }

    @Override
    public List<INormalizedToken> getVariants() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(IAlignmentTableVisitor iAlignmentTableVisitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addMatch(INormalizedToken iNormalizedToken) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addVariant(INormalizedToken iNormalizedToken) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPosition(int n) {
        throw new UnsupportedOperationException();
    }

    protected IVariantGraphVertex findVertexForWitness(String string) {
        IVariantGraphVertex iVariantGraphVertex = null;
        for (IVariantGraphVertex iVariantGraphVertex2 : this.vertices) {
            if (iVariantGraphVertex != null || !iVariantGraphVertex2.containsWitness(string)) continue;
            iVariantGraphVertex = iVariantGraphVertex2;
        }
        return iVariantGraphVertex;
    }

    @Override
    public boolean isMatch(String string, String string2) {
        IVariantGraphVertex iVariantGraphVertex;
        IVariantGraphVertex iVariantGraphVertex2 = this.findVertexForWitness(string);
        return iVariantGraphVertex2 == (iVariantGraphVertex = this.findVertexForWitness(string2));
    }
}

