/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.vg_alignment;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import eu.interedition.collatex2.implementation.input.Phrase;
import eu.interedition.collatex2.implementation.vg_alignment.Sequence;
import eu.interedition.collatex2.implementation.vg_alignment.TokenIndexMatcher;
import eu.interedition.collatex2.implementation.vg_alignment.TokenMatch;
import eu.interedition.collatex2.implementation.vg_alignment.TokenPair;
import eu.interedition.collatex2.interfaces.IAlignmentTable;
import eu.interedition.collatex2.interfaces.IColumn;
import eu.interedition.collatex2.interfaces.IInternalColumn;
import eu.interedition.collatex2.interfaces.IMatch;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import eu.interedition.collatex2.interfaces.IPhrase;
import eu.interedition.collatex2.interfaces.ITokenContainer;
import eu.interedition.collatex2.interfaces.ITokenIndex;
import eu.interedition.collatex2.interfaces.ITokenMatch;
import eu.interedition.collatex2.interfaces.ITokenMatcher;
import eu.interedition.collatex2.interfaces.IWitness;
import eu.interedition.collatex2.legacy.indexing.Columns;
import eu.interedition.collatex2.legacy.indexing.NullToken;
import eu.interedition.collatex2.legacy.tokenmatching.ColumnPhraseMatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlternativeTokenIndexMatcher
implements ITokenMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(TokenIndexMatcher.class);
    private final ITokenContainer base;

    public AlternativeTokenIndexMatcher(ITokenContainer iTokenContainer) {
        this.base = iTokenContainer;
    }

    @Override
    public List<ITokenMatch> getMatches(IWitness iWitness) {
        List<String> list = this.combineRepeatedTokens(iWitness);
        ITokenIndex iTokenIndex = this.base.getTokenIndex(list);
        return this.findMatches(iTokenIndex, iWitness.getTokenIndex(list), iWitness);
    }

    private List<String> combineRepeatedTokens(IWitness iWitness) {
        HashSet<String> hashSet = Sets.newHashSet();
        hashSet.addAll(this.base.getRepeatedTokens());
        hashSet.addAll(iWitness.getRepeatedTokens());
        return Lists.newArrayList(hashSet);
    }

    private List<ITokenMatch> findMatches(ITokenIndex iTokenIndex, ITokenIndex iTokenIndex2, IWitness iWitness) {
        ArrayList<Sequence> arrayList = Lists.newArrayList();
        Set<String> set = iTokenIndex2.keys();
        for (String string : set) {
            if (!iTokenIndex.contains(string)) continue;
            IPhrase iPhrase = iTokenIndex2.getPhrase(string);
            IPhrase iPhrase2 = iTokenIndex.getPhrase(string);
            arrayList.add(new Sequence(iPhrase2, iPhrase));
        }
        TokenIndexMatcher.LOG.debug("unfiltered matches: " + arrayList);
        return this.joinOverlappingMatches(arrayList, iWitness);
    }

    private List<ITokenMatch> joinOverlappingMatches(List<Sequence> list, IWitness iWitness) {
        List<ITokenMatch> list2 = this.filterMatchesBasedOnPositionMatches(list, iWitness);
        TokenIndexMatcher.LOG.debug("filtered matches: " + list2);
        return list2;
    }

    private List<ITokenMatch> filterMatchesBasedOnPositionMatches(List<Sequence> list, IWitness iWitness) {
        Object object;
        Object object2;
        LinkedHashMap<INormalizedToken, INormalizedToken> linkedHashMap = Maps.newLinkedHashMap();
        for (Sequence object3 : list) {
            INormalizedToken iNormalizedToken;
            ArrayList<TokenPair> arrayList = Lists.newArrayList();
            object2 = object3.getTablePhrase();
            object = object3.getPhrase();
            Iterator<INormalizedToken> iterator = object.getTokens().iterator();
            for (INormalizedToken iNormalizedToken2 : object2.getTokens()) {
                iNormalizedToken = iterator.next();
                if (iNormalizedToken2 instanceof NullToken) continue;
                arrayList.add(new TokenPair(iNormalizedToken2, iNormalizedToken));
            }
            for (TokenPair tokenPair : arrayList) {
                iNormalizedToken = tokenPair.tableToken;
                INormalizedToken iNormalizedToken3 = tokenPair.witnessToken;
                linkedHashMap.put(iNormalizedToken3, iNormalizedToken);
            }
        }
        ArrayList arrayList = Lists.newArrayList();
        for (INormalizedToken iNormalizedToken : iWitness.getTokens()) {
            object2 = (INormalizedToken)linkedHashMap.get(iNormalizedToken);
            if (object2 == null) continue;
            object = new TokenMatch((INormalizedToken)object2, iNormalizedToken);
            arrayList.add(object);
        }
        return arrayList;
    }

    private static List<ITokenMatch> filterAwaySecondChoicesMultipleColumnsOneToken(List<ITokenMatch> list) {
        ArrayList<ITokenMatch> arrayList = Lists.newArrayList();
        ArrayListMultimap<INormalizedToken, INormalizedToken> arrayListMultimap = ArrayListMultimap.create();
        for (ITokenMatch object : list) {
            arrayListMultimap.put(object.getBaseToken(), object.getWitnessToken());
        }
        for (Map.Entry entry : arrayListMultimap.asMap().entrySet()) {
            INormalizedToken iNormalizedToken = (INormalizedToken)entry.getKey();
            Collection collection = (Collection)entry.getValue();
            INormalizedToken iNormalizedToken2 = (INormalizedToken)collection.iterator().next();
            arrayList.add(new TokenMatch(iNormalizedToken, iNormalizedToken2));
        }
        return arrayList;
    }

    private static List<ITokenMatch> filterAwaySecondChoicesMultipleTokensOneColumn(List<ITokenMatch> list, Map<INormalizedToken, IInternalColumn> map) {
        ArrayList<ITokenMatch> arrayList = Lists.newArrayList();
        ArrayListMultimap<INormalizedToken, INormalizedToken> arrayListMultimap = ArrayListMultimap.create();
        for (ITokenMatch hashMap22 : list) {
            arrayListMultimap.put(hashMap22.getWitnessToken(), hashMap22.getBaseToken());
        }
        ArrayListMultimap arrayListMultimap2 = ArrayListMultimap.create();
        for (Map.Entry entry : arrayListMultimap.asMap().entrySet()) {
            INormalizedToken iNormalizedToken = (INormalizedToken)entry.getKey();
            for (INormalizedToken iNormalizedToken2 : entry.getValue()) {
                arrayListMultimap2.put(iNormalizedToken, map.get(iNormalizedToken2));
            }
        }
        HashMap hashMap = Maps.newHashMap();
        for (Map.Entry entry : arrayListMultimap2.asMap().entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().iterator().next());
        }
        HashMap<IInternalColumn, INormalizedToken> hashMap2 = Maps.newHashMap();
        for (Map.Entry<INormalizedToken, IInternalColumn> entry : map.entrySet()) {
            hashMap2.put(entry.getValue(), entry.getKey());
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            INormalizedToken iNormalizedToken2;
            iNormalizedToken2 = (INormalizedToken)entry.getKey();
            INormalizedToken iNormalizedToken = (INormalizedToken)hashMap2.get(entry.getValue());
            arrayList.add(new TokenMatch(iNormalizedToken, iNormalizedToken2));
        }
        return arrayList;
    }

    public static List<IMatch> getMatchesUsingWitnessIndex(IAlignmentTable iAlignmentTable, IWitness iWitness) {
        Object object2;
        ArrayList<IMatch> arrayList;
        LinkedHashMap<INormalizedToken, IInternalColumn> linkedHashMap = Maps.newLinkedHashMap();
        for (IColumn object32 : iAlignmentTable.getColumns()) {
            for (String string : object32.getInternalColumn().getSigla()) {
                arrayList = object32.getInternalColumn().getToken(string);
                linkedHashMap.put((INormalizedToken)((Object)arrayList), object32.getInternalColumn());
            }
        }
        TokenIndexMatcher tokenIndexMatcher = new TokenIndexMatcher((ITokenContainer)((Object)iAlignmentTable));
        ArrayList<ColumnPhraseMatch> arrayList2 = Lists.newArrayList();
        List<ITokenMatch> list = tokenIndexMatcher.getMatches(iWitness);
        List<ITokenMatch> list2 = AlternativeTokenIndexMatcher.filterAwaySecondChoicesMultipleColumnsOneToken(AlternativeTokenIndexMatcher.filterAwaySecondChoicesMultipleTokensOneColumn(list, linkedHashMap));
        for (Object object2 : list2) {
            INormalizedToken iNormalizedToken = object2.getBaseToken();
            INormalizedToken iNormalizedToken2 = object2.getWitnessToken();
            IInternalColumn iInternalColumn = (IInternalColumn)linkedHashMap.get(iNormalizedToken);
            Columns columns = new Columns(Lists.newArrayList(iInternalColumn));
            Phrase phrase = new Phrase(Lists.newArrayList(iNormalizedToken2));
            ColumnPhraseMatch columnPhraseMatch = new ColumnPhraseMatch(columns, phrase);
            arrayList2.add(columnPhraseMatch);
        }
        arrayList = Lists.newArrayList(arrayList2);
        object2 = new Comparator<IMatch>(){

            @Override
            public int compare(IMatch iMatch, IMatch iMatch2) {
                return iMatch.getColumns().getBeginPosition() - iMatch2.getColumns().getBeginPosition();
            }
        };
        Collections.sort(arrayList, object2);
        return arrayList;
    }
}

