/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.vg_analysis;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.interedition.collatex2.implementation.vg_analysis.IAnalysis;
import eu.interedition.collatex2.implementation.vg_analysis.ISequence;
import eu.interedition.collatex2.implementation.vg_analysis.ITransposition2;
import eu.interedition.collatex2.implementation.vg_analysis.Transposition2;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import eu.interedition.collatex2.interfaces.ITokenContainer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class Analysis
implements IAnalysis {
    private final List<ISequence> sequences;
    private final ITokenContainer base;

    public Analysis(List<ISequence> list, ITokenContainer iTokenContainer) {
        this.sequences = list;
        this.base = iTokenContainer;
    }

    @Override
    public List<ISequence> getSequences() {
        return this.sequences;
    }

    @Override
    public List<ITransposition2> getTranspositions() {
        List<ISequence> list = this.sortSequencesForBase();
        ArrayList<ITransposition2> arrayList = Lists.newArrayList();
        for (int i = 0; i < this.sequences.size(); ++i) {
            ISequence iSequence;
            ISequence iSequence2 = this.sequences.get(i);
            if (iSequence2.equals(iSequence = list.get(i))) continue;
            arrayList.add(new Transposition2(iSequence, iSequence2));
        }
        return arrayList;
    }

    private List<ISequence> sortSequencesForBase() {
        INormalizedToken iNormalizedToken;
        LinkedHashMap<INormalizedToken, ISequence> linkedHashMap = Maps.newLinkedHashMap();
        for (ISequence object2 : this.sequences) {
            iNormalizedToken = object2.getWitnessPhrase().getFirstToken();
            linkedHashMap.put(iNormalizedToken, object2);
        }
        ArrayList arrayList = Lists.newArrayList();
        Iterator<INormalizedToken> iterator = this.base.tokenIterator();
        while (iterator.hasNext()) {
            iNormalizedToken = iterator.next();
            if (!linkedHashMap.containsKey(iNormalizedToken)) continue;
            ISequence iSequence = (ISequence)linkedHashMap.get(iNormalizedToken);
            arrayList.add(iSequence);
        }
        return arrayList;
    }
}

