/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.legacy.indexing;

import com.google.common.collect.Lists;
import eu.interedition.collatex2.implementation.input.Phrase;
import eu.interedition.collatex2.interfaces.IColumns;
import eu.interedition.collatex2.interfaces.IInternalColumn;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import eu.interedition.collatex2.interfaces.IPhrase;
import eu.interedition.collatex2.legacy.indexing.Columns;
import eu.interedition.collatex2.legacy.indexing.NullColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ColumnPhrase {
    private IColumns columns;
    private List<String> sigla;
    String name;

    public ColumnPhrase(String string, IColumns iColumns, Collection<String> collection) {
        this.setColumns(iColumns);
        this.setSigla(collection);
        this.name = string;
    }

    public IPhrase getPhrase() {
        ArrayList<INormalizedToken> arrayList = Lists.newArrayList();
        String string = this.getSigla().get(0);
        for (IInternalColumn iInternalColumn : this.columns.getColumns()) {
            arrayList.add(iInternalColumn.getToken(string));
        }
        return new Phrase(arrayList);
    }

    public void addColumnToLeft(IInternalColumn iInternalColumn) {
        List<IInternalColumn> list = this.getColumns().getColumns();
        list.add(0, iInternalColumn);
        this.setColumns(new Columns(list));
        if (iInternalColumn instanceof NullColumn) {
            this.name = "# " + this.name;
        } else {
            String string = iInternalColumn.getToken(this.getSigla().get(0)).getNormalized();
            this.name = string + " " + this.name;
        }
    }

    public void addColumnToRight(IInternalColumn iInternalColumn) {
        List<IInternalColumn> list = this.getColumns().getColumns();
        list.add(iInternalColumn);
        this.setColumns(new Columns(list));
        if (iInternalColumn instanceof NullColumn) {
            this.name = this.name + " #";
        } else {
            String string = iInternalColumn.getToken(this.getSigla().get(0)).getNormalized();
            this.name = this.name + " " + string;
        }
    }

    public String getNormalized() {
        return this.name;
    }

    public void setSigla(Collection<String> collection) {
        this.sigla = Lists.newArrayList(collection);
    }

    public List<String> getSigla() {
        return this.sigla;
    }

    public void setColumns(IColumns iColumns) {
        this.columns = iColumns;
    }

    public IColumns getColumns() {
        return this.columns;
    }
}

