/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.todo.modifications;

import eu.interedition.collatex2.interfaces.IAddition;
import eu.interedition.collatex2.interfaces.IGap;
import eu.interedition.collatex2.interfaces.IInternalColumn;
import eu.interedition.collatex2.interfaces.IPhrase;

public class Addition
implements IAddition {
    private final IPhrase addition;
    private final IInternalColumn nextColumn;

    private Addition(IInternalColumn iInternalColumn, IPhrase iPhrase) {
        this.nextColumn = iInternalColumn;
        this.addition = iPhrase;
    }

    public int getPosition() {
        return this.getNextColumn().getPosition();
    }

    @Override
    public IPhrase getAddedPhrase() {
        return this.addition;
    }

    public String toString() {
        String string = "addition: " + this.addition.getNormalized();
        string = this.isAtTheEnd() ? string + " position: at the end" : string + " position: " + this.getPosition();
        return string;
    }

    @Override
    public boolean isAtTheBeginning() {
        throw new RuntimeException("NOT implemented!");
    }

    @Override
    public boolean isAtTheEnd() {
        return this.nextColumn == null;
    }

    @Override
    public IInternalColumn getNextColumn() {
        if (this.isAtTheEnd()) {
            throw new RuntimeException("There is no next match!");
        }
        return this.nextColumn;
    }

    public static IAddition create(IGap iGap) {
        return new Addition(iGap.getNextColumn(), iGap.getPhrase());
    }
}

