/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.todo.modifications;

import eu.interedition.collatex2.interfaces.IColumns;
import eu.interedition.collatex2.interfaces.IGap;
import eu.interedition.collatex2.interfaces.IInternalColumn;
import eu.interedition.collatex2.interfaces.IPhrase;
import eu.interedition.collatex2.interfaces.IReplacement;

public class Replacement
implements IReplacement {
    private final IColumns _original;
    private final IPhrase _replacement;
    private final IInternalColumn _nextColumn;

    private Replacement(IColumns iColumns, IPhrase iPhrase, IInternalColumn iInternalColumn) {
        this._original = iColumns;
        this._replacement = iPhrase;
        this._nextColumn = iInternalColumn;
    }

    public String toString() {
        String string = this._original.toString();
        String string2 = this._replacement.getNormalized();
        return "replacement: " + string + " / " + string2 + " position: " + this._original.getFirstColumn().getPosition();
    }

    @Override
    public int getPosition() {
        return this._original.getFirstColumn().getPosition();
    }

    @Override
    public IColumns getOriginalColumns() {
        return this._original;
    }

    @Override
    public IPhrase getReplacementPhrase() {
        return this._replacement;
    }

    @Override
    public IInternalColumn getNextColumn() {
        return this._nextColumn;
    }

    public static IReplacement create(IGap iGap) {
        return new Replacement(iGap.getColumns(), iGap.getPhrase(), iGap.getNextColumn());
    }
}

