/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.mss.transcript.reconcile;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import eu.interedition.collatex2.implementation.CollateXEngine;
import eu.interedition.collatex2.implementation.output.apparatus.ApparatusEntry;
import eu.interedition.collatex2.implementation.output.apparatus.ParallelSegmentationApparatus;
import eu.interedition.collatex2.interfaces.IAlignmentTable;
import eu.interedition.collatex2.interfaces.IWitness;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.crosswire.mss.transcript.reconcile.Convert;
import org.crosswire.mss.transcript.reconcile.FileDrop;

public class App
extends JFrame {
    boolean bgreekTransform = false;
    boolean useUnicode = false;
    File transFolderPath1 = new File("./");
    File transFolderPath2 = new File("./");
    DefaultListModel transFileNameModel1 = new DefaultListModel();
    DefaultListModel transFileNameModel2 = new DefaultListModel();
    Font symbolGreek = null;
    private JMenuItem aboutMenuItem;
    private ButtonGroup buttonGroup1;
    private JMenuItem contentsMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem cutMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenu editMenu;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPane1;
    private JMenuBar menuBar;
    private JMenuItem openMenuItem;
    private JList outputList;
    private JMenuItem pasteMenuItem;
    private JMenuItem saveAsMenuItem;
    private JMenuItem saveMenuItem;
    private JList transFileName1;
    private JList transFileName2;
    private JLabel transFolderName1;
    private JLabel transFolderName2;

    public App() {
        this.initComponents();
        this.transFileName1.setModel(this.transFileNameModel1);
        this.transFileName2.setModel(this.transFileNameModel2);
        this.setPreferredSize(new Dimension(400, 700));
        this.setMinimumSize(new Dimension(700, 700));
        Vector columnData = new Vector();
        this.outputList.setListData(columnData);
        this.outputList.setModel(new DefaultListModel());
        String fontName = "/symbol.ttf";
        this.symbolGreek = this.outputList.getFont();
        this.outputList.setCellRenderer(new MyCellRenderer(this.symbolGreek));
        this.jRadioButton2.setSelected(true);
        new FileDrop(this, new FileDrop.Listener(){

            public void filesDropped(File[] files) {
                int dirCount = 0;
                int fileCount = 0;
                if (files.length == 1) {
                    fileCount = dirCount = App.this.transFolderName1.getText().length() > 0 ? 1 : 0;
                }
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.isDirectory()) {
                        if (dirCount == 0) {
                            App.this.transFolderPath1 = App.this.setTransFolderPath(f, App.this.transFolderName1, App.this.transFileNameModel1, App.this.transFileName1);
                            App.this.transFolderPath2 = App.this.setTransFolderPath(f, App.this.transFolderName2, App.this.transFileNameModel2, App.this.transFileName2);
                        } else {
                            App.this.transFolderPath2 = App.this.setTransFolderPath(f, App.this.transFolderName2, App.this.transFileNameModel2, App.this.transFileName2);
                        }
                        ++dirCount;
                    } else {
                        if (dirCount == 0) {
                            App.this.transFolderPath1 = App.this.setTransFolderPath(f.getParentFile(), App.this.transFolderName1, App.this.transFileNameModel1, App.this.transFileName1);
                            App.this.transFolderPath2 = App.this.setTransFolderPath(f.getParentFile(), App.this.transFolderName2, App.this.transFileNameModel2, App.this.transFileName2);
                            App.this.transFileName1.setSelectedValue(f.getName(), true);
                            ++dirCount;
                        } else {
                            App.this.transFolderPath2 = App.this.setTransFolderPath(f.getParentFile(), App.this.transFolderName2, App.this.transFileNameModel2, App.this.transFileName2);
                            App.this.transFileName2.setSelectedValue(f.getName(), true);
                            ++dirCount;
                        }
                        ++fileCount;
                    }
                    System.out.println(f.getAbsolutePath());
                    ++n2;
                }
            }
        });
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jButton3 = new JButton();
        this.jPanel7 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel8 = new JPanel();
        this.jPanel9 = new JPanel();
        this.jPanel10 = new JPanel();
        this.jPanel11 = new JPanel();
        this.transFolderName1 = new JLabel();
        this.jButton4 = new JButton();
        this.jLabel4 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.transFileName1 = new JList();
        this.jPanel12 = new JPanel();
        this.jPanel13 = new JPanel();
        this.jPanel14 = new JPanel();
        this.transFolderName2 = new JLabel();
        this.jButton5 = new JButton();
        this.jLabel5 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.transFileName2 = new JList();
        this.jScrollPane1 = new JScrollPane();
        this.outputList = new JList();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.contentsMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 3));
        this.jPanel1.add((Component)this.jPanel2, "North");
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel6.setLayout(new FlowLayout(2));
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setText("Unicode");
        this.jPanel6.add(this.jRadioButton1);
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.setText("Symbol Greek Transform");
        this.jRadioButton2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                App.this.jRadioButton2StateChanged(evt);
            }
        });
        this.jPanel6.add(this.jRadioButton2);
        this.jButton3.setText("Check Transcriptions");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                App.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jButton3);
        this.jPanel3.add((Component)this.jPanel6, "North");
        this.jPanel7.setLayout(new BorderLayout());
        this.jPanel8.setLayout(new BoxLayout(this.jPanel8, 3));
        this.jPanel9.setLayout(new BorderLayout());
        this.jPanel10.setLayout(new BorderLayout(3, 0));
        this.jPanel11.setLayout(new BorderLayout());
        this.transFolderName1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.transFolderName1.setHorizontalTextPosition(4);
        this.jPanel11.add((Component)this.transFolderName1, "Center");
        this.jButton4.setLabel("...");
        this.jButton4.setMargin(new Insets(2, 4, 2, 4));
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                App.this.jButton4ActionPerformed(evt);
            }
        });
        this.jPanel11.add((Component)this.jButton4, "East");
        this.jLabel4.setFont(new Font("Ubuntu", 1, 15));
        this.jLabel4.setText("Transcription 1");
        this.jPanel11.add((Component)this.jLabel4, "North");
        this.jPanel10.add((Component)this.jPanel11, "North");
        this.transFileName1.setModel(new AbstractListModel(){
            String[] strings = new String[]{" "};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.transFileName1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                App.this.transFileName1ValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.transFileName1);
        this.jPanel10.add((Component)this.jScrollPane2, "Center");
        this.jPanel9.add((Component)this.jPanel10, "Center");
        this.jPanel8.add(this.jPanel9);
        this.jPanel12.setLayout(new BorderLayout());
        this.jPanel13.setLayout(new BorderLayout(3, 0));
        this.jPanel14.setLayout(new BorderLayout());
        this.transFolderName2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel14.add((Component)this.transFolderName2, "Center");
        this.jButton5.setLabel("...");
        this.jButton5.setMargin(new Insets(2, 4, 2, 4));
        this.jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                App.this.jButton5ActionPerformed(evt);
            }
        });
        this.jPanel14.add((Component)this.jButton5, "East");
        this.jLabel5.setFont(new Font("Ubuntu", 1, 15));
        this.jLabel5.setText("Transcription 2");
        this.jPanel14.add((Component)this.jLabel5, "North");
        this.jPanel13.add((Component)this.jPanel14, "North");
        this.transFileName2.setModel(new AbstractListModel(){
            String[] strings = new String[]{" "};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane3.setViewportView(this.transFileName2);
        this.jPanel13.add((Component)this.jScrollPane3, "Center");
        this.jPanel12.add((Component)this.jPanel13, "Center");
        this.jPanel8.add(this.jPanel12);
        this.jSplitPane1.setLeftComponent(this.jPanel8);
        this.outputList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.outputList);
        this.jSplitPane1.setRightComponent(this.jScrollPane1);
        this.jPanel7.add((Component)this.jSplitPane1, "Center");
        this.jPanel3.add((Component)this.jPanel7, "Center");
        this.jPanel1.add((Component)this.jPanel3, "Center");
        this.jTabbedPane1.addTab("Reconcile Transcriptions", this.jPanel1);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.fileMenu.setText("File");
        this.openMenuItem.setText("Open");
        this.fileMenu.add(this.openMenuItem);
        this.saveMenuItem.setText("Save");
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem.setText("Save As ...");
        this.fileMenu.add(this.saveAsMenuItem);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                App.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.cutMenuItem.setText("Cut");
        this.editMenu.add(this.cutMenuItem);
        this.copyMenuItem.setText("Copy");
        this.editMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setText("Paste");
        this.editMenu.add(this.pasteMenuItem);
        this.deleteMenuItem.setText("Delete");
        this.editMenu.add(this.deleteMenuItem);
        this.menuBar.add(this.editMenu);
        this.helpMenu.setText("Help");
        this.contentsMenuItem.setText("Contents");
        this.helpMenu.add(this.contentsMenuItem);
        this.aboutMenuItem.setText("About");
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void transFileName1ValueChanged(ListSelectionEvent evt) {
        if (this.transFileName1.getSelectedValues().length == 1 && this.transFileName2.getSelectedValues().length == 0 && this.transFolderName2.getText().equals(this.transFolderName1.getText())) {
            this.transFileName2.ensureIndexIsVisible(this.transFileName1.getSelectedIndex());
        }
    }

    private void jRadioButton2StateChanged(ChangeEvent evt) {
        this.bgreekTransform = this.jRadioButton2.isSelected();
        this.outputList.updateUI();
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        JFileChooser dialog = new JFileChooser();
        dialog.setFileSelectionMode(1);
        dialog.setAcceptAllFileFilterUsed(false);
        dialog.setCurrentDirectory(this.transFolderPath2);
        if (dialog.showOpenDialog(this) == 0) {
            try {
                this.transFolderPath2 = this.setTransFolderPath(dialog.getSelectedFile(), this.transFolderName2, this.transFileNameModel2, this.transFileName2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        JFileChooser dialog = new JFileChooser();
        dialog.setFileSelectionMode(1);
        dialog.setAcceptAllFileFilterUsed(false);
        dialog.setCurrentDirectory(this.transFolderPath1);
        if (dialog.showOpenDialog(this) == 0) {
            try {
                this.transFolderPath1 = this.setTransFolderPath(dialog.getSelectedFile(), this.transFolderName1, this.transFileNameModel1, this.transFileName1);
                if (this.transFolderName2.getText().length() < 1) {
                    this.transFolderPath2 = this.setTransFolderPath(dialog.getSelectedFile(), this.transFolderName2, this.transFileNameModel2, this.transFileName2);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    File setTransFolderPath(File newTransFolderPath, JLabel nameDisplay, DefaultListModel filesDisplayModel, JList filesDisplay) {
        if (".".equals(newTransFolderPath.getName())) {
            newTransFolderPath = newTransFolderPath.getParentFile();
        }
        nameDisplay.setText(newTransFolderPath.getName());
        filesDisplayModel.clear();
        Object[] files = newTransFolderPath.listFiles();
        Arrays.sort(files);
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object f = objectArray[n2];
            if (((File)f).isFile() && !((File)f).isHidden()) {
                filesDisplayModel.addElement(((File)f).getName());
            }
            ++n2;
        }
        return newTransFolderPath;
    }

    private static StringBuffer loadInputStream(InputStream is) throws Exception {
        StringBuffer data = new StringBuffer();
        byte[] buffer = new byte[2048];
        int len = 0;
        while ((len = is.read(buffer)) > -1) {
            data.append(new String(buffer, 0, len, "iso8859-1"));
        }
        data = new StringBuffer(data.toString().replaceAll("[\\x0a\\x0d]{1,}", " <br/> "));
        is.close();
        return data;
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        Object o;
        StringBuffer tText = null;
        File transFile = null;
        Vector<String[]> out = new Vector<String[]>();
        CollateXEngine engine = new CollateXEngine();
        Vector<IWitness> witnesses = new Vector<IWitness>();
        int docCount = 0;
        Object[] objectArray = this.transFileName1.getSelectedValues();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            o = objectArray[n2];
            try {
                transFile = new File(this.transFolderPath1, o.toString());
                tText = App.loadInputStream(new FileInputStream(transFile));
                witnesses.add(engine.createWitness("T" + Integer.toString(docCount + 1), tText.toString()));
                ++docCount;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        objectArray = this.transFileName2.getSelectedValues();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            o = objectArray[n2];
            try {
                transFile = new File(this.transFolderPath2, o.toString());
                tText = App.loadInputStream(new FileInputStream(transFile));
                witnesses.add(engine.createWitness("T" + Integer.toString(docCount + 1), tText.toString()));
                ++docCount;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        if (witnesses.size() < 2) {
            out.add(new String[]{"Please select 2 transcriptions (min)\nusing the controls \non the left.", "", ""});
            this.outputList.setListData(out);
            return;
        }
        IAlignmentTable table = engine.align(witnesses.toArray(new IWitness[0]));
        ParallelSegmentationApparatus apparatus = engine.createApparatus(table);
        int line = 0;
        String lastLine = "";
        for (ApparatusEntry entry : apparatus.getEntries()) {
            ArrayListMultimap<String, String> content2WitMap = ArrayListMultimap.create();
            for (String sigil : entry.getSigla()) {
                content2WitMap.put(entry.getPhrase(sigil).getContent(), sigil);
            }
            if (content2WitMap.keySet().size() == 1 && !entry.hasEmptyCells()) {
                String segment = (String)content2WitMap.keys().iterator().next();
                int offset = 0;
                while (offset == 0 || offset > 1) {
                    ++line;
                    offset = segment.indexOf("<br/>", offset) + 2;
                }
                int index = segment.lastIndexOf("<br/>");
                lastLine = segment.substring(index > 0 ? index + 5 : 0);
                continue;
            }
            HashMap readings = Maps.newHashMap();
            for (String content : content2WitMap.keySet()) {
                readings.put(content, Sets.newTreeSet(content2WitMap.get(content)));
            }
            TreeMap<String, String> readingMap = Maps.newTreeMap();
            for (Map.Entry reading : readings.entrySet()) {
                readingMap.put(Joiner.on(" ").join(Iterables.transform((Iterable)reading.getValue(), new Function<String, String>(){

                    @Override
                    public String apply(String from) {
                        return from.startsWith("#") ? from : "#" + from;
                    }
                })), (String)reading.getKey());
            }
            out.add(new String[]{"", "", ""});
            out.add(new String[]{"______________________________", "", ""});
            out.add(new String[]{"line " + line + ":", "", ""});
            for (Map.Entry reading : readingMap.entrySet()) {
                String content = (String)reading.getValue();
                out.add(new String[]{String.valueOf(((String)reading.getKey()).replaceAll("\n", "")) + ": ", String.valueOf(lastLine) + " ", content.isEmpty() ? "" : content});
            }
            --line;
        }
        if (out.size() < 1) {
            out.add(new String[]{"Documents have no differences.", "", ""});
        }
        this.outputList.setListData(out);
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new App().setVisible(true);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Font loadFont(String url) {
        Font font = null;
        if (url.length() <= 2) return font;
        InputStream is = null;
        try {
            try {
                URLConnection connection = new URL(url).openConnection();
                is = connection.getInputStream();
                font = this.loadFont(is);
                return font;
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
                if (is == null) return font;
                try {
                    is.close();
                    return font;
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
                return font;
            }
            catch (FontFormatException e) {
                e.printStackTrace(System.err);
                if (is == null) return font;
                try {
                    is.close();
                    return font;
                }
                catch (IOException e2) {
                    e2.printStackTrace(System.err);
                }
                return font;
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    public Font loadFont(InputStream is) throws FontFormatException, IOException {
        Font font = Font.createFont(0, is);
        return font;
    }

    class MyCellRenderer
    extends JPanel
    implements ListCellRenderer {
        JLabel left;
        JTextArea middle;
        JTextArea error;
        Font font;

        MyCellRenderer(Font inFont) {
            this.font = inFont.deriveFont(16.0f);
            FlowLayout layout = new FlowLayout(0);
            this.setLayout(layout);
            this.left = new JLabel();
            this.left.setMinimumSize(new Dimension(40, 10));
            this.middle = new JTextArea();
            this.error = new JTextArea();
            this.left.setOpaque(false);
            this.middle.setOpaque(false);
            this.error.setOpaque(false);
            this.error.setForeground(Color.RED);
            this.add(this.left);
            this.add(this.middle);
            this.add(this.error);
        }

        public void setJTextPaneFont(JTextPane jtp, Font font, Color c) {
            MutableAttributeSet attrs = jtp.getInputAttributes();
            StyleConstants.setFontFamily(attrs, font.getFamily());
            StyleConstants.setFontSize(attrs, font.getSize());
            StyleConstants.setItalic(attrs, (font.getStyle() & 2) != 0);
            StyleConstants.setBold(attrs, (font.getStyle() & 1) != 0);
            StyleConstants.setForeground(attrs, c);
            StyledDocument doc = jtp.getStyledDocument();
            doc.setCharacterAttributes(0, doc.getLength() + 1, attrs, false);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String leftData = ((String[])value)[0];
            String middleData = ((String[])value)[1];
            String errData = ((String[])value)[2];
            this.left.setText(leftData);
            this.middle.setText(App.this.bgreekTransform ? Convert.translate(middleData) : middleData);
            this.error.setText(App.this.bgreekTransform ? Convert.translate(errData) : errData);
            return this;
        }
    }
}

