/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.dekker;

import eu.interedition.collatex.VariantGraph;
import eu.interedition.collatex.dekker.Match;
import eu.interedition.collatex.simple.SimpleToken;
import eu.interedition.collatex.util.VariantGraphRanking;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TranspositionDetector {
    private Map<List<Match>, Integer> phraseMatchToIndex;

    public List<List<Match>> detect(List<List<Match>> phraseMatches, VariantGraph base) {
        if (phraseMatches.isEmpty()) {
            return new ArrayList<List<Match>>();
        }
        VariantGraphRanking ranking = this.rankTheGraph(phraseMatches, base);
        Comparator comp = (pm1, pm2) -> {
            int rank2;
            int rank1 = ranking.apply(((Match)pm1.get((int)0)).vertex);
            int difference = rank1 - (rank2 = ranking.apply(((Match)pm2.get((int)0)).vertex).intValue());
            if (difference != 0) {
                return difference;
            }
            int index1 = phraseMatches.indexOf(pm1);
            int index2 = phraseMatches.indexOf(pm2);
            return index1 - index2;
        };
        ArrayList<List<Match>> phraseMatchesGraphOrder = new ArrayList<List<Match>>(phraseMatches);
        Collections.sort(phraseMatchesGraphOrder, comp);
        this.phraseMatchToIndex = new HashMap<List<Match>, Integer>();
        for (int i = 0; i < phraseMatchesGraphOrder.size(); ++i) {
            this.phraseMatchToIndex.put((List<Match>)phraseMatchesGraphOrder.get(i), i);
        }
        ArrayList<Integer> phraseMatchesGraphIndex = new ArrayList<Integer>();
        ArrayList<Integer> phraseMatchesWitnessIndex = new ArrayList<Integer>();
        for (int i = 0; i < phraseMatches.size(); ++i) {
            phraseMatchesGraphIndex.add(i);
        }
        for (List<Match> phraseMatch : phraseMatches) {
            phraseMatchesWitnessIndex.add(this.phraseMatchToIndex.get(phraseMatch));
        }
        ArrayList<List<Match>> nonTransposedPhraseMatches = new ArrayList<List<Match>>(phraseMatches);
        ArrayList<List<Match>> transpositions = new ArrayList<List<Match>>();
        while (true) {
            LinkedHashMap<List, Integer> phraseMatchToDistanceMap = new LinkedHashMap<List, Integer>();
            for (int i = 0; i < nonTransposedPhraseMatches.size(); ++i) {
                Integer graphIndex = (Integer)phraseMatchesGraphIndex.get(i);
                Integer witnessIndex = (Integer)phraseMatchesWitnessIndex.get(i);
                Integer distance = Math.abs(graphIndex - witnessIndex);
                List phraseMatch = (List)nonTransposedPhraseMatches.get(i);
                phraseMatchToDistanceMap.put(phraseMatch, distance);
            }
            ArrayList distanceList = new ArrayList(phraseMatchToDistanceMap.values());
            if (distanceList.isEmpty() || (Integer)Collections.max(distanceList) == 0) break;
            Comparator comp2 = (pm1, pm2) -> {
                int distance1 = (Integer)phraseMatchToDistanceMap.get(pm1);
                int distance2 = (Integer)phraseMatchToDistanceMap.get(pm2);
                int difference = distance2 - distance1;
                if (difference != 0) {
                    return difference;
                }
                return this.determineSize((List<Match>)pm1) - this.determineSize((List<Match>)pm2);
            };
            ArrayList<List<Match>> sortedPhraseMatches = new ArrayList<List<Match>>(nonTransposedPhraseMatches);
            Collections.sort(sortedPhraseMatches, comp2);
            List transposedPhrase = (List)sortedPhraseMatches.remove(0);
            Integer transposedIndex = this.phraseMatchToIndex.get(transposedPhrase);
            Integer graphIndex = phraseMatchesGraphIndex.indexOf(transposedIndex);
            Integer transposedWithIndex = (Integer)phraseMatchesWitnessIndex.get(graphIndex);
            List linkedTransposedPhrase = (List)phraseMatchesGraphOrder.get(transposedWithIndex);
            this.addTransposition(phraseMatchesWitnessIndex, phraseMatchesGraphIndex, nonTransposedPhraseMatches, transpositions, transposedPhrase);
            Integer distance = (Integer)phraseMatchToDistanceMap.get(transposedPhrase);
            if (distance != phraseMatchToDistanceMap.get(linkedTransposedPhrase) || distance <= 1) continue;
            this.addTransposition(phraseMatchesWitnessIndex, phraseMatchesGraphIndex, nonTransposedPhraseMatches, transpositions, linkedTransposedPhrase);
        }
        return transpositions;
    }

    private void addTransposition(List<Integer> phraseWitnessRanks, List<Integer> phraseGraphRanks, List<List<Match>> nonTransposedPhraseMatches, List<List<Match>> transpositions, List<Match> transposedPhrase) {
        Integer indexToRemove = this.phraseMatchToIndex.get(transposedPhrase);
        nonTransposedPhraseMatches.remove(transposedPhrase);
        transpositions.add(transposedPhrase);
        phraseGraphRanks.remove(indexToRemove);
        phraseWitnessRanks.remove(indexToRemove);
    }

    private VariantGraphRanking rankTheGraph(List<List<Match>> phraseMatches, VariantGraph base) {
        HashSet<VariantGraph.Vertex> matchedVertices = new HashSet<VariantGraph.Vertex>();
        for (List<Match> phraseMatch : phraseMatches) {
            matchedVertices.add(phraseMatch.get((int)0).vertex);
        }
        VariantGraphRanking ranking = VariantGraphRanking.ofOnlyCertainVertices(base, matchedVertices);
        return ranking;
    }

    private int determineSize(List<Match> t) {
        Match firstMatch = t.get(0);
        if (!(firstMatch.token instanceof SimpleToken)) {
            return t.size();
        }
        int charLength = 0;
        for (Match m : t) {
            SimpleToken token = (SimpleToken)m.token;
            charLength += token.getNormalized().length();
        }
        return charLength;
    }
}

