/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.dekker.island;

import eu.interedition.collatex.Token;
import eu.interedition.collatex.dekker.island.Coordinate;
import eu.interedition.collatex.dekker.token_index.Block;
import eu.interedition.collatex.simple.SimpleToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Island
implements Iterable<Coordinate> {
    private final List<Coordinate> islandCoordinates = new ArrayList<Coordinate>();
    private final Block.Instance blockInstance;

    public Island(Block.Instance blockInstance) {
        this.blockInstance = blockInstance;
    }

    public Island() {
        this.blockInstance = null;
    }

    public Island(Coordinate first, Coordinate last) {
        this.blockInstance = null;
        this.add(first);
        Coordinate newCoordinate = first;
        while (!newCoordinate.equals(last)) {
            newCoordinate = new Coordinate(newCoordinate.getRow() + 1, newCoordinate.getColumn() + 1);
            this.add(newCoordinate);
        }
    }

    public void add(Coordinate coordinate) {
        this.islandCoordinates.add(coordinate);
    }

    public void removeCoordinate(Coordinate c) {
        this.islandCoordinates.remove(c);
    }

    public boolean isCompetitor(Island isl) {
        for (Coordinate c : isl) {
            for (Coordinate d : this.islandCoordinates) {
                if (!c.sameColumn(d) && !c.sameRow(d)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(Coordinate c) {
        return this.islandCoordinates.contains(c);
    }

    public Coordinate getLeftEnd() {
        Coordinate coor = this.islandCoordinates.get(0);
        for (Coordinate c : this.islandCoordinates) {
            if (c.column >= coor.column) continue;
            coor = c;
        }
        return coor;
    }

    public Coordinate getRightEnd() {
        Coordinate coor = this.islandCoordinates.get(0);
        for (Coordinate c : this.islandCoordinates) {
            if (c.column <= coor.column) continue;
            coor = c;
        }
        return coor;
    }

    public int size() {
        return this.islandCoordinates.size();
    }

    @Override
    public Iterator<Coordinate> iterator() {
        return Collections.unmodifiableList(this.islandCoordinates).iterator();
    }

    public int hashCode() {
        return this.islandCoordinates.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(Island.class)) {
            return false;
        }
        Island isl = (Island)obj;
        if (isl.size() != this.size()) {
            return false;
        }
        boolean result = true;
        for (Coordinate c : isl) {
            result &= this.contains(c);
        }
        return result;
    }

    public Block.Instance getBlockInstance() {
        if (this.blockInstance == null) {
            throw new RuntimeException("Block instance is not set on this island! It is probably constructed with legacy code!");
        }
        return this.blockInstance;
    }

    public int getDepth() {
        return this.getBlockInstance().block.getDepth();
    }

    public String toString() {
        List<Token> instance = this.getBlockInstance().getTokens();
        String normalized = "";
        for (int i = 0; i < this.size(); ++i) {
            Token t = instance.get(i);
            SimpleToken st = (SimpleToken)t;
            if (!normalized.isEmpty()) {
                normalized = normalized + " ";
            }
            normalized = normalized + st.getNormalized();
        }
        return normalized;
    }
}

