/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.dekker.island;

import eu.interedition.collatex.VariantGraph;
import eu.interedition.collatex.dekker.island.Archipelago;
import eu.interedition.collatex.dekker.island.Coordinate;
import eu.interedition.collatex.dekker.island.Island;
import eu.interedition.collatex.dekker.island.IslandSelection;
import eu.interedition.collatex.dekker.island.IslandSizeComparator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IslandCollection
implements IslandSelection {
    Logger LOG = Logger.getLogger(IslandCollection.class.getName());
    private final PriorityQueue<Island> islandPriorityQueue;
    private final Archipelago fixedIslands;
    private final BitSet fixedRows;
    private final Set<VariantGraph.Vertex> fixedVertices;
    private final Comparator<Island> comparator = new IslandSizeComparator();

    public IslandCollection(Set<Island> islands) {
        this.fixedRows = new BitSet();
        this.fixedVertices = new HashSet<VariantGraph.Vertex>();
        this.fixedIslands = new Archipelago();
        this.islandPriorityQueue = new PriorityQueue<Island>(this.comparator);
        this.islandPriorityQueue.addAll(islands);
    }

    @Override
    public boolean doesCoordinateOverlapWithCommittedCoordinate(Coordinate coordinate) {
        return this.fixedRows.get(coordinate.row) || this.fixedVertices.contains(coordinate.match.vertex);
    }

    @Override
    public boolean isIslandPossibleCandidate(Island island) {
        for (Coordinate coordinate : island) {
            if (!this.doesCoordinateOverlapWithCommittedCoordinate(coordinate)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addIsland(Island isl) {
        if (this.LOG.isLoggable(Level.FINE)) {
            this.LOG.log(Level.FINE, "adding island: '{0}'", isl);
        }
        for (Coordinate coordinate : isl) {
            this.fixedRows.set(coordinate.row);
            this.fixedVertices.add(coordinate.match.vertex);
        }
        this.fixedIslands.add(isl);
    }

    @Override
    public boolean doesCandidateLayOnVectorOfCommittedIsland(Island island) {
        Coordinate leftEnd = island.getLeftEnd();
        return this.fixedIslands.getIslandVectors().contains(leftEnd.row - leftEnd.column);
    }

    @Override
    public int size() {
        return this.fixedIslands.size();
    }

    @Override
    public List<Island> getIslands() {
        return this.fixedIslands.getIslands();
    }

    @Override
    public boolean containsCoordinate(int row, int column) {
        return this.fixedIslands.containsCoordinate(row, column);
    }

    @Override
    public List<Island> getPossibleIslands() {
        ArrayList<Island> possibleIslands = new ArrayList<Island>();
        while (possibleIslands.isEmpty() && !this.islandPriorityQueue.isEmpty()) {
            Island highestRated = this.islandPriorityQueue.poll();
            possibleIslands.add(highestRated);
            while (!this.islandPriorityQueue.isEmpty() && this.comparator.compare(highestRated, this.islandPriorityQueue.peek()) == 0) {
                possibleIslands.add(this.islandPriorityQueue.poll());
            }
            this.checkPossibleIslandsForRightOverlap(possibleIslands);
        }
        return possibleIslands;
    }

    private void checkPossibleIslandsForRightOverlap(List<Island> possibleIslands) {
        Iterator<Island> candidates = possibleIslands.iterator();
        while (candidates.hasNext()) {
            Island island = candidates.next();
            if (this.doesCoordinateOverlapWithCommittedCoordinate(island.getLeftEnd())) {
                candidates.remove();
                continue;
            }
            if (!this.doesCoordinateOverlapWithCommittedCoordinate(island.getRightEnd())) continue;
            candidates.remove();
            Island smaller = this.findConflictingCoordinateAndCreateSmallerIslandSplitAtConflictingCoordinate(island);
            this.islandPriorityQueue.add(smaller);
        }
    }

    private Island findConflictingCoordinateAndCreateSmallerIslandSplitAtConflictingCoordinate(Island island) {
        Island smaller = new Island(island.getBlockInstance());
        for (Coordinate coordinate : island) {
            if (this.doesCoordinateOverlapWithCommittedCoordinate(coordinate)) {
                return smaller;
            }
            smaller.add(coordinate);
        }
        throw new RuntimeException("Expected a conflict! This should never happen!");
    }
}

