/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.dekker.token_index;

import eu.interedition.collatex.Token;
import eu.interedition.collatex.Witness;
import eu.interedition.collatex.dekker.token_index.TokenIndex;
import eu.interedition.collatex.simple.SimpleToken;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.IntStream;

public class Block {
    private final TokenIndex tokenIndex;
    public final int length;
    public final int start;
    public final int end;
    private Integer depth;

    public Block(TokenIndex tokenIndex, int suffix_start_position, int length) {
        this.tokenIndex = tokenIndex;
        this.start = suffix_start_position;
        this.length = length;
        this.end = 0;
        this.depth = 0;
    }

    public Block(TokenIndex tokenIndex, int start, int end, int length) {
        this.tokenIndex = tokenIndex;
        this.start = start;
        this.end = end;
        this.length = length;
        this.depth = null;
    }

    public int getDepth() {
        if (this.depth == null) {
            this.depth = this.calculateDepth();
        }
        return this.depth;
    }

    public int getFrequency() {
        if (this.end == 0) {
            throw new IllegalStateException("LCP interval is unclosed!");
        }
        return this.end - this.start + 1;
    }

    public List<Instance> getAllInstances() {
        ArrayList<Instance> instances = new ArrayList<Instance>();
        for (int i = this.start; i <= this.end; ++i) {
            int token_position = this.tokenIndex.suffix_array[i];
            Instance instance = new Instance(token_position, this);
            instances.add(instance);
        }
        return instances;
    }

    public IntStream getAllOccurrencesAsRanges() {
        IntStream result = IntStream.empty();
        for (int i = this.start; i < this.end; ++i) {
            int token_position = this.tokenIndex.suffix_array[i];
            IntStream range = IntStream.range(token_position, token_position + this.length);
            result = IntStream.concat(result, range);
        }
        return result;
    }

    public String toString() {
        if (this.end == 0) {
            return "Unclosed LCP interval start at: " + this.start + ",  length: " + this.length;
        }
        return "LCP interval start at: " + this.start + ", depth: " + this.getDepth() + ", length: " + this.length + " getFrequency:" + this.getFrequency();
    }

    private int calculateDepth() {
        HashSet<Witness> witnesses = new HashSet<Witness>();
        for (Instance instance : this.getAllInstances()) {
            witnesses.add(instance.getWitness());
        }
        return witnesses.size();
    }

    public static class Instance {
        public final int start_token;
        public final Block block;

        public Instance(int start_token, Block block) {
            this.start_token = start_token;
            this.block = block;
        }

        public int length() {
            return this.block.length;
        }

        public IntStream asRange() {
            return IntStream.range(this.start_token, this.start_token + this.length());
        }

        public String toString() {
            List<Token> tokens = this.getTokens();
            String normalized = "";
            for (Token t : tokens) {
                SimpleToken st = (SimpleToken)t;
                if (!normalized.isEmpty()) {
                    normalized = normalized + " ";
                }
                normalized = normalized + st.getNormalized();
            }
            return normalized;
        }

        public List<Token> getTokens() {
            ArrayList<Token> tokens = new ArrayList<Token>();
            for (int i = 0; i < this.length(); ++i) {
                Token t = ((Block)this.block).tokenIndex.token_array[this.start_token + i];
                tokens.add(t);
            }
            return tokens;
        }

        public Witness getWitness() {
            Token startToken = ((Block)this.block).tokenIndex.token_array[this.start_token];
            return startToken.getWitness();
        }
    }
}

