/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.simple;

import eu.interedition.collatex.simple.SimpleTokenNormalizers;
import eu.interedition.collatex.simple.SimpleWitness;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class SimpleWitnessTeiBuilder {
    private static QName w = new QName("http://www.tei-c.org/ns/1.0", "w");
    private static QName seg = new QName("http://www.tei-c.org/ns/1.0", "seg");
    private static QName p = new QName("http://www.tei-c.org/ns/1.0", "p");

    public SimpleWitness read(InputStream input) throws XMLStreamException {
        SimpleWitness witness = new SimpleWitness("id");
        ArrayList<String> tokenContents = new ArrayList<String>();
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLEventReader reader = factory.createXMLEventReader(input);
        XMLEvent event = null;
        int numberOfParagraphs = 0;
        while ((event = reader.peek()) != null && numberOfParagraphs < 10) {
            if (event.isStartElement() && event.asStartElement().getName().equals(w)) {
                tokenContents.add(SimpleWitnessTeiBuilder.handleWElement(reader));
                continue;
            }
            if (event.isStartElement() && event.asStartElement().getName().equals(seg)) {
                tokenContents.add(SimpleWitnessTeiBuilder.handleSegElement(reader));
                continue;
            }
            if (event.isStartElement() && event.asStartElement().getName().equals(p)) {
                reader.next();
                ++numberOfParagraphs;
                continue;
            }
            reader.next();
        }
        witness.setTokenContents(tokenContents.stream(), SimpleTokenNormalizers.LC_TRIM_WS_PUNCT);
        return witness;
    }

    private static String handleWElement(XMLEventReader reader) throws XMLStreamException {
        XMLEvent event = reader.nextEvent();
        StringBuffer textBuffer = new StringBuffer();
        while ((event = reader.peek()) != null) {
            if (event.isEndElement() && event.asEndElement().getName().equals(w)) {
                event = reader.nextEvent();
                break;
            }
            event = reader.nextEvent();
            textBuffer.append(event.toString());
        }
        return textBuffer.toString();
    }

    private static String handleSegElement(XMLEventReader reader) throws XMLStreamException {
        XMLEvent event = reader.nextEvent();
        StringBuffer textBuffer = new StringBuffer();
        while ((event = reader.peek()) != null) {
            if (event.isEndElement() && event.asEndElement().getName().equals(seg)) {
                event = reader.nextEvent();
                break;
            }
            event = reader.nextEvent();
            if (event.getEventType() != 4) continue;
            textBuffer.append(event.toString().trim());
        }
        return textBuffer.toString();
    }
}

