/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.suffixarray;

import eu.interedition.collatex.suffixarray.ISymbolMapper;
import eu.interedition.collatex.suffixarray.MinMax;
import eu.interedition.collatex.suffixarray.Tools;

final class DensePositiveMapper
implements ISymbolMapper {
    private final int offset;
    private final int[] forward;
    private final int[] backward;

    public DensePositiveMapper(int[] input, int start, int length) {
        MinMax minmax = Tools.minmax(input, start, length);
        int min = minmax.min;
        int max = minmax.max;
        int[] forward = new int[max - min + 1];
        int offset = -min;
        int end = start + length;
        for (int i = start; i < end; ++i) {
            forward[input[i] + offset] = 1;
        }
        int k = 1;
        for (int i = 0; i < forward.length; ++i) {
            if (forward[i] == 0) continue;
            forward[i] = k++;
        }
        int[] backward = new int[k];
        for (int i = start; i < end; ++i) {
            int v = forward[input[i] + offset];
            backward[v] = input[i];
        }
        this.offset = offset;
        this.forward = forward;
        this.backward = backward;
    }

    @Override
    public void map(int[] input, int start, int length) {
        int i = start;
        int l = length;
        while (l > 0) {
            input[i] = this.forward[input[i] + this.offset];
            --l;
            ++i;
        }
    }

    @Override
    public void undo(int[] input, int start, int length) {
        int i = start;
        int l = length;
        while (l > 0) {
            input[i] = this.backward[input[i]];
            --l;
            ++i;
        }
    }
}

