/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.suffixtree;

import eu.interedition.collatex.suffixtree.ActivePoint;
import eu.interedition.collatex.suffixtree.Edge;
import eu.interedition.collatex.suffixtree.Node;
import eu.interedition.collatex.suffixtree.Sequence;
import eu.interedition.collatex.suffixtree.Suffix;
import eu.interedition.collatex.suffixtree.Utils;

public class SuffixTree<I, S extends Iterable<I>> {
    private final Node<I, S> root;
    private final Sequence<I, S> sequence;
    private Suffix<I, S> suffix;
    private final ActivePoint<I, S> activePoint;
    private int currentEnd = 0;
    private int insertsThisStep = 0;
    private Node<I, S> lastNodeInserted = null;

    public SuffixTree() {
        this.sequence = new Sequence();
        this.root = new Node<I, S>(null, this.sequence, this);
        this.activePoint = new ActivePoint<I, S>(this.root);
    }

    public SuffixTree(S sequenceArray) {
        this.sequence = new Sequence(sequenceArray);
        this.root = new Node<I, S>(null, this.sequence, this);
        this.activePoint = new ActivePoint<I, S>(this.root);
        this.suffix = new Suffix<I, S>(0, 0, this.sequence);
        this.extendTree(0, this.sequence.getLength());
    }

    public void add(S sequence) {
        int start = this.currentEnd;
        this.sequence.add(sequence);
        this.suffix = new Suffix<I, S>(this.currentEnd, this.currentEnd, this.sequence);
        this.activePoint.setPosition(this.root, null, 0);
        this.extendTree(start, this.sequence.getLength());
    }

    private void extendTree(int from, int to) {
        for (int i = from; i < to; ++i) {
            this.suffix.increment();
            this.insertsThisStep = 0;
            this.insert(this.suffix);
            ++this.currentEnd;
        }
    }

    void insert(Suffix<I, S> suffix) {
        if (this.activePoint.isNode()) {
            Node<I, S> node = this.activePoint.getNode();
            node.insert(suffix, this.activePoint);
        } else if (this.activePoint.isEdge()) {
            Edge<I, S> edge = this.activePoint.getEdge();
            edge.insert(suffix, this.activePoint);
        }
    }

    int getCurrentEnd() {
        return this.currentEnd;
    }

    Node<I, S> getRoot() {
        return this.root;
    }

    void incrementInsertCount() {
        ++this.insertsThisStep;
    }

    boolean isNotFirstInsert() {
        return this.insertsThisStep > 0;
    }

    Node<I, S> getLastNodeInserted() {
        return this.lastNodeInserted;
    }

    void setLastNodeInserted(Node<I, S> node) {
        this.lastNodeInserted = node;
    }

    void setSuffixLink(Node<I, S> node) {
        if (this.isNotFirstInsert()) {
            this.lastNodeInserted.setSuffixLink(node);
        }
        this.lastNodeInserted = node;
    }

    public String toString() {
        return Utils.printTreeForGraphViz(this);
    }

    Sequence<I, S> getSequence() {
        return this.sequence;
    }
}

