/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.dekker;

import eu.interedition.collatex.CollationAlgorithm;
import eu.interedition.collatex.Token;
import eu.interedition.collatex.VariantGraph;
import eu.interedition.collatex.Witness;
import eu.interedition.collatex.dekker.InspectableCollationAlgorithm;
import eu.interedition.collatex.dekker.Match;
import eu.interedition.collatex.dekker.PhraseMatchDetector;
import eu.interedition.collatex.dekker.TranspositionDetector;
import eu.interedition.collatex.dekker.island.Coordinate;
import eu.interedition.collatex.dekker.island.Island;
import eu.interedition.collatex.dekker.island.IslandCollection;
import eu.interedition.collatex.dekker.island.IslandConflictResolver;
import eu.interedition.collatex.dekker.token_index.TokenIndex;
import eu.interedition.collatex.dekker.token_index.TokenIndexToMatches;
import eu.interedition.collatex.matching.EqualityTokenComparator;
import eu.interedition.collatex.util.VariantGraphRanking;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class DekkerAlgorithm
extends CollationAlgorithm.Base
implements InspectableCollationAlgorithm {
    public TokenIndex tokenIndex;
    protected VariantGraph.Vertex[] vertex_array;
    private final Comparator<Token> comparator;
    private final PhraseMatchDetector phraseMatchDetector;
    private final TranspositionDetector transpositionDetector;
    private Set<Island> allPossibleIslands;
    private List<Island> preferredIslands;
    private List<List<Match>> phraseMatches;
    private List<List<Match>> transpositions;
    private boolean mergeTranspositions = false;

    public DekkerAlgorithm() {
        this(new EqualityTokenComparator());
    }

    public DekkerAlgorithm(Comparator<Token> comparator) {
        this.comparator = comparator;
        this.phraseMatchDetector = new PhraseMatchDetector();
        this.transpositionDetector = new TranspositionDetector();
    }

    @Override
    public void collate(VariantGraph graph, List<? extends Iterable<Token>> witnesses) {
        if (this.LOG.isLoggable(Level.FINE)) {
            this.LOG.fine("Building token index from the tokens of all witnesses");
        }
        this.tokenIndex = new TokenIndex(this.comparator, witnesses);
        this.tokenIndex.prepare();
        this.vertex_array = new VariantGraph.Vertex[this.tokenIndex.token_array.length];
        boolean firstWitness = true;
        for (Iterable<Token> iterable : witnesses) {
            Witness witness = StreamSupport.stream(iterable.spliterator(), false).findFirst().map(Token::getWitness).orElseThrow(() -> new IllegalArgumentException("Empty witness"));
            if (firstWitness) {
                super.merge(graph, iterable, Collections.emptyMap());
                this.updateTokenToVertexArray(iterable, witness);
                firstWitness = false;
                continue;
            }
            if (this.LOG.isLoggable(Level.FINER)) {
                this.LOG.log(Level.FINER, "{0} + {1}: {2} vs. {3}", new Object[]{graph, witness, graph.vertices(), iterable});
            }
            if (this.LOG.isLoggable(Level.FINE)) {
                this.LOG.log(Level.FINE, "{0} + {1}: Gather matches between variant graph and witness from token index", new Object[]{graph, witness});
            }
            this.allPossibleIslands = TokenIndexToMatches.createMatches(this.tokenIndex, this.vertex_array, graph, iterable);
            if (this.LOG.isLoggable(Level.FINE)) {
                this.LOG.log(Level.FINE, "{0} + {1}: Aligning witness and graph", new Object[]{graph, witness});
            }
            IslandConflictResolver resolver = new IslandConflictResolver(new IslandCollection(this.allPossibleIslands));
            this.preferredIslands = resolver.createNonConflictingVersion().getIslands();
            HashMap<Token, VariantGraph.Vertex> alignments = new HashMap<Token, VariantGraph.Vertex>();
            for (Island island : this.preferredIslands) {
                for (Coordinate coordinate : island) {
                    alignments.put(coordinate.match.token, coordinate.match.vertex);
                }
            }
            if (this.LOG.isLoggable(Level.FINER)) {
                for (Map.Entry entry : alignments.entrySet()) {
                    this.LOG.log(Level.FINER, "{0} + {1}: Aligned token (incl transposed): {2} = {3}", new Object[]{graph, witness, entry.getValue(), entry.getKey()});
                }
            }
            if (this.LOG.isLoggable(Level.FINE)) {
                this.LOG.log(Level.FINE, "{0} + {1}: Detect phrase matches", new Object[]{graph, witness});
            }
            this.phraseMatches = this.phraseMatchDetector.detect(alignments, graph, iterable);
            if (this.LOG.isLoggable(Level.FINER)) {
                for (List list : this.phraseMatches) {
                    this.LOG.log(Level.FINER, "{0} + {1}: Phrase match: {2}", new Object[]{graph, witness, list});
                }
            }
            if (this.LOG.isLoggable(Level.FINE)) {
                this.LOG.log(Level.FINE, "{0} + {1}: Detect transpositions", new Object[]{graph, witness});
            }
            this.transpositions = this.transpositionDetector.detect(this.phraseMatches, graph);
            if (this.LOG.isLoggable(Level.FINE)) {
                this.LOG.log(Level.FINE, "transpositions:{0}", this.transpositions);
            }
            if (this.LOG.isLoggable(Level.FINER)) {
                for (List list : this.transpositions) {
                    this.LOG.log(Level.FINER, "{0} + {1}: Transposition: {2}", new Object[]{graph, witness, list});
                }
            }
            if (this.LOG.isLoggable(Level.FINE)) {
                this.LOG.log(Level.FINE, "{0} + {1}: Determine aligned tokens by filtering transpositions", new Object[]{graph, witness});
            }
            for (List list : this.transpositions) {
                for (Match match : list) {
                    alignments.remove(match.token);
                }
            }
            if (this.LOG.isLoggable(Level.FINER)) {
                for (Map.Entry entry : alignments.entrySet()) {
                    this.LOG.log(Level.FINER, "{0} + {1}: Alignment: {2} = {3}", new Object[]{graph, witness, entry.getValue(), entry.getKey()});
                }
            }
            this.merge(graph, iterable, alignments);
            ArrayList<List> falseTranspositions = new ArrayList<List>();
            VariantGraphRanking variantGraphRanking = VariantGraphRanking.of(graph);
            for (List list : this.transpositions) {
                Match match = (Match)list.get(0);
                VariantGraph.Vertex v1 = (VariantGraph.Vertex)this.witnessTokenVertices.get(match.token);
                VariantGraph.Vertex v2 = match.vertex;
                int distance = Math.abs(variantGraphRanking.apply(v1) - variantGraphRanking.apply(v2)) - 1;
                if (distance <= list.size() * 3) continue;
                falseTranspositions.add(list);
            }
            for (List list : falseTranspositions) {
                this.transpositions.remove(list);
            }
            if (this.mergeTranspositions) {
                this.mergeTranspositions(graph, this.transpositions);
            }
            this.updateTokenToVertexArray(iterable, witness);
            if (!this.LOG.isLoggable(Level.FINER)) continue;
            this.LOG.log(Level.FINER, "!{0}: {1}", new Object[]{graph, StreamSupport.stream(graph.vertices().spliterator(), false).map(Object::toString).collect(Collectors.joining(", "))});
        }
    }

    private void updateTokenToVertexArray(Iterable<Token> tokens, Witness witness) {
        int tokenPosition = this.tokenIndex.getStartTokenPositionForWitness(witness);
        for (Token token : tokens) {
            VariantGraph.Vertex vertex;
            this.vertex_array[tokenPosition] = vertex = (VariantGraph.Vertex)this.witnessTokenVertices.get(token);
            ++tokenPosition;
        }
    }

    @Override
    public void collate(VariantGraph graph, Iterable<Token> tokens) {
        throw new RuntimeException("Progressive alignment is not supported!");
    }

    @Override
    public List<List<Match>> getPhraseMatches() {
        return Collections.unmodifiableList(this.phraseMatches);
    }

    @Override
    public List<List<Match>> getTranspositions() {
        return Collections.unmodifiableList(this.transpositions);
    }

    public Set<Island> getAllPossibleIslands() {
        return Collections.unmodifiableSet(this.allPossibleIslands);
    }

    public List<Island> getPreferredIslands() {
        return Collections.unmodifiableList(this.preferredIslands);
    }

    @Override
    public void setMergeTranspositions(boolean b) {
        this.mergeTranspositions = b;
    }
}

