/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.dekker.island;

import eu.interedition.collatex.dekker.island.Coordinate;
import eu.interedition.collatex.dekker.island.Island;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Archipelago {
    private final List<Island> islands;
    private final Set<Integer> islandvectors;

    public Archipelago() {
        this.islands = new ArrayList<Island>();
        this.islandvectors = new HashSet<Integer>();
    }

    public Archipelago(Archipelago orig) {
        this.islands = new ArrayList<Island>(orig.islands);
        this.islandvectors = new HashSet<Integer>(orig.islandvectors);
    }

    public void add(Island island) {
        this.islands.add(island);
        Coordinate leftEnd = island.getLeftEnd();
        this.islandvectors.add(leftEnd.row - leftEnd.column);
    }

    public int size() {
        return this.islands.size();
    }

    public Island get(int i) {
        return this.islands.get(i);
    }

    public boolean containsCoordinate(int row, int column) {
        return Objects.equals(this.getCoordinatesMap().get(row), column);
    }

    public List<Island> getIslands() {
        return this.islands;
    }

    protected void remove(int i) {
        this.islands.remove(i);
    }

    public String toString() {
        String result = "";
        for (Island island : this.getIslands()) {
            if (result.isEmpty()) {
                result = "[ " + island;
                continue;
            }
            result = result + ", " + island;
        }
        result = result + " ]";
        return result;
    }

    public int hashCode() {
        return Objects.hashCode(this.islands);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        if (((Archipelago)object).size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (((Archipelago)object).get(i).equals(this.get(i))) continue;
            return false;
        }
        return true;
    }

    private Map<Integer, Integer> getCoordinatesMap() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (Island isl : this.islands) {
            for (Coordinate c : isl) {
                map.put(c.getRow(), c.getColumn());
            }
        }
        return map;
    }

    public Set<Integer> getIslandVectors() {
        return this.islandvectors;
    }
}

