/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.dekker.island;

import eu.interedition.collatex.dekker.Match;
import java.util.Objects;

public class Coordinate
implements Comparable<Coordinate> {
    public int row;
    public int column;
    public Match match;

    public Coordinate(int row, int column) {
        this.column = column;
        this.row = row;
        this.match = null;
    }

    public Coordinate(int row, int column, Match match) {
        this.column = column;
        this.row = row;
        this.match = match;
    }

    Coordinate(Coordinate other) {
        this(other.row, other.column);
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public boolean sameColumn(Coordinate c) {
        return c.column == this.column;
    }

    public boolean sameRow(Coordinate c) {
        return c.row == this.row;
    }

    public boolean bordersOn(Coordinate c) {
        return Math.abs(this.row - c.getRow()) == 1 && Math.abs(this.column - c.getColumn()) == 1;
    }

    public boolean equals(Object o) {
        if (o != null & o instanceof Coordinate) {
            Coordinate c = (Coordinate)o;
            return this.row == c.getRow() && this.column == c.getColumn();
        }
        return super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.row, this.column);
    }

    @Override
    public int compareTo(Coordinate o) {
        int result = this.column - o.column;
        return result == 0 ? this.row - o.row : result;
    }

    public String toString() {
        return "(" + this.row + "," + this.column + ")";
    }
}

