/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.dekker.legacy;

import eu.interedition.collatex.Token;
import eu.interedition.collatex.VariantGraph;
import eu.interedition.collatex.dekker.Match;
import eu.interedition.collatex.dekker.island.Coordinate;
import eu.interedition.collatex.dekker.island.Island;
import eu.interedition.collatex.dekker.legacy.MatchTable;
import eu.interedition.collatex.matching.EqualityTokenComparator;
import eu.interedition.collatex.matching.Matches;
import eu.interedition.collatex.util.VariantGraphRanking;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;

public class MatchTableImpl
implements MatchTable {
    private final MatchTableCell[][] table;
    private final Token[] witness;
    private final int[] ranks;

    public static MatchTable create(VariantGraph graph, Iterable<Token> witness) {
        EqualityTokenComparator comparator = new EqualityTokenComparator();
        return MatchTableImpl.create(graph, witness, comparator);
    }

    public static MatchTableImpl create(VariantGraph graph, Iterable<Token> witness, Comparator<Token> comparator) {
        VariantGraphRanking ranking = VariantGraphRanking.of(graph);
        MatchTableImpl table = MatchTableImpl.createEmptyTable(ranking, graph, witness);
        table.fillTableWithMatches(ranking, graph, witness, comparator);
        return table;
    }

    private Optional<MatchTableCell> cell(int rowIndex, int columnIndex) {
        return Optional.ofNullable(this.table[rowIndex][columnIndex]);
    }

    @Override
    public VariantGraph.Vertex vertexAt(int rowIndex, int columnIndex) {
        return this.cell(rowIndex, columnIndex).map(c -> c.vertex).orElse(null);
    }

    @Override
    public Token tokenAt(int rowIndex, int columnIndex) {
        return this.cell(rowIndex, columnIndex).map(c -> c.token).orElse(null);
    }

    @Override
    public List<Token> rowList() {
        return Collections.unmodifiableList(Arrays.asList(this.witness));
    }

    @Override
    public List<Integer> columnList() {
        return Arrays.stream(this.ranks).boxed().collect(Collectors.toList());
    }

    @Override
    public Set<Island> getIslands() {
        HashMap<Coordinate, Island> coordinateMapper = new HashMap<Coordinate, Island>();
        List<Coordinate> allMatches = this.allMatches();
        for (Coordinate c : allMatches) {
            this.addToIslands(coordinateMapper, c);
        }
        HashSet<Coordinate> smallestIslandsCoordinates = new HashSet<Coordinate>(allMatches);
        smallestIslandsCoordinates.removeAll(coordinateMapper.keySet());
        for (Coordinate coordinate : smallestIslandsCoordinates) {
            Island island = new Island();
            island.add(coordinate);
            coordinateMapper.put(coordinate, island);
        }
        return new HashSet<Island>(coordinateMapper.values());
    }

    private MatchTableImpl(Token[] tokens, int[] ranks) {
        this.table = new MatchTableCell[tokens.length][ranks.length];
        this.witness = tokens;
        this.ranks = ranks;
    }

    private static MatchTableImpl createEmptyTable(VariantGraphRanking ranking, VariantGraph graph, Iterable<Token> witness) {
        return new MatchTableImpl((Token[])StreamSupport.stream(witness.spliterator(), false).toArray(Token[]::new), IntStream.range(0, Math.max(0, ranking.apply(graph.getEnd()) - 1)).toArray());
    }

    private void fillTableWithMatches(VariantGraphRanking ranking, VariantGraph graph, Iterable<Token> witness, Comparator<Token> comparator) {
        Matches matches = Matches.between(graph.vertices(), witness, comparator);
        Set<Token> unique = matches.uniqueInWitness;
        Set<Token> ambiguous = matches.ambiguousInWitness;
        int rowIndex = 0;
        for (Token t : witness) {
            if (unique.contains(t) || ambiguous.contains(t)) {
                List matchingVertices = matches.allMatches.getOrDefault(t, Collections.emptyList());
                for (VariantGraph.Vertex vgv : matchingVertices) {
                    this.set(rowIndex, ranking.apply(vgv) - 1, t, vgv);
                }
            }
            ++rowIndex;
        }
    }

    private void set(int rowIndex, int columnIndex, Token token, VariantGraph.Vertex vertex) {
        this.table[rowIndex][columnIndex] = new MatchTableCell(token, vertex);
    }

    private void addToIslands(Map<Coordinate, Island> coordinateMapper, Coordinate c) {
        int diff = -1;
        VariantGraph.Vertex neighbor = null;
        try {
            neighbor = this.vertexAt(c.row + diff, c.column + diff);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (neighbor != null) {
            Coordinate neighborCoordinate = new Coordinate(c.row + diff, c.column + diff, new Match(neighbor, null));
            Island island = coordinateMapper.get(neighborCoordinate);
            if (island == null) {
                Island island0 = new Island();
                island0.add(neighborCoordinate);
                island0.add(c);
                coordinateMapper.put(neighborCoordinate, island0);
                coordinateMapper.put(c, island0);
            } else {
                island.add(c);
                coordinateMapper.put(c, island);
            }
        }
    }

    List<Coordinate> allMatches() {
        ArrayList<Coordinate> pairs = new ArrayList<Coordinate>();
        int rows = this.rowList().size();
        int cols = this.columnList().size();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                VariantGraph.Vertex vertex = this.vertexAt(i, j);
                if (vertex == null) continue;
                pairs.add(new Coordinate(i, j, new Match(vertex, null)));
            }
        }
        return pairs;
    }

    private class MatchTableCell {
        public final Token token;
        public final VariantGraph.Vertex vertex;

        public MatchTableCell(Token token, VariantGraph.Vertex vertex) {
            this.token = token;
            this.vertex = vertex;
        }
    }
}

