/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.dekker.legacy;

import eu.interedition.collatex.Token;
import eu.interedition.collatex.VariantGraph;
import eu.interedition.collatex.dekker.island.Coordinate;
import eu.interedition.collatex.dekker.island.Island;
import eu.interedition.collatex.dekker.island.IslandConflictResolver;
import eu.interedition.collatex.dekker.island.IslandSelection;
import eu.interedition.collatex.dekker.legacy.MatchTableImpl;
import eu.interedition.collatex.dekker.legacy.MatchTableSelection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MatchTableLinker {
    static Logger LOG = Logger.getLogger(MatchTableLinker.class.getName());

    public Map<Token, VariantGraph.Vertex> link(VariantGraph base, Iterable<Token> witness, Comparator<Token> comparator) {
        LOG.fine("create MatchTable and fill it with matches");
        MatchTableImpl table = MatchTableImpl.create(base, witness, comparator);
        LOG.fine("create island conflict resolver");
        IslandConflictResolver resolver = new IslandConflictResolver(new MatchTableSelection(table));
        LOG.fine("select the optimal islands");
        IslandSelection preferredIslands = resolver.createNonConflictingVersion();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Number of preferred Islands: {0}", preferredIslands.size());
        }
        HashMap<Token, VariantGraph.Vertex> map = new HashMap<Token, VariantGraph.Vertex>();
        for (Island island : preferredIslands.getIslands()) {
            for (Coordinate c : island) {
                map.put(table.tokenAt(c.row, c.column), table.vertexAt(c.row, c.column));
            }
        }
        return map;
    }
}

