/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.dekker.legacy;

import eu.interedition.collatex.Token;
import eu.interedition.collatex.dekker.island.Archipelago;
import eu.interedition.collatex.dekker.island.Coordinate;
import eu.interedition.collatex.dekker.island.Island;
import eu.interedition.collatex.dekker.legacy.MatchTable;
import java.util.ArrayList;

public class MatchTableSerializer {
    private final MatchTable sparseMatrix;

    public MatchTableSerializer(MatchTable table) {
        this.sparseMatrix = table;
    }

    public String toHtml() {
        StringBuilder result = new StringBuilder("<table>\n<tr><td></td>\n");
        ArrayList<String> colLabels = this.columnLabels();
        for (String cLabel : colLabels) {
            result.append("<td>").append(cLabel).append("</td>");
        }
        result.append("</tr>\n");
        int colNum = this.sparseMatrix.columnList().size();
        ArrayList<String> rLabels = this.rowLabels();
        int row = 0;
        for (String label : rLabels) {
            result.append("<tr><td>").append(label).append("</td>");
            for (int col = 0; col < colNum; ++col) {
                if (this.sparseMatrix.vertexAt(row, col) != null) {
                    result.append("<td BGCOLOR=\"lightgreen\">M</td>");
                    continue;
                }
                result.append("<td></td>");
            }
            result.append("</tr>\n");
            ++row;
        }
        result.append("</table>");
        return result.toString();
    }

    public String toHtml(Archipelago arch) {
        int[] mat = new int[this.rowNum()];
        for (Island isl : arch.getIslands()) {
            for (Coordinate c : isl) {
                mat[c.row] = c.column;
            }
        }
        StringBuilder result = new StringBuilder("<table>\n<tr><td></td>\n");
        ArrayList<String> colLabels = this.columnLabels();
        for (String cLabel : colLabels) {
            result.append("<td>").append(cLabel).append("</td>");
        }
        result.append("</tr>\n");
        ArrayList<String> rLabels = this.rowLabels();
        int row = 0;
        for (String label : rLabels) {
            result.append("<tr><td>").append(label).append("</td>");
            if (mat[row] > 0) {
                result.append("<td colspan=\"").append(mat[row]).append("\"></td>").append("<td BGCOLOR=\"lightgreen\">M</td>");
            }
            result.append("</tr>\n");
            ++row;
        }
        result.append("</table>");
        return result.toString();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        ArrayList<String> colLabels = this.columnLabels();
        for (String cLabel : colLabels) {
            result.append(" ").append(cLabel);
        }
        result.append("\n");
        int colNum = this.sparseMatrix.columnList().size();
        ArrayList<String> rLabels = this.rowLabels();
        int row = 0;
        for (String label : rLabels) {
            result.append(label);
            for (int col = 0; col < colNum; ++col) {
                result.append(" ").append(this.sparseMatrix.vertexAt(row++, col) != null);
            }
            result.append("\n");
        }
        return result.toString();
    }

    public ArrayList<String> rowLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        for (Token vgv : this.sparseMatrix.rowList()) {
            String token = vgv.toString();
            int pos = token.indexOf(":'");
            if (pos <= -1) continue;
            labels.add(token.substring(pos + 2, token.length() - 2));
        }
        return labels;
    }

    public ArrayList<String> columnLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        for (Integer t : this.sparseMatrix.columnList()) {
            String token = t.toString();
            int pos = token.indexOf(":'");
            if (pos <= -1) continue;
            labels.add(token.substring(pos + 2, token.length() - 1));
        }
        return labels;
    }

    public int rowNum() {
        return this.rowLabels().size();
    }

    public int colNum() {
        return this.columnLabels().size();
    }
}

