/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.dekker.token_index;

import eu.interedition.collatex.Token;
import eu.interedition.collatex.Witness;
import eu.interedition.collatex.dekker.token_index.Block;
import eu.interedition.collatex.suffixarray.SAIS;
import eu.interedition.collatex.suffixarray.SuffixArrays;
import eu.interedition.collatex.suffixarray.SuffixData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.StreamSupport;

public class TokenIndex {
    private final List<? extends Iterable<Token>> w;
    private final Comparator<Token> comparator;
    private Map<Witness, Integer> witnessToStartToken;
    private Map<Witness, Integer> witnessToEndToken;
    public Token[] token_array;
    public int[] suffix_array;
    public int[] LCP_array;
    public List<Block> blocks;
    private Map<Witness, List<Block.Instance>> witnessToBlockInstances;

    public TokenIndex(Comparator<Token> comparator, Iterable<Token> ... tokens) {
        this(comparator, Arrays.asList(tokens));
    }

    public TokenIndex(Comparator<Token> comparator, List<? extends Iterable<Token>> w) {
        this.w = w;
        this.comparator = new MarkerTokenComparatorWrapper(comparator);
    }

    public int getStartTokenPositionForWitness(Witness witness) {
        return this.witnessToStartToken.get(witness);
    }

    public void prepare() {
        this.token_array = this.prepareTokenArray();
        SuffixData suffixData = SuffixArrays.createWithLCP(this.token_array, new SAIS(), this.comparator);
        this.suffix_array = suffixData.getSuffixArray();
        this.LCP_array = suffixData.getLCP();
        this.blocks = this.splitLCP_ArrayIntoIntervals();
        this.constructWitnessToBlockInstancesMap();
    }

    private Token[] prepareTokenArray() {
        ArrayList<Token> tempTokenList = new ArrayList<Token>();
        int counter = 0;
        this.witnessToStartToken = new HashMap<Witness, Integer>();
        this.witnessToEndToken = new HashMap<Witness, Integer>();
        for (Iterable<Token> iterable : this.w) {
            Witness witness = StreamSupport.stream(iterable.spliterator(), false).findFirst().map(Token::getWitness).orElseThrow(() -> new IllegalArgumentException("Empty witness"));
            this.witnessToStartToken.put(witness, counter);
            for (Token t : iterable) {
                tempTokenList.add(t);
                ++counter;
            }
            this.witnessToEndToken.put(witness, counter);
            tempTokenList.add(new MarkerToken(this.witnessToStartToken.size()));
            ++counter;
        }
        return tempTokenList.toArray(new Token[tempTokenList.size()]);
    }

    protected List<Block> splitLCP_ArrayIntoIntervals() {
        ArrayList<Block> closedIntervals = new ArrayList<Block>();
        int previousLCP_value = 0;
        Stack<Block> openIntervals = new Stack<Block>();
        for (int idx = 0; idx < this.LCP_array.length; ++idx) {
            int lcp_value = this.LCP_array[idx];
            if (lcp_value > previousLCP_value) {
                openIntervals.push(new Block(this, idx - 1, lcp_value));
                previousLCP_value = lcp_value;
                continue;
            }
            if (lcp_value >= previousLCP_value) continue;
            while (!openIntervals.isEmpty() && ((Block)openIntervals.peek()).length > lcp_value) {
                Block a = (Block)openIntervals.pop();
                closedIntervals.add(new Block(this, a.start, idx - 1, a.length));
            }
            if (lcp_value > 0) {
                int start = ((Block)closedIntervals.get((int)(closedIntervals.size() - 1))).start;
                openIntervals.add(new Block(this, start, lcp_value));
            }
            previousLCP_value = lcp_value;
        }
        for (Block interval : openIntervals) {
            if (interval.length <= 0) continue;
            closedIntervals.add(new Block(this, interval.start, this.LCP_array.length - 1, interval.length));
        }
        return closedIntervals;
    }

    private void constructWitnessToBlockInstancesMap() {
        this.witnessToBlockInstances = new HashMap<Witness, List<Block.Instance>>();
        for (Block interval : this.blocks) {
            for (Block.Instance instance : interval.getAllInstances()) {
                Witness w = instance.getWitness();
                List instances = this.witnessToBlockInstances.computeIfAbsent(w, v -> new ArrayList());
                instances.add(instance);
            }
        }
    }

    public List<Block.Instance> getBlockInstancesForWitness(Witness w) {
        return this.witnessToBlockInstances.computeIfAbsent(w, v -> Collections.emptyList());
    }

    public int size() {
        return this.token_array.length;
    }

    static class MarkerTokenComparatorWrapper
    implements Comparator<Token> {
        private Comparator<Token> delegate;

        public MarkerTokenComparatorWrapper(Comparator<Token> delegate) {
            this.delegate = delegate;
        }

        @Override
        public int compare(Token o1, Token o2) {
            boolean o1isMarker = o1 instanceof MarkerToken;
            boolean o2isMarker = o2 instanceof MarkerToken;
            if (o1isMarker) {
                if (o2isMarker) {
                    MarkerToken mt1 = (MarkerToken)o1;
                    MarkerToken mt2 = (MarkerToken)o2;
                    return mt1.witnessIdentifier - mt2.witnessIdentifier;
                }
                return -1;
            }
            if (o2isMarker) {
                return 1;
            }
            return this.delegate.compare(o1, o2);
        }
    }

    private class MarkerToken
    implements Token {
        private final int witnessIdentifier;

        public MarkerToken(int size) {
            this.witnessIdentifier = size;
        }

        public String toString() {
            return "$" + this.witnessIdentifier;
        }

        @Override
        public Witness getWitness() {
            throw new RuntimeException("A marker token is not part of any witness! The call to this method should never have happened!");
        }
    }
}

