/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.matching;

public final class EditDistance {
    private static final int MAX_DISTANCE_COMPARISON = 2500;

    public static int compute(String str1, String str2) {
        int[][] matrix;
        if (str1.length() * str2.length() > 2500) {
            return 2500;
        }
        char[] str1Chars = str1.toCharArray();
        int str1Length = str1Chars.length;
        char[] str2Chars = str2.toCharArray();
        int str2Length = str2Chars.length;
        if (str1Length == 0) {
            return str2Length;
        }
        if (str2Length == 0) {
            return str1Length;
        }
        int[][][] cache = new int[30][][];
        if (str2Length >= cache.length) {
            matrix = EditDistance.form(str1Length, str2Length);
        } else if (cache[str2Length] != null) {
            matrix = cache[str2Length];
        } else {
            cache[str2Length] = EditDistance.form(str1Length, str2Length);
            matrix = cache[str2Length];
        }
        for (int i = 1; i <= str1Length; ++i) {
            char str1Char = str1Chars[i - 1];
            for (int j = 1; j <= str2Length; ++j) {
                char str2Char = str2Chars[j - 1];
                int cost = str1Char == str2Char ? 0 : 1;
                matrix[i][j] = EditDistance.min3(matrix[i - 1][j] + 1, matrix[i][j - 1] + 1, matrix[i - 1][j - 1] + cost);
            }
        }
        return matrix[str1Length][str2Length];
    }

    private static int[][] form(int n, int m) {
        int[][] d = new int[n + 1][m + 1];
        for (int i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (int j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        return d;
    }

    private static int min3(int a, int b, int c) {
        int mi = a;
        if (b < mi) {
            mi = b;
        }
        if (c < mi) {
            mi = c;
        }
        return mi;
    }
}

