/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.medite;

import eu.interedition.collatex.util.VertexMatch;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;

public class AlignmentDecisionGraph {
    private final List<SortedSet<VertexMatch.WithTokenIndex>> matches;
    private final Function<SortedSet<VertexMatch.WithTokenIndex>, Integer> matchEvaluator;
    private final PriorityQueue<Node> bestPaths;
    private final Map<Node, Integer> minCosts;

    AlignmentDecisionGraph(List<SortedSet<VertexMatch.WithTokenIndex>> matches, Function<SortedSet<VertexMatch.WithTokenIndex>, Integer> matchEvaluator) {
        this.matches = matches;
        this.matchEvaluator = matchEvaluator;
        this.bestPaths = new PriorityQueue<Node>(matches.size(), Comparator.comparingInt(n -> n.cost));
        this.minCosts = new HashMap<Node, Integer>();
    }

    static SortedSet<SortedSet<VertexMatch.WithTokenIndex>> filter(SortedSet<SortedSet<VertexMatch.WithTokenIndex>> matches, Function<SortedSet<VertexMatch.WithTokenIndex>, Integer> matchEvaluator) {
        TreeSet<SortedSet<VertexMatch.WithTokenIndex>> alignments = new TreeSet<SortedSet<VertexMatch.WithTokenIndex>>(VertexMatch.setComparator());
        ArrayList<SortedSet<VertexMatch.WithTokenIndex>> matchList = new ArrayList<SortedSet<VertexMatch.WithTokenIndex>>(matches);
        Node optimal = new AlignmentDecisionGraph(matchList, matchEvaluator).findBestPath();
        while (optimal.matchIndex >= 0) {
            if (optimal.aligned) {
                alignments.add((SortedSet<VertexMatch.WithTokenIndex>)matchList.get(optimal.matchIndex));
            }
            optimal = optimal.previous;
        }
        return alignments;
    }

    private Node findBestPath() {
        this.bestPaths.add(new Node(-1, false));
        while (!this.bestPaths.isEmpty()) {
            Node current = (Node)this.bestPaths.remove();
            if (current.matchIndex == this.matches.size() - 1) {
                return current;
            }
            for (Node successor : current.successors()) {
                int tentativeCost = this.cost(current) + this.cost(successor);
                if (this.bestPaths.contains(successor) && tentativeCost >= this.minCosts.get(successor)) continue;
                this.minCosts.put(successor, tentativeCost);
                successor.cost = tentativeCost + this.heuristicCost(successor);
                successor.previous = current;
                this.bestPaths.remove(successor);
                this.bestPaths.add(successor);
            }
        }
        throw new IllegalStateException("No optimal alignment found");
    }

    private int heuristicCost(Node path) {
        SortedSet<VertexMatch.WithTokenIndex> evaluated = this.matches.get(path.matchIndex);
        VertexMatch.WithTokenIndex lastMatch = evaluated.last();
        int cost = 0;
        for (SortedSet<VertexMatch.WithTokenIndex> following : this.matches.subList(path.matchIndex + 1, this.matches.size())) {
            VertexMatch.WithTokenIndex followingFirstMatch = following.first();
            if (lastMatch.vertexRank < followingFirstMatch.vertexRank && lastMatch.token < followingFirstMatch.token) continue;
            cost += this.value(following);
        }
        return cost;
    }

    private int cost(Node current) {
        int cost = 0;
        while (current != null && current.matchIndex >= 0) {
            if (!current.aligned) {
                cost += this.value(this.matches.get(current.matchIndex));
            }
            current = current.previous;
        }
        return cost;
    }

    private int value(SortedSet<VertexMatch.WithTokenIndex> match) {
        return this.matchEvaluator.apply(match);
    }

    static class Node {
        final int matchIndex;
        final boolean aligned;
        Node previous;
        int cost;

        Node(int matchIndex, boolean aligned) {
            this.matchIndex = matchIndex;
            this.aligned = aligned;
        }

        Node[] successors() {
            int nextIndex = this.matchIndex + 1;
            return new Node[]{new Node(nextIndex, true), new Node(nextIndex, false)};
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof Node) {
                Node other = (Node)obj;
                return this.matchIndex == other.matchIndex && this.aligned == other.aligned;
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return Objects.hash(this.matchIndex, this.aligned);
        }
    }
}

