/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.medite;

import eu.interedition.collatex.CollationAlgorithm;
import eu.interedition.collatex.Token;
import eu.interedition.collatex.VariantGraph;
import eu.interedition.collatex.medite.AlignmentDecisionGraph;
import eu.interedition.collatex.medite.Matches;
import eu.interedition.collatex.medite.SuffixTree;
import eu.interedition.collatex.util.VariantGraphRanking;
import eu.interedition.collatex.util.VertexMatch;
import java.util.BitSet;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;

public class MediteAlgorithm
extends CollationAlgorithm.Base {
    private final Comparator<Token> comparator;
    private final Function<SortedSet<VertexMatch.WithToken>, Integer> matchEvaluator;

    public MediteAlgorithm(Comparator<Token> comparator, Function<SortedSet<VertexMatch.WithToken>, Integer> matchEvaluator) {
        this.comparator = comparator;
        this.matchEvaluator = matchEvaluator;
    }

    @Override
    public void collate(VariantGraph graph, Iterable<Token> witness) {
        SortedSet<SortedSet<VertexMatch.WithTokenIndex>> maximalUniqueMatches;
        VariantGraph.Vertex[][] vertices = VariantGraphRanking.of(graph).asArray();
        Token[] tokens = (Token[])StreamSupport.stream(witness.spliterator(), false).toArray(Token[]::new);
        SuffixTree<Token> suffixTree = SuffixTree.build(this.comparator, tokens);
        MatchEvaluatorWrapper matchEvaluator = new MatchEvaluatorWrapper(this.matchEvaluator, tokens);
        Matches matchCandidates = Matches.between(vertices, suffixTree, matchEvaluator);
        TreeSet<SortedSet<VertexMatch.WithTokenIndex>> matches = new TreeSet<SortedSet<VertexMatch.WithTokenIndex>>(VertexMatch.setComparator());
        while (!(maximalUniqueMatches = matchCandidates.findMaximalUniqueMatches()).isEmpty()) {
            BitSet rankFilter = new BitSet();
            BitSet tokenFilter = new BitSet();
            for (SortedSet sortedSet : AlignmentDecisionGraph.filter(maximalUniqueMatches, matchEvaluator)) {
                VertexMatch.WithTokenIndex firstMatch = (VertexMatch.WithTokenIndex)sortedSet.first();
                VertexMatch.WithTokenIndex lastMatch = (VertexMatch.WithTokenIndex)sortedSet.last();
                matches.add(sortedSet);
                IntStream.range(firstMatch.vertexRank, lastMatch.vertexRank + 1).forEach(rankFilter::set);
                IntStream.range(firstMatch.token, lastMatch.token + 1).forEach(tokenFilter::set);
            }
            matchCandidates.removeIf(VertexMatch.filter(rankFilter, tokenFilter));
        }
        this.merge(graph, vertices, tokens, matches);
    }

    static class MatchEvaluatorWrapper
    implements Function<SortedSet<VertexMatch.WithTokenIndex>, Integer> {
        private final Function<SortedSet<VertexMatch.WithToken>, Integer> wrapped;
        private final Function<VertexMatch.WithTokenIndex, VertexMatch.WithToken> tokenResolver;

        MatchEvaluatorWrapper(Function<SortedSet<VertexMatch.WithToken>, Integer> wrapped, Token[] tokens) {
            this.wrapped = wrapped;
            this.tokenResolver = VertexMatch.tokenResolver(tokens);
        }

        @Override
        public Integer apply(SortedSet<VertexMatch.WithTokenIndex> input) {
            TreeSet<VertexMatch.WithToken> tokenPhrase = new TreeSet<VertexMatch.WithToken>();
            for (VertexMatch.WithTokenIndex match : input) {
                tokenPhrase.add(this.tokenResolver.apply(match));
            }
            return this.wrapped.apply(tokenPhrase);
        }
    }
}

