/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.medite;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class SuffixTree<T> {
    final Comparator<T> comparator;
    final Comparator<Integer> sourceComparator;
    final T[] source;
    final Node root;

    @SafeVarargs
    static <T> SuffixTree<T> build(Comparator<T> comparator, T ... source) {
        return super.build();
    }

    @SafeVarargs
    private SuffixTree(Comparator<T> comparator, T ... source) {
        this.comparator = comparator;
        this.sourceComparator = new SentinelAwareComparator(comparator);
        this.source = source;
        this.root = new Node();
    }

    public Cursor cursor() {
        return new Cursor();
    }

    public Iterable<EquivalenceClass> match(final Iterable<T> str) {
        return () -> new Iterator<EquivalenceClass>(){
            final Iterator it;
            Optional cursor;
            {
                this.it = str.iterator();
                this.cursor = Optional.ofNullable(this.it.hasNext() ? SuffixTree.this.cursor().move(this.it.next()) : null);
            }

            @Override
            public boolean hasNext() {
                return this.cursor.isPresent();
            }

            @Override
            public EquivalenceClass next() {
                EquivalenceClass next = ((Cursor)this.cursor.get()).matchedClass();
                this.cursor = Optional.ofNullable(this.it.hasNext() ? ((Cursor)this.cursor.get()).move(this.it.next()) : null);
                return next;
            }
        };
    }

    private SuffixTree<T> build() {
        for (int suffixStart = 0; suffixStart <= this.source.length; ++suffixStart) {
            this.root.addSuffix(suffixStart);
        }
        this.compactNodes(this.root);
        return this;
    }

    private void compactNodes(Node node) {
        for (Node child : node.children) {
            while (child.children.size() == 1) {
                Node firstGrandChild = child.children.iterator().next();
                child.incomingLabel.add(firstGrandChild.incomingLabel.getFirst());
                child.children = firstGrandChild.children;
                for (Node formerGrandchild : child.children) {
                    formerGrandchild.parent = child;
                }
            }
            this.compactNodes(child);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayDeque<Node> nodes = new ArrayDeque<Node>(Collections.singleton(this.root));
        while (!nodes.isEmpty()) {
            Node node = (Node)nodes.remove();
            sb.append(IntStream.range(0, node.depth()).mapToObj(i -> "\t").collect(Collectors.joining())).append(node).append("\n");
            node.children.forEach(nodes::addFirst);
        }
        return sb.toString();
    }

    public class Cursor {
        final Node node;
        final int offset;

        Cursor() {
            this(this$0.root, 0);
        }

        Cursor(Node node, int offset) {
            this.node = node;
            this.offset = offset;
        }

        public Cursor move(T symbol) {
            if (this.node.incomingLabel == null || this.offset + 1 == this.node.incomingLabel.size()) {
                for (Node child : this.node.children) {
                    Cursor next = new Cursor(child, 0);
                    if (!next.matchedClass().isMember(symbol)) continue;
                    return next;
                }
                return null;
            }
            return this.node.incomingLabel.get(this.offset + 1).isMember(symbol) ? new Cursor(this.node, this.offset + 1) : null;
        }

        EquivalenceClass matchedClass() {
            return this.node.incomingLabel.get(this.offset);
        }
    }

    class SentinelAwareComparator
    implements Comparator<Integer> {
        final Comparator<T> comparator;

        SentinelAwareComparator(Comparator<T> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            if (o1 == SuffixTree.this.source.length || o2 == SuffixTree.this.source.length) {
                return o2 - o1;
            }
            return this.comparator.compare(SuffixTree.this.source[o1], SuffixTree.this.source[o2]);
        }
    }

    class EquivalenceClass
    implements Comparable<EquivalenceClass> {
        int[] members = new int[2];
        int length = 0;

        EquivalenceClass(int first) {
            this.members[this.length++] = first;
        }

        void add(int member) {
            if (this.length == this.members.length) {
                this.members = Arrays.copyOf(this.members, this.members.length * 2);
            }
            this.members[this.length++] = member;
        }

        boolean isMember(int index) {
            return SuffixTree.this.sourceComparator.compare(index, this.members[0]) == 0;
        }

        public boolean isMember(T symbol) {
            return this.members[0] != SuffixTree.this.source.length && SuffixTree.this.comparator.compare(symbol, SuffixTree.this.source[this.members[0]]) == 0;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof EquivalenceClass) {
                return this.members[0] == ((EquivalenceClass)obj).members[0];
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.members[0];
        }

        @Override
        public int compareTo(EquivalenceClass o) {
            return this.members[0] - o.members[0];
        }

        public String toString() {
            return String.format("{%s}", Arrays.stream(this.members, 0, this.length).mapToObj(member -> "<[" + member + "] " + (member == SuffixTree.this.source.length ? "$" : SuffixTree.this.source[member].toString()) + ">").collect(Collectors.joining(", ")));
        }
    }

    class Node {
        final LinkedList<EquivalenceClass> incomingLabel;
        Node parent;
        List<Node> children = new ArrayList<Node>();

        public Node(Node parent, int firstIndex) {
            this.parent = parent;
            this.incomingLabel = new LinkedList<EquivalenceClass>(Collections.singleton(new EquivalenceClass(firstIndex)));
        }

        public Node() {
            this.parent = null;
            this.incomingLabel = null;
        }

        public int depth() {
            int depth = 0;
            Node parent = this.parent;
            while (parent != null) {
                ++depth;
                parent = parent.parent;
            }
            return depth;
        }

        public void addSuffix(int start) {
            this.addSuffix(this, start);
        }

        private Node addSuffix(Node node, int start) {
            for (Node child : node.children) {
                EquivalenceClass childClass = child.incomingLabel.getFirst();
                if (!childClass.isMember(start)) continue;
                childClass.add(start);
                if (++start == SuffixTree.this.source.length + 1) {
                    return child;
                }
                return this.addSuffix(child, start);
            }
            while (start <= SuffixTree.this.source.length) {
                Node child = new Node(node, start);
                node.children.add(child);
                node = child;
                ++start;
            }
            return node;
        }

        public String toString() {
            return Optional.ofNullable(this.incomingLabel).map(label -> label.stream().map(Object::toString).collect(Collectors.joining(", "))).orElse("");
        }
    }
}

