/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.simple;

import eu.interedition.collatex.CollationAlgorithm;
import eu.interedition.collatex.VariantGraph;
import eu.interedition.collatex.simple.SimpleWitness;
import java.util.List;

public class SimpleCollation {
    private final List<SimpleWitness> witnesses;
    private final CollationAlgorithm algorithm;
    private final boolean joined;

    public SimpleCollation(List<SimpleWitness> witnesses, CollationAlgorithm algorithm, boolean joined) {
        this.witnesses = witnesses;
        this.algorithm = algorithm;
        this.joined = joined;
    }

    public List<SimpleWitness> getWitnesses() {
        return this.witnesses;
    }

    public CollationAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public boolean isJoined() {
        return this.joined;
    }

    public VariantGraph collate(VariantGraph graph) {
        this.algorithm.collate(graph, this.witnesses);
        if (this.joined) {
            VariantGraph.JOIN.apply(graph);
        }
        return graph;
    }
}

