/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.simple;

import java.util.LinkedList;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class SimplePatternTokenizer {
    static final String PUNCT = Pattern.quote(".?!,;:");
    public static final Function<String, Stream<String>> BY_WHITESPACE = SimplePatternTokenizer.tokenizer(Pattern.compile("\\s*?\\S+\\s*]"));
    public static final Function<String, Stream<String>> BY_WS_AND_PUNCT = SimplePatternTokenizer.tokenizer(Pattern.compile("[\\s" + PUNCT + "]*?[^\\s" + PUNCT + "]+[\\s" + PUNCT + "]*"));
    public static final Function<String, Stream<String>> BY_WS_OR_PUNCT = SimplePatternTokenizer.tokenizer(Pattern.compile("[" + PUNCT + "]+[\\s]*|[^" + PUNCT + "\\s]+[\\s]*"));

    static Function<String, Stream<String>> tokenizer(Pattern pattern) {
        return input -> {
            Matcher matcher = pattern.matcher((CharSequence)input);
            LinkedList<String> tokens = new LinkedList<String>();
            while (matcher.find()) {
                tokens.add(input.substring(matcher.start(), matcher.end()));
            }
            return tokens.stream();
        };
    }
}

