/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.simple;

import eu.interedition.collatex.Token;
import eu.interedition.collatex.Witness;
import eu.interedition.collatex.simple.SimplePatternTokenizer;
import eu.interedition.collatex.simple.SimpleToken;
import eu.interedition.collatex.simple.SimpleTokenNormalizers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SimpleWitness
implements Iterable<Token>,
Witness,
Comparator<SimpleToken> {
    private final String sigil;
    private final List<Token> tokens = new ArrayList<Token>();
    public static final Pattern PUNCT = Pattern.compile("\\p{Punct}");
    public static final Function<String, String> TOKEN_NORMALIZER = input -> {
        String normalized = PUNCT.matcher(input.trim().toLowerCase()).replaceAll("");
        return normalized == null || normalized.length() == 0 ? input : normalized;
    };

    public SimpleWitness(String sigil) {
        this.sigil = sigil;
    }

    public SimpleWitness(String sigil, String content) {
        this(sigil, content, SimplePatternTokenizer.BY_WS_OR_PUNCT, SimpleTokenNormalizers.LC_TRIM_WS);
    }

    public SimpleWitness(String sigil, String content, Function<String, Stream<String>> tokenizer, Function<String, String> normalizer) {
        this(sigil);
        this.setTokenContents(tokenizer.apply(content), normalizer);
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    public void setTokenContents(Stream<String> tokenContents, Function<String, String> normalizer) {
        this.setTokens(tokenContents.map(content -> new SimpleToken(this, (String)content, (String)normalizer.apply((String)content))).collect(Collectors.toList()));
    }

    public void setTokens(List<Token> tokens) {
        this.tokens.clear();
        this.tokens.addAll(tokens);
    }

    @Override
    public String getSigil() {
        return this.sigil;
    }

    @Override
    public Iterator<Token> iterator() {
        return Collections.unmodifiableList(this.tokens).iterator();
    }

    public String toString() {
        return this.getSigil();
    }

    @Override
    public int compare(SimpleToken o1, SimpleToken o2) {
        int o1Index = this.tokens.indexOf(o1);
        int o2Index = this.tokens.indexOf(o2);
        if (o1Index < 0) {
            throw new IllegalArgumentException(o1.toString());
        }
        if (o2Index < 0) {
            throw new IllegalArgumentException();
        }
        return o1Index - o2Index;
    }
}

