/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.suffixarray;

import eu.interedition.collatex.suffixarray.ISuffixArrayBuilder;
import eu.interedition.collatex.suffixarray.Tools;
import java.util.Arrays;

public class BPR
implements ISuffixArrayBuilder {
    public static final int KBS_MAX_ALPHABET_SIZE = 256;
    public static final int KBS_INSSORT_THRES_LEN = 15;
    public static final int KBS_STRING_EXTENSION_SIZE = 32;
    public static final int INSSORT_LIMIT = 15;
    private final boolean preserveInput;
    private int[] seq;
    private int length;
    private Alphabet alphabet;
    private int[] suffixArray;
    private int[] sufPtrMap;
    private int start;

    public BPR() {
        this(true);
    }

    public BPR(boolean preserveInput) {
        this.preserveInput = preserveInput;
    }

    @Override
    public int[] buildSuffixArray(int[] input, int start, int length) {
        Tools.assertAlways(input != null, "input must not be null");
        Tools.assertAlways(input.length >= start + length + 32, "input is too short");
        Tools.assertAlways(length >= 2, "input length must be >= 2");
        this.start = start;
        if (this.preserveInput) {
            this.seq = new int[length + 32];
            this.start = 0;
            System.arraycopy(input, start, this.seq, 0, length);
        } else {
            this.seq = input;
        }
        this.alphabet = new Alphabet(this.seq, length);
        this.length = length;
        int alphaSize = this.alphabet.size;
        int q = alphaSize <= 9 ? 7 : (9 < alphaSize && alphaSize <= 13 ? 6 : (13 < alphaSize && alphaSize <= 21 ? 5 : (21 < alphaSize && alphaSize <= 46 ? 4 : 3)));
        this.kbs_buildDstepUsePrePlusCopyFreqOrder_SuffixArray(q);
        return this.suffixArray;
    }

    private void kbs_buildDstepUsePrePlusCopyFreqOrder_SuffixArray(int q) {
        int[] buckets = this.determine_Buckets_Sarray_Sptrmap(q);
        int mappedCharPtr = 0;
        int alphabetSize = this.alphabet.size;
        int bucketsInLevel3Bucket = this.kbs_power_Ulong(alphabetSize, q - 3);
        int bucketsInLevel2Bucket = bucketsInLevel3Bucket * alphabetSize;
        int bucketsInLevel1Bucket = bucketsInLevel2Bucket * alphabetSize;
        int[] alphaOrder = this.getCharWeightedOrder_Alphabet(buckets, bucketsInLevel2Bucket);
        int[] isNotSortedLevel1Char = new int[alphabetSize];
        Arrays.fill(isNotSortedLevel1Char, 1);
        int[] leftPtrList = new int[alphabetSize];
        int[] rightPtrList = new int[alphabetSize];
        int[] leftPtrList2 = new int[alphabetSize * alphabetSize];
        int[] rightPtrList2 = new int[alphabetSize * alphabetSize];
        int c1 = 0;
        for (int i = 0; i < alphabetSize; ++i) {
            int tmpUlongPtr;
            int cp2;
            int cp1;
            int leftPtr;
            int cp12;
            int tmpUlong;
            int j;
            c1 = alphaOrder[i];
            for (j = i + 1; j < alphabetSize; ++j) {
                int c2 = alphaOrder[j];
                for (int l = i; l < alphabetSize; ++l) {
                    int c3 = alphaOrder[l];
                    for (int k = tmpUlong = c1 * bucketsInLevel1Bucket + c2 * bucketsInLevel2Bucket + c3 * bucketsInLevel3Bucket; k < tmpUlong + bucketsInLevel3Bucket; ++k) {
                        int rightPtr = buckets[k + 1] - 1;
                        int leftPtr2 = buckets[k];
                        if (rightPtr - leftPtr2 <= 0) continue;
                        if (rightPtr - leftPtr2 < 15) {
                            this.insSortUpdateRecurse_SaBucket(leftPtr2, rightPtr, q, q);
                            continue;
                        }
                        this.partitionUpdateRecurse_SaBucket(leftPtr2, rightPtr, q, q);
                    }
                }
            }
            for (j = i; j < alphabetSize; ++j) {
                cp12 = alphaOrder[j];
                leftPtrList[cp12] = buckets[cp12 * bucketsInLevel1Bucket + c1 * bucketsInLevel2Bucket];
                for (int k = i + 1; k < alphabetSize; ++k) {
                    int cp22 = alphaOrder[k];
                    leftPtrList2[cp22 * alphabetSize + cp12] = buckets[cp22 * bucketsInLevel1Bucket + cp12 * bucketsInLevel2Bucket + c1 * bucketsInLevel3Bucket];
                }
            }
            if (c1 == 0) {
                cp12 = this.seq[this.start + mappedCharPtr + this.length - 1];
                int cp23 = this.seq[this.start + mappedCharPtr + this.length - 2];
                if (isNotSortedLevel1Char[cp12] != 0) {
                    int n = cp12;
                    leftPtrList[n] = leftPtrList[n] + 1;
                    int n2 = cp12 * alphabetSize;
                    leftPtrList2[n2] = leftPtrList2[n2] + 1;
                    if (isNotSortedLevel1Char[cp23] != 0 && cp23 != c1) {
                        this.suffixArray[leftPtrList2[cp23 * alphabetSize + cp12]] = this.length - 2;
                        this.sufPtrMap[this.length - 2] = leftPtrList2[cp23 * alphabetSize + cp12];
                        int n3 = cp23 * alphabetSize + cp12;
                        leftPtrList2[n3] = leftPtrList2[n3] + 1;
                    }
                }
            }
            for (leftPtr = buckets[c1 * bucketsInLevel1Bucket]; leftPtr < leftPtrList[c1]; ++leftPtr) {
                int tmpUlong2 = this.suffixArray[leftPtr];
                if (tmpUlong2 == 0 || isNotSortedLevel1Char[cp1 = this.seq[this.start + mappedCharPtr + tmpUlong2 - 1]] == 0) continue;
                if (isNotSortedLevel1Char[this.seq[this.start + mappedCharPtr + tmpUlong2 + 1]] != 0) {
                    int tmpUlongPtr2;
                    this.sufPtrMap[tmpUlong2 - 1] = tmpUlongPtr2 = leftPtrList[cp1];
                    this.suffixArray[tmpUlongPtr2] = tmpUlong2 - 1;
                }
                int n = cp1;
                leftPtrList[n] = leftPtrList[n] + 1;
                if (tmpUlong2 <= 1 || isNotSortedLevel1Char[cp2 = this.seq[this.start + mappedCharPtr + tmpUlong2 - 2]] == 0 || cp2 == c1) continue;
                int n4 = cp2 * alphabetSize + cp1;
                leftPtrList2[n4] = leftPtrList2[n4] + 1;
                this.sufPtrMap[tmpUlong2 - 2] = tmpUlongPtr;
                this.suffixArray[tmpUlongPtr] = tmpUlong2 - 2;
            }
            for (j = i; j < alphabetSize; ++j) {
                cp1 = alphaOrder[j];
                rightPtrList[cp1] = buckets[cp1 * bucketsInLevel1Bucket + (c1 + 1) * bucketsInLevel2Bucket];
                for (int k = i + 1; k < alphabetSize; ++k) {
                    cp2 = alphaOrder[k];
                    rightPtrList2[cp2 * alphabetSize + cp1] = buckets[cp2 * bucketsInLevel1Bucket + cp1 * bucketsInLevel2Bucket + (c1 + 1) * bucketsInLevel3Bucket];
                }
            }
            int rightPtr = buckets[(c1 + 1) * bucketsInLevel1Bucket];
            while (leftPtr < rightPtr) {
                int tmpUlongPtr3;
                int cp24;
                int cp13;
                if ((tmpUlong = this.suffixArray[--rightPtr]) == 0 || isNotSortedLevel1Char[cp13 = this.seq[this.start + mappedCharPtr + tmpUlong - 1]] == 0) continue;
                int n = cp13;
                rightPtrList[n] = rightPtrList[n] - 1;
                if (isNotSortedLevel1Char[this.seq[this.start + mappedCharPtr + tmpUlong + 1]] != 0) {
                    this.sufPtrMap[tmpUlong - 1] = tmpUlongPtr = rightPtrList[cp13];
                    this.suffixArray[tmpUlongPtr] = tmpUlong - 1;
                }
                if (tmpUlong <= 1 || isNotSortedLevel1Char[cp24 = this.seq[this.start + mappedCharPtr + tmpUlong - 2]] == 0 || cp24 == c1) continue;
                int n5 = cp24 * alphabetSize + cp13;
                int n6 = rightPtrList2[n5] - 1;
                rightPtrList2[n5] = n6;
                this.sufPtrMap[tmpUlong - 2] = tmpUlongPtr3 = n6;
                this.suffixArray[tmpUlongPtr3] = tmpUlong - 2;
            }
            isNotSortedLevel1Char[c1] = 0;
        }
    }

    private void insSortUpdateRecurse_SaBucket(int leftPtr, int rightPtr, int offset, int q) {
        for (int rightTmpPtr = leftPtr + 1; rightTmpPtr <= rightPtr; ++rightTmpPtr) {
            int tempValue = this.suffixArray[rightTmpPtr];
            int tempHashValue = this.sufPtrMap[this.suffixArray[rightTmpPtr] + offset];
            for (int leftTmpPtr = rightTmpPtr; leftTmpPtr > leftPtr && this.sufPtrMap[this.suffixArray[leftTmpPtr - 1] + offset] > tempHashValue; --leftTmpPtr) {
                this.suffixArray[leftTmpPtr] = this.suffixArray[leftTmpPtr - 1];
            }
            this.suffixArray[leftTmpPtr] = tempValue;
        }
        this.updatePtrAndRefineBuckets_SaBucket(leftPtr, rightPtr, offset, q);
    }

    private void updatePtrAndRefineBuckets_SaBucket(int leftPtr, int rightPtr, int offset, int q) {
        int tmpLong;
        int rightTmpPtr;
        int tmpPtr;
        int leftIntervalPtr = rightPtr;
        int rightIntervalPtr = rightPtr;
        while (leftPtr <= leftIntervalPtr && rightPtr < (tmpPtr = this.sufPtrMap[this.suffixArray[leftIntervalPtr] + offset])) {
            do {
                this.sufPtrMap[this.suffixArray[leftIntervalPtr]] = rightIntervalPtr;
            } while (leftPtr <= --leftIntervalPtr && this.sufPtrMap[this.suffixArray[leftIntervalPtr] + offset] == tmpPtr);
            rightIntervalPtr = leftIntervalPtr;
        }
        rightIntervalPtr = leftIntervalPtr;
        while (leftPtr <= leftIntervalPtr && leftPtr <= this.sufPtrMap[this.suffixArray[leftIntervalPtr] + offset] && this.sufPtrMap[this.suffixArray[leftIntervalPtr] + offset] <= rightPtr) {
            this.sufPtrMap[this.suffixArray[leftIntervalPtr]] = rightIntervalPtr;
            --leftIntervalPtr;
        }
        int middleRightPtr = rightIntervalPtr;
        int middleLeftPtr = leftIntervalPtr;
        rightIntervalPtr = leftIntervalPtr;
        while (leftPtr <= leftIntervalPtr) {
            int tmpPtr2 = this.sufPtrMap[this.suffixArray[leftIntervalPtr] + offset];
            do {
                this.sufPtrMap[this.suffixArray[leftIntervalPtr]] = rightIntervalPtr;
            } while (leftPtr <= --leftIntervalPtr && this.sufPtrMap[this.suffixArray[leftIntervalPtr] + offset] == tmpPtr2);
            rightIntervalPtr = leftIntervalPtr;
        }
        int newOffset = offset + q;
        if (this.sufPtrMap[this.suffixArray[leftPtr]] == rightPtr) {
            newOffset = this.computeDiffDepthBucket_SaBucket(leftPtr, rightPtr, newOffset, q);
        }
        int leftTmpPtr = leftPtr;
        while (leftTmpPtr < middleLeftPtr) {
            rightTmpPtr = this.sufPtrMap[this.suffixArray[leftTmpPtr]];
            tmpLong = rightTmpPtr - leftTmpPtr;
            if (tmpLong > 0) {
                if (tmpLong == 1) {
                    this.computeBucketSize2_SaBucket(leftTmpPtr, rightTmpPtr, newOffset, q);
                    leftTmpPtr = rightTmpPtr + 1;
                    continue;
                }
                if (tmpLong == 2) {
                    this.computeBucketSize3_SaBucket(leftTmpPtr, rightTmpPtr, newOffset, q);
                    leftTmpPtr = rightTmpPtr + 1;
                    continue;
                }
                this.insSortUpdateRecurse_SaBucket(leftTmpPtr, rightTmpPtr, newOffset, q);
            }
            leftTmpPtr = rightTmpPtr + 1;
        }
        if (middleRightPtr > middleLeftPtr + 1) {
            if (middleRightPtr - middleLeftPtr == 2) {
                this.computeBucketSize2_SaBucket(middleLeftPtr + 1, middleRightPtr, Math.max(2 * offset, newOffset), q);
            } else if (middleRightPtr - middleLeftPtr == 3) {
                this.computeBucketSize3_SaBucket(middleLeftPtr + 1, middleRightPtr, Math.max(2 * offset, newOffset), q);
            } else {
                this.insSortUpdateRecurse_SaBucket(middleLeftPtr + 1, middleRightPtr, Math.max(2 * offset, newOffset), q);
            }
        }
        leftTmpPtr = middleRightPtr + 1;
        while (leftTmpPtr < rightPtr) {
            rightTmpPtr = this.sufPtrMap[this.suffixArray[leftTmpPtr]];
            tmpLong = rightTmpPtr - leftTmpPtr;
            if (tmpLong > 0) {
                if (tmpLong == 1) {
                    this.computeBucketSize2_SaBucket(leftTmpPtr, rightTmpPtr, newOffset, q);
                    leftTmpPtr = rightTmpPtr + 1;
                    continue;
                }
                if (tmpLong == 2) {
                    this.computeBucketSize3_SaBucket(leftTmpPtr, rightTmpPtr, newOffset, q);
                    leftTmpPtr = rightTmpPtr + 1;
                    continue;
                }
                this.insSortUpdateRecurse_SaBucket(leftTmpPtr, rightTmpPtr, newOffset, q);
            }
            leftTmpPtr = rightTmpPtr + 1;
        }
    }

    private void computeBucketSize3_SaBucket(int leftPtr, int rightPtr, int offset, int q) {
        int suffix1;
        int swapTmp;
        int newOffset = offset;
        while (this.sufPtrMap[this.suffixArray[leftPtr] + newOffset] == this.sufPtrMap[this.suffixArray[leftPtr + 1] + newOffset] && this.sufPtrMap[this.suffixArray[leftPtr + 1] + newOffset] == this.sufPtrMap[this.suffixArray[rightPtr] + newOffset]) {
            newOffset += q;
        }
        if (this.sufPtrMap[this.suffixArray[leftPtr] + newOffset] > this.sufPtrMap[this.suffixArray[rightPtr] + newOffset]) {
            swapTmp = this.suffixArray[leftPtr];
            this.suffixArray[leftPtr] = this.suffixArray[rightPtr];
            this.suffixArray[rightPtr] = swapTmp;
        }
        if (this.sufPtrMap[this.suffixArray[leftPtr] + newOffset] > this.sufPtrMap[this.suffixArray[leftPtr + 1] + newOffset]) {
            swapTmp = this.suffixArray[leftPtr];
            this.suffixArray[leftPtr] = this.suffixArray[leftPtr + 1];
            this.suffixArray[leftPtr + 1] = swapTmp;
        }
        if (this.sufPtrMap[this.suffixArray[leftPtr + 1] + newOffset] > this.sufPtrMap[this.suffixArray[rightPtr] + newOffset]) {
            swapTmp = this.suffixArray[rightPtr];
            this.suffixArray[rightPtr] = this.suffixArray[leftPtr + 1];
            this.suffixArray[leftPtr + 1] = swapTmp;
        }
        if (this.sufPtrMap[this.suffixArray[leftPtr] + newOffset] == this.sufPtrMap[this.suffixArray[leftPtr + 1] + newOffset]) {
            suffix1 = this.suffixArray[leftPtr] + newOffset + q;
            int suffix2 = this.suffixArray[leftPtr + 1] + newOffset + q;
            while (this.sufPtrMap[suffix1] == this.sufPtrMap[suffix2]) {
                suffix1 += q;
                suffix2 += q;
            }
            if (this.sufPtrMap[suffix1] > this.sufPtrMap[suffix2]) {
                int tmpSwap = this.suffixArray[leftPtr];
                this.suffixArray[leftPtr] = this.suffixArray[leftPtr + 1];
                this.suffixArray[leftPtr + 1] = tmpSwap;
            }
            this.sufPtrMap[this.suffixArray[leftPtr]] = leftPtr;
            this.sufPtrMap[this.suffixArray[leftPtr + 1]] = leftPtr + 1;
            this.sufPtrMap[this.suffixArray[rightPtr]] = rightPtr;
            return;
        }
        if (this.sufPtrMap[this.suffixArray[leftPtr + 1] + newOffset] == this.sufPtrMap[this.suffixArray[rightPtr] + newOffset]) {
            this.sufPtrMap[this.suffixArray[leftPtr]] = leftPtr;
            suffix1 = this.suffixArray[leftPtr + 1] + newOffset + q;
            int suffix2 = this.suffixArray[rightPtr] + newOffset + q;
            while (this.sufPtrMap[suffix1] == this.sufPtrMap[suffix2]) {
                suffix1 += q;
                suffix2 += q;
            }
            if (this.sufPtrMap[suffix1] > this.sufPtrMap[suffix2]) {
                int tmpSwap = this.suffixArray[rightPtr];
                this.suffixArray[rightPtr] = this.suffixArray[leftPtr + 1];
                this.suffixArray[leftPtr + 1] = tmpSwap;
            }
            this.sufPtrMap[this.suffixArray[leftPtr + 1]] = leftPtr + 1;
            this.sufPtrMap[this.suffixArray[rightPtr]] = rightPtr;
            return;
        }
        this.sufPtrMap[this.suffixArray[leftPtr]] = leftPtr;
        this.sufPtrMap[this.suffixArray[leftPtr + 1]] = leftPtr + 1;
        this.sufPtrMap[this.suffixArray[rightPtr]] = rightPtr;
    }

    private void computeBucketSize2_SaBucket(int leftPtr, int rightPtr, int offset, int q) {
        int suffix1 = this.suffixArray[leftPtr] + offset;
        int suffix2 = this.suffixArray[rightPtr] + offset;
        while (this.sufPtrMap[suffix1] == this.sufPtrMap[suffix2]) {
            suffix1 += q;
            suffix2 += q;
        }
        if (this.sufPtrMap[suffix1] > this.sufPtrMap[suffix2]) {
            int tmpSwap = this.suffixArray[leftPtr];
            this.suffixArray[leftPtr] = this.suffixArray[rightPtr];
            this.suffixArray[rightPtr] = tmpSwap;
        }
        this.sufPtrMap[this.suffixArray[leftPtr]] = leftPtr;
        this.sufPtrMap[this.suffixArray[rightPtr]] = rightPtr;
    }

    private int computeDiffDepthBucket_SaBucket(int leftPtr, int rightPtr, int offset, int q) {
        int lcp = offset;
        while (true) {
            int a = this.suffixArray[rightPtr];
            int tmpPtr = this.sufPtrMap[a + lcp];
            for (int runPtr = leftPtr; runPtr < rightPtr; ++runPtr) {
                if (this.sufPtrMap[this.suffixArray[runPtr] + lcp] == tmpPtr) continue;
                return lcp;
            }
            lcp += q;
        }
    }

    private void partitionUpdateRecurse_SaBucket(int leftPtr, int rightPtr, int offset, int q) {
        int leftTmpPtr;
        int smallerPivotPtr;
        int pivotRightPtr;
        int swapTmp;
        int pivot;
        int tmpSize = rightPtr - leftPtr;
        if (tmpSize < 10000) {
            pivot = this.sufPtrMap[this.suffixArray[leftPtr + (tmpSize /= 4)] + offset];
            int pivotb = this.sufPtrMap[this.suffixArray[leftPtr + 2 * tmpSize] + offset];
            int pivotc = this.sufPtrMap[this.suffixArray[rightPtr - tmpSize] + offset];
            int medNumber = this.medianOfThreeUlong(pivot, pivotb, pivotc);
            int pivotPtr = leftPtr + tmpSize;
            if (medNumber > 0) {
                pivotPtr = medNumber == 1 ? leftPtr + 2 * tmpSize : rightPtr - tmpSize;
                pivot = medNumber == 1 ? pivotb : pivotc;
            }
            swapTmp = this.suffixArray[pivotPtr];
            this.suffixArray[pivotPtr] = this.suffixArray[leftPtr];
            this.suffixArray[leftPtr] = swapTmp;
        } else {
            int i;
            int[] keyPtrList = new int[9];
            tmpSize /= 10;
            for (i = 0; i < 9; ++i) {
                keyPtrList[i] = leftPtr + (i + 1) * tmpSize;
            }
            for (i = 1; i < 9; ++i) {
                int tempValue = keyPtrList[i];
                int tempHashValue = this.sufPtrMap[this.suffixArray[tempValue] + offset];
                for (int j = i - 1; j >= 0 && this.sufPtrMap[this.suffixArray[keyPtrList[j]] + offset] > tempHashValue; --j) {
                    keyPtrList[j + 1] = keyPtrList[j];
                }
                keyPtrList[j + 1] = tempValue;
            }
            int swapTmp2 = this.suffixArray[keyPtrList[4]];
            this.suffixArray[keyPtrList[4]] = this.suffixArray[leftPtr];
            this.suffixArray[leftPtr] = swapTmp2;
            pivot = this.sufPtrMap[this.suffixArray[leftPtr] + offset];
        }
        for (pivotRightPtr = leftPtr + 1; pivotRightPtr <= rightPtr && this.sufPtrMap[this.suffixArray[pivotRightPtr] + offset] == pivot; ++pivotRightPtr) {
        }
        for (smallerPivotPtr = pivotRightPtr; smallerPivotPtr <= rightPtr && this.sufPtrMap[this.suffixArray[smallerPivotPtr] + offset] < pivot; ++smallerPivotPtr) {
        }
        int frontPtr = smallerPivotPtr - 1;
        while (frontPtr++ < rightPtr) {
            int sortkey = this.sufPtrMap[this.suffixArray[frontPtr] + offset];
            if (sortkey > pivot) continue;
            swapTmp = this.suffixArray[frontPtr];
            this.suffixArray[frontPtr] = this.suffixArray[smallerPivotPtr];
            this.suffixArray[smallerPivotPtr] = swapTmp;
            if (sortkey == pivot) {
                this.suffixArray[smallerPivotPtr] = this.suffixArray[pivotRightPtr];
                this.suffixArray[pivotRightPtr++] = swapTmp;
            }
            ++smallerPivotPtr;
        }
        int numberSmaller = smallerPivotPtr - pivotRightPtr;
        if (numberSmaller > 0) {
            int swapsize = Math.min(pivotRightPtr - leftPtr, numberSmaller);
            int pivotRightTmpPtr = leftPtr + swapsize - 1;
            this.vectorSwap(leftPtr, pivotRightTmpPtr, smallerPivotPtr - 1);
            if (numberSmaller == 1) {
                this.sufPtrMap[this.suffixArray[leftPtr]] = leftPtr;
            } else if (numberSmaller == 2) {
                this.computeBucketSize2_SaBucket(leftPtr, leftPtr + 1, offset, q);
            } else if (numberSmaller == 3) {
                this.computeBucketSize3_SaBucket(leftPtr, leftPtr + 2, offset, q);
            } else {
                this.partitionUpdateRecurse_SaBucket(leftPtr, leftPtr + numberSmaller - 1, offset, q);
            }
        }
        if ((leftTmpPtr = leftPtr + numberSmaller) == --smallerPivotPtr) {
            this.sufPtrMap[this.suffixArray[leftTmpPtr]] = leftTmpPtr;
            if (leftTmpPtr == rightPtr) {
                return;
            }
        } else {
            int newOffset;
            int n = newOffset = pivot == rightPtr ? 2 * offset : offset + q;
            if (leftTmpPtr + 1 == smallerPivotPtr) {
                this.computeBucketSize2_SaBucket(leftTmpPtr, smallerPivotPtr, newOffset, q);
                if (rightPtr == smallerPivotPtr) {
                    return;
                }
            } else if (leftTmpPtr + 2 == smallerPivotPtr) {
                this.computeBucketSize3_SaBucket(leftTmpPtr, smallerPivotPtr, newOffset, q);
                if (rightPtr == smallerPivotPtr) {
                    return;
                }
            } else {
                if (rightPtr == smallerPivotPtr) {
                    newOffset = this.computeDiffDepthBucket_SaBucket(leftPtr + numberSmaller, rightPtr, newOffset, q);
                    this.partitionUpdateRecurse_SaBucket(leftTmpPtr, rightPtr, newOffset, q);
                    return;
                }
                while (leftTmpPtr <= smallerPivotPtr) {
                    this.sufPtrMap[this.suffixArray[leftTmpPtr]] = smallerPivotPtr;
                    ++leftTmpPtr;
                }
                if (smallerPivotPtr < leftPtr + numberSmaller + 15) {
                    this.insSortUpdateRecurse_SaBucket(leftPtr + numberSmaller, smallerPivotPtr, newOffset, q);
                } else {
                    this.partitionUpdateRecurse_SaBucket(leftPtr + numberSmaller, smallerPivotPtr, newOffset, q);
                }
            }
        }
        if (++smallerPivotPtr == rightPtr) {
            this.sufPtrMap[this.suffixArray[rightPtr]] = rightPtr;
            return;
        }
        if (smallerPivotPtr + 1 == rightPtr) {
            this.computeBucketSize2_SaBucket(smallerPivotPtr, rightPtr, offset, q);
            return;
        }
        if (smallerPivotPtr + 2 == rightPtr) {
            this.computeBucketSize3_SaBucket(smallerPivotPtr, rightPtr, offset, q);
            return;
        }
        this.partitionUpdateRecurse_SaBucket(smallerPivotPtr, rightPtr, offset, q);
    }

    private void vectorSwap(int leftPtr, int rightPtr, int swapEndPtr) {
        int swapTmp = this.suffixArray[swapEndPtr];
        while (leftPtr < rightPtr) {
            this.suffixArray[swapEndPtr] = this.suffixArray[rightPtr];
            this.suffixArray[rightPtr] = this.suffixArray[--swapEndPtr];
            --rightPtr;
        }
        this.suffixArray[swapEndPtr] = this.suffixArray[leftPtr];
        this.suffixArray[leftPtr] = swapTmp;
    }

    private int[] getCharWeightedOrder_Alphabet(int[] buckets, int bucketsInLevel2Bucket) {
        int i;
        int alphabetSize = this.alphabet.size;
        int[] charWeight = new int[alphabetSize];
        int tmpBucketFactor = bucketsInLevel2Bucket * (alphabetSize + 1);
        for (i = 0; i < alphabetSize; ++i) {
            charWeight[i] = this.alphabet.charFreq[i];
            int n = i;
            charWeight[n] = charWeight[n] - (buckets[i * tmpBucketFactor + bucketsInLevel2Bucket] - buckets[i * tmpBucketFactor]);
        }
        int[] targetCharArray = new int[alphabetSize + 1];
        for (i = 0; i < alphabetSize; ++i) {
            targetCharArray[i] = i;
        }
        i = 1;
        while (i < this.alphabet.size) {
            int tmpWeight = charWeight[i];
            for (int j = i; j > 0 && tmpWeight < charWeight[targetCharArray[j - 1]]; --j) {
                targetCharArray[j] = targetCharArray[j - 1];
            }
            targetCharArray[j] = i++;
        }
        return targetCharArray;
    }

    private int[] determine_Buckets_Sarray_Sptrmap(int q) {
        if (this.kbs_getExp_Ulong(2, this.alphabet.size) >= 0) {
            return this.determinePower2Alpha_Buckets_Sarray_Sptrmap(q);
        }
        return this.determineAll_Buckets_Sarray_Sptrmap(q);
    }

    private int[] determineAll_Buckets_Sarray_Sptrmap(int q) {
        int j;
        int[] buckets = this.determineAll_Buckets_Sarray(q);
        int strLen = this.length;
        this.sufPtrMap = new int[strLen + 2 * q + 1];
        int alphabetSize = this.alphabet.size;
        int mappedUcharArray = 0;
        int tempPower = 1;
        int hashCode = 0;
        for (int i = q - 1; i >= 0; --i) {
            hashCode += this.seq[this.start + mappedUcharArray + i] * tempPower;
            tempPower *= alphabetSize;
        }
        int tempModulo = this.kbs_power_Ulong(alphabetSize, q - 1);
        mappedUcharArray += q;
        for (j = 0; j < strLen - 1; ++j) {
            this.sufPtrMap[j] = buckets[hashCode + 1] - 1;
            hashCode -= this.seq[this.start + mappedUcharArray - q] * tempModulo;
            hashCode *= alphabetSize;
            hashCode += this.seq[this.start + mappedUcharArray];
            ++mappedUcharArray;
        }
        this.sufPtrMap[j] = buckets[hashCode];
        int beginPtr = -1;
        for (j = strLen; j <= strLen + 2 * q; ++j) {
            this.sufPtrMap[j] = beginPtr--;
        }
        return buckets;
    }

    private int[] determineAll_Buckets_Sarray(int q) {
        int j;
        int i;
        int strLen = this.length;
        int alphabetSize = this.alphabet.size;
        int numberBuckets = this.kbs_power_Ulong(alphabetSize, q);
        int[] buckets = new int[numberBuckets + 1];
        for (i = 0; i < q; ++i) {
            this.seq[this.start + this.length + i] = this.alphabet.charArray[0];
        }
        for (i = 0; i < 32 - q; ++i) {
            this.seq[this.start + this.length + i + q] = 0;
        }
        int[] alphaMap = this.alphabet.alphaMapping;
        int mappedUcharArray = 0;
        int hashCode = 0;
        int tempPower = 1;
        for (int i2 = q - 1; i2 >= 0; --i2) {
            int n = alphaMap[this.seq[this.start + mappedUcharArray + i2]];
            this.seq[this.start + mappedUcharArray + i2] = n;
            hashCode += n * tempPower;
            tempPower *= alphabetSize;
        }
        int firstHashCode = hashCode;
        int tempModulo = this.kbs_power_Ulong(alphabetSize, q - 1);
        mappedUcharArray += q;
        int n = hashCode;
        buckets[n] = buckets[n] + 1;
        for (j = 1; j < strLen; ++j) {
            hashCode -= this.seq[this.start + mappedUcharArray - q] * tempModulo;
            hashCode *= alphabetSize;
            int n2 = alphaMap[this.seq[this.start + mappedUcharArray]];
            this.seq[this.start + mappedUcharArray] = n2;
            ++mappedUcharArray;
            int n3 = hashCode += n2;
            buckets[n3] = buckets[n3] + 1;
        }
        for (j = 0; j < alphabetSize; ++j) {
            this.alphabet.charFreq[j] = this.alphabet.charFreq[this.alphabet.charArray[j]];
            this.alphabet.charArray[j] = j;
            alphaMap[j] = j;
        }
        while (j < 256) {
            alphaMap[j] = -1;
            ++j;
        }
        this.suffixArray = new int[strLen + 1];
        for (j = 1; j <= numberBuckets; ++j) {
            buckets[j] = buckets[j - 1] + buckets[j];
        }
        int[] charRank = this.getCharWeightedRank_Alphabet(buckets, q);
        mappedUcharArray = q;
        hashCode = firstHashCode;
        for (j = 0; j < strLen - 1; ++j) {
            int n4 = hashCode;
            buckets[n4] = buckets[n4] - 1;
            int c1 = charRank[this.seq[this.start + mappedUcharArray - q]];
            if (c1 < charRank[this.seq[this.start + mappedUcharArray + 1 - q]] && c1 <= charRank[this.seq[this.start + mappedUcharArray + 2 - q]]) {
                this.suffixArray[buckets[hashCode]] = j;
            }
            hashCode -= this.seq[this.start + mappedUcharArray - q] * tempModulo;
            hashCode *= alphabetSize;
            hashCode += this.seq[this.start + mappedUcharArray];
            ++mappedUcharArray;
        }
        int n5 = hashCode;
        buckets[n5] = buckets[n5] - 1;
        this.suffixArray[buckets[hashCode]] = strLen - 1;
        buckets[numberBuckets] = strLen;
        return buckets;
    }

    private int[] determinePower2Alpha_Buckets_Sarray_Sptrmap(int q) {
        int j;
        int strLen = this.length;
        int exp2 = this.kbs_getExp_Ulong(2, this.alphabet.size);
        if (exp2 < 0) {
            throw new RuntimeException("value out of bounds");
        }
        int[] buckets = this.determinePower2Alpha_Buckets_Sarray(q);
        this.sufPtrMap = new int[strLen + 2 * q + 1];
        int mappedUcharArray = 0;
        int hashCode = 0;
        for (j = 0; j < q; ++j) {
            hashCode <<= exp2;
            hashCode += this.seq[this.start + mappedUcharArray + j];
        }
        int tempModulo = 0;
        tempModulo ^= 0xFFFFFFFF;
        tempModulo <<= exp2 * (q - 1);
        tempModulo ^= 0xFFFFFFFF;
        mappedUcharArray += q;
        for (j = 0; j < strLen - 1; ++j) {
            this.sufPtrMap[j] = buckets[hashCode + 1] - 1;
            hashCode &= tempModulo;
            hashCode <<= exp2;
            hashCode |= this.seq[this.start + mappedUcharArray];
            ++mappedUcharArray;
        }
        this.sufPtrMap[j] = buckets[hashCode];
        int beginPtr = -1;
        for (j = strLen; j <= strLen + 2 * q; ++j) {
            this.sufPtrMap[j] = beginPtr--;
        }
        return buckets;
    }

    private int kbs_power_Ulong(int base, int exp) {
        if (exp == 0) {
            return 1;
        }
        if (exp == 1) {
            return base;
        }
        if (base == 4) {
            if (exp > 15) {
                throw new RuntimeException();
            }
            return 4 << 2 * (exp - 1);
        }
        int p = 1;
        while (exp > 0) {
            p *= base;
            --exp;
        }
        return p;
    }

    private int[] determinePower2Alpha_Buckets_Sarray(int q) {
        int j;
        int i;
        int exp2 = this.kbs_getExp_Ulong(2, this.alphabet.size);
        int strLen = this.length;
        int mappedUcharArray = 0;
        for (i = 0; i < q; ++i) {
            this.seq[this.start + this.length + i] = this.alphabet.charArray[0];
        }
        for (i = this.length + q; i < this.length + 32 - q; ++i) {
            this.seq[this.start + i] = 0;
        }
        int numberBuckets = this.kbs_power_Ulong(this.alphabet.size, q);
        int[] buckets = new int[numberBuckets + 1];
        int hashCode = 0;
        for (int j2 = 0; j2 < q; ++j2) {
            hashCode <<= exp2;
            int n = this.alphabet.alphaMapping[this.seq[this.start + mappedUcharArray + j2]];
            this.seq[this.start + mappedUcharArray + j2] = n;
            hashCode += n;
        }
        int firstHashCode = hashCode;
        int tempModulo = 0;
        tempModulo ^= 0xFFFFFFFF;
        tempModulo <<= exp2 * (q - 1);
        tempModulo ^= 0xFFFFFFFF;
        mappedUcharArray += q;
        int n = hashCode;
        buckets[n] = buckets[n] + 1;
        for (j = 1; j < strLen; ++j) {
            hashCode &= tempModulo;
            hashCode <<= exp2;
            int n2 = this.alphabet.alphaMapping[this.seq[this.start + mappedUcharArray]];
            this.seq[this.start + mappedUcharArray] = n2;
            ++mappedUcharArray;
            int n3 = hashCode |= n2;
            buckets[n3] = buckets[n3] + 1;
        }
        for (j = 0; j < this.alphabet.size; ++j) {
            this.alphabet.charFreq[j] = this.alphabet.charFreq[this.alphabet.charArray[j]];
            this.alphabet.charArray[j] = j;
            this.alphabet.alphaMapping[j] = j;
        }
        while (j < 256) {
            this.alphabet.alphaMapping[j] = -1;
            ++j;
        }
        this.suffixArray = new int[strLen + 1];
        for (j = 1; j <= numberBuckets; ++j) {
            buckets[j] = buckets[j - 1] + buckets[j];
        }
        int[] charRank = this.getCharWeightedRank_Alphabet(buckets, q);
        mappedUcharArray = q;
        hashCode = firstHashCode;
        for (j = 0; j < strLen - 1; ++j) {
            int n4 = hashCode;
            buckets[n4] = buckets[n4] - 1;
            int c1 = charRank[this.seq[this.start + mappedUcharArray - q]];
            if (c1 < charRank[this.seq[this.start + mappedUcharArray + 1 - q]] && c1 <= charRank[this.seq[this.start + mappedUcharArray + 2 - q]]) {
                this.suffixArray[buckets[hashCode]] = j;
            }
            hashCode &= tempModulo;
            hashCode <<= exp2;
            hashCode |= this.seq[this.start + mappedUcharArray];
            ++mappedUcharArray;
        }
        int n5 = hashCode;
        buckets[n5] = buckets[n5] - 1;
        this.suffixArray[buckets[hashCode]] = strLen - 1;
        buckets[numberBuckets] = strLen;
        return buckets;
    }

    private int[] getCharWeightedRank_Alphabet(int[] buckets, int q) {
        int i;
        int alphabetSize = this.alphabet.size;
        int[] charWeight = new int[alphabetSize];
        int bucketsInLevel2Bucket = this.kbs_power_Ulong(alphabetSize, q - 2);
        int tmpBucketFactor = bucketsInLevel2Bucket * (alphabetSize + 1);
        charWeight[0] = this.alphabet.charFreq[0];
        charWeight[0] = charWeight[0] - buckets[bucketsInLevel2Bucket - 1];
        for (i = 1; i < alphabetSize - 1; ++i) {
            charWeight[i] = this.alphabet.charFreq[i];
            int n = i;
            charWeight[n] = charWeight[n] - (buckets[i * tmpBucketFactor + bucketsInLevel2Bucket - 1] - buckets[i * tmpBucketFactor - 1]);
        }
        charWeight[alphabetSize - 1] = this.alphabet.charFreq[i];
        int n = alphabetSize - 1;
        charWeight[n] = charWeight[n] - (buckets[(alphabetSize - 1) * tmpBucketFactor + bucketsInLevel2Bucket - 1] - buckets[(alphabetSize - 1) * tmpBucketFactor - 1]);
        int[] targetCharArray = new int[alphabetSize];
        for (i = 0; i < alphabetSize; ++i) {
            targetCharArray[i] = i;
        }
        i = 1;
        while (i < this.alphabet.size) {
            int tmpWeight = charWeight[i];
            for (int j = i; j > 0 && tmpWeight < charWeight[targetCharArray[j - 1]]; --j) {
                targetCharArray[j] = targetCharArray[j - 1];
            }
            targetCharArray[j] = i++;
        }
        int[] charRank = new int[alphabetSize + 1];
        for (i = 0; i < alphabetSize; ++i) {
            charRank[targetCharArray[i]] = i;
        }
        return charRank;
    }

    private int kbs_getExp_Ulong(int base, int value) {
        int exp = 0;
        int tmpValue = 1;
        while (tmpValue < value) {
            tmpValue *= base;
            ++exp;
        }
        if (tmpValue == value) {
            return exp;
        }
        return -1;
    }

    private int medianOfThreeUlong(int a, int b, int c) {
        if (a == b || a == c) {
            return 0;
        }
        if (b == c) {
            return 2;
        }
        return a < b ? (b < c ? 1 : (a < c ? 2 : 0)) : (b > c ? 1 : (a < c ? 0 : 2));
    }

    private static final class Alphabet {
        int size = 0;
        int[] charArray;
        int[] alphaMapping = new int[256];
        int[] charFreq = new int[256];

        Alphabet(int[] thisString, int stringLength) {
            for (int i = 0; i < stringLength; ++i) {
                int tmpChar = thisString[i];
                Tools.assertAlways(tmpChar >= 0, "Input must be positive");
                if (this.charFreq[tmpChar] == 0) {
                    ++this.size;
                }
                int n = tmpChar;
                this.charFreq[n] = this.charFreq[n] + 1;
            }
            this.charArray = new int[this.size + 1];
            this.charArray[this.size] = 0;
            int k = 0;
            for (int i = 0; i < 256; ++i) {
                this.alphaMapping[i] = -1;
                if (this.charFreq[i] <= 0) continue;
                this.charArray[k] = i;
                this.alphaMapping[i] = k++;
            }
            Tools.assertAlways(k == this.size, "k != size");
        }
    }
}

