/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.suffixarray;

import eu.interedition.collatex.suffixarray.ISuffixArrayBuilder;
import eu.interedition.collatex.suffixarray.MinMax;
import eu.interedition.collatex.suffixarray.Tools;

public class QSufSort
implements ISuffixArrayBuilder {
    private int[] I;
    private int[] V;
    private int r;
    private int h;
    private final boolean preserveInput;
    private int start;

    public QSufSort() {
        this.preserveInput = true;
    }

    public QSufSort(boolean preserveInput) {
        this.preserveInput = preserveInput;
    }

    @Override
    public final int[] buildSuffixArray(int[] input, int start, int length) {
        Tools.assertAlways(input.length >= start + length + 1, "no extra space after input end");
        MinMax minmax = Tools.minmax(input, start, length);
        Tools.assertAlways(minmax.min >= 0, "input must not be negative");
        this.I = new int[length + 1];
        this.start = start;
        if (this.preserveInput) {
            this.V = new int[length + 1];
            this.start = 0;
            System.arraycopy(input, start, this.V, 0, length);
        } else {
            this.V = input;
        }
        this.suffixsort(length, minmax.max + 1, minmax.min);
        int[] tmp = this.I;
        this.I = null;
        this.V = null;
        return tmp;
    }

    private void suffixsort(int n, int k, int l) {
        int i;
        if (n >= k - l) {
            int j = this.transform(n, k, l, n);
            this.bucketsort(n, j);
        } else {
            this.transform(n, k, l, Integer.MAX_VALUE);
            for (i = 0; i <= n; ++i) {
                this.I[i] = i;
            }
            this.h = 0;
            this.sort_split(0, n + 1);
        }
        this.h = this.r;
        while (this.I[0] >= -n) {
            int pi = 0;
            int sl = 0;
            do {
                int s;
                if ((s = this.I[pi]) < 0) {
                    pi -= s;
                    sl += s;
                    continue;
                }
                if (sl != 0) {
                    this.I[pi + sl] = sl;
                    sl = 0;
                }
                int pk = this.V[this.start + s] + 1;
                this.sort_split(pi, pk - pi);
                pi = pk;
            } while (pi <= n);
            if (sl != 0) {
                this.I[pi + sl] = sl;
            }
            this.h = 2 * this.h;
        }
        for (i = 0; i <= n; ++i) {
            if (this.V[this.start + i] <= 0) continue;
            this.I[this.V[this.start + i] - 1] = i;
        }
    }

    private void sort_split(int p, int n) {
        int pd;
        int pb;
        if (n < 7) {
            this.select_sort_split(p, n);
            return;
        }
        int v = this.choose_pivot(p, n);
        int pa = pb = p;
        int pc = pd = p + n - 1;
        while (true) {
            int f;
            if (pb <= pc && (f = this.KEY(pb)) <= v) {
                if (f == v) {
                    this.SWAP(pa, pb);
                    ++pa;
                }
                ++pb;
                continue;
            }
            while (pc >= pb && (f = this.KEY(pc)) >= v) {
                if (f == v) {
                    this.SWAP(pc, pd);
                    --pd;
                }
                --pc;
            }
            if (pb > pc) break;
            this.SWAP(pb, pc);
            ++pb;
            --pc;
        }
        int pn = p + n;
        int s = pa - p;
        int t = pb - pa;
        if (s > t) {
            s = t;
        }
        int pl = p;
        int pm = pb - s;
        while (s != 0) {
            this.SWAP(pl, pm);
            --s;
            ++pl;
            ++pm;
        }
        s = pd - pc;
        t = pn - pd - 1;
        if (s > t) {
            s = t;
        }
        pl = pb;
        pm = pn - s;
        while (s != 0) {
            this.SWAP(pl, pm);
            --s;
            ++pl;
            ++pm;
        }
        s = pb - pa;
        t = pd - pc;
        if (s > 0) {
            this.sort_split(p, s);
        }
        this.update_group(p + s, p + n - t - 1);
        if (t > 0) {
            this.sort_split(p + n - t, t);
        }
    }

    private void update_group(int pl, int pm) {
        int g;
        this.V[this.start + this.I[pl]] = g = pm;
        if (pl == pm) {
            this.I[pl] = -1;
        } else {
            do {
                this.V[this.start + this.I[++pl]] = g;
            } while (pl < pm);
        }
    }

    private int choose_pivot(int p, int n) {
        int pm = p + (n >> 1);
        if (n > 7) {
            int pl = p;
            int pn = p + n - 1;
            if (n > 40) {
                int s = n >> 3;
                pl = this.MED3(pl, pl + s, pl + s + s);
                pm = this.MED3(pm - s, pm, pm + s);
                pn = this.MED3(pn - s - s, pn - s, pn);
            }
            pm = this.MED3(pl, pm, pn);
        }
        return this.KEY(pm);
    }

    private void select_sort_split(int p, int n) {
        int pa = p;
        int pn = p + n - 1;
        while (pa < pn) {
            int pb;
            int f = this.KEY(pa);
            for (int pi = pb = pa + 1; pi <= pn; ++pi) {
                int v = this.KEY(pi);
                if (v < f) {
                    f = v;
                    this.SWAP(pi, pa);
                    pb = pa + 1;
                    continue;
                }
                if (v != f) continue;
                this.SWAP(pi, pb);
                ++pb;
            }
            this.update_group(pa, pb - 1);
            pa = pb;
        }
        if (pa == pn) {
            this.V[this.start + this.I[pa]] = pa;
            this.I[pa] = -1;
        }
    }

    private void bucketsort(int n, int k) {
        int c;
        int pi;
        for (pi = 0; pi < k; ++pi) {
            this.I[pi] = -1;
        }
        int i = 0;
        while (i <= n) {
            c = this.V[this.start + i];
            this.V[this.start + i] = this.I[c];
            this.I[c] = i++;
        }
        i = n;
        for (pi = k - 1; pi >= 0; --pi) {
            int g;
            c = this.I[pi];
            int d = this.V[this.start + c];
            this.V[this.start + c] = g = i;
            if (d >= 0) {
                this.I[i--] = c;
                do {
                    c = d;
                    d = this.V[this.start + c];
                    this.V[this.start + c] = g;
                    this.I[i--] = c;
                } while (d >= 0);
                continue;
            }
            this.I[i--] = -1;
        }
    }

    private int transform(int n, int k, int l, int q) {
        int j;
        int c;
        int i;
        int s = 0;
        for (i = k - l; i != 0; i >>= 1) {
            ++s;
        }
        int e = Integer.MAX_VALUE >> s;
        this.r = 0;
        int d = 0;
        int b = 0;
        while (this.r < n && d <= e && (c = d << s | k - l) <= q) {
            b = b << s | this.V[this.start + this.r] - l + 1;
            d = c;
            ++this.r;
        }
        int m = (1 << (this.r - 1) * s) - 1;
        this.V[this.start + n] = l - 1;
        if (d <= n) {
            int pi;
            for (pi = 0; pi <= d; ++pi) {
                this.I[pi] = 0;
            }
            c = b;
            for (pi = this.r; pi <= n; ++pi) {
                this.I[c] = 1;
                c = (c & m) << s | this.V[this.start + pi] - l + 1;
            }
            for (i = 1; i < this.r; ++i) {
                this.I[c] = 1;
                c = (c & m) << s;
            }
            j = 1;
            for (pi = 0; pi <= d; ++pi) {
                if (this.I[pi] == 0) continue;
                this.I[pi] = j++;
            }
            pi = 0;
            c = b;
            for (int pj = this.r; pj <= n; ++pj) {
                this.V[this.start + pi] = this.I[c];
                c = (c & m) << s | this.V[this.start + pj] - l + 1;
                ++pi;
            }
            while (pi < n) {
                this.V[this.start + pi++] = this.I[c];
                c = (c & m) << s;
            }
        } else {
            int pi = 0;
            c = b;
            for (int pj = this.r; pj <= n; ++pj) {
                this.V[this.start + pi] = c;
                c = (c & m) << s | this.V[this.start + pj] - l + 1;
                ++pi;
            }
            while (pi < n) {
                this.V[this.start + pi++] = c;
                c = (c & m) << s;
            }
            j = d + 1;
        }
        this.V[this.start + n] = 0;
        return j;
    }

    private int KEY(int p) {
        return this.V[this.start + this.I[p] + this.h];
    }

    private void SWAP(int a, int b) {
        int tmp = this.I[a];
        this.I[a] = this.I[b];
        this.I[b] = tmp;
    }

    private int MED3(int a, int b, int c) {
        return this.KEY(a) < this.KEY(b) ? (this.KEY(b) < this.KEY(c) ? b : (this.KEY(a) < this.KEY(c) ? c : a)) : (this.KEY(b) > this.KEY(c) ? b : (this.KEY(a) > this.KEY(c) ? c : a));
    }
}

