/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.suffixarray;

import java.util.ArrayDeque;
import java.util.ArrayList;

public final class Traversals {
    public static void postorder(int sequenceLength, int[] sa, int[] lcp, IPostOrderVisitor visitor) {
        assert (sequenceLength <= sa.length && sequenceLength <= lcp.length) : "Input sequence length larger than suffix array or the LCP.";
        ArrayDeque<Integer> stack = new ArrayDeque<Integer>();
        stack.push(-1);
        stack.push(-1);
        for (int i = 0; i <= sequenceLength; ++i) {
            int top_h;
            int h;
            int n = h = sequenceLength == i ? -1 : lcp[i];
            while ((top_h = ((Integer)stack.peek()).intValue()) > h) {
                stack.pop();
                int top_i = (Integer)stack.pop();
                boolean leaf = top_i < 0;
                visitor.visitNode(sa[leaf ? -(top_i + 1) : top_i], top_h, leaf);
            }
            if (top_h < h) {
                stack.push(i);
                stack.push(h);
            }
            if (i >= sequenceLength) continue;
            stack.push(-(i + 1));
            stack.push(sequenceLength - sa[i]);
        }
    }

    public static <E> void postorder(int sequenceLength, int[] sa, int[] lcp, E epsilon, IPostOrderComputingVisitor<E> visitor) {
        assert (sequenceLength <= sa.length && sequenceLength <= lcp.length) : "Input sequence length larger than suffix array or the LCP.";
        ArrayDeque<Integer> stack = new ArrayDeque<Integer>();
        ArrayList<E> values = new ArrayList<E>();
        stack.push(-1);
        stack.push(-1);
        values.add(epsilon);
        for (int i = 0; i <= sequenceLength; ++i) {
            int top_h;
            int h = sequenceLength == i ? -1 : lcp[i];
            E ci = epsilon;
            while ((top_h = ((Integer)stack.peek()).intValue()) > h) {
                stack.pop();
                Object top_c = values.remove(values.size() - 1);
                int top_i = (Integer)stack.pop();
                boolean leaf = top_i < 0;
                ci = visitor.aggregate(top_c, ci);
                visitor.visitNode(sa[leaf ? -(top_i + 1) : top_i], top_h, leaf, ci);
                top_c = values.get(values.size() - 1);
            }
            if (top_h < h) {
                stack.push(i);
                stack.push(h);
                values.add(ci);
            } else {
                assert (top_h == h);
                int index = values.size() - 1;
                values.set(index, visitor.aggregate(ci, values.get(index)));
            }
            if (i >= sequenceLength) continue;
            stack.push(-(i + 1));
            stack.push(sequenceLength - sa[i]);
            values.add(visitor.leafValue(i, sa[i], sequenceLength - sa[i]));
        }
    }

    public static interface IPostOrderComputingVisitor<E> {
        public E aggregate(E var1, E var2);

        public E leafValue(int var1, int var2, int var3);

        public void visitNode(int var1, int var2, boolean var3, E var4);
    }

    public static interface IPostOrderVisitor {
        public void visitNode(int var1, int var2, boolean var3);
    }
}

