/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.suffixtree;

import eu.interedition.collatex.suffixtree.Edge;
import eu.interedition.collatex.suffixtree.Node;
import eu.interedition.collatex.suffixtree.Suffix;

class ActivePoint<T, S extends Iterable<T>> {
    private Node<T, S> activeNode;
    private Edge<T, S> activeEdge;
    private int activeLength;
    private final Node<T, S> root;

    ActivePoint(Node<T, S> root) {
        this.activeNode = root;
        this.activeEdge = null;
        this.activeLength = 0;
        this.root = root;
    }

    void setPosition(Node<T, S> node, Edge<T, S> edge, int length) {
        this.activeNode = node;
        this.activeEdge = edge;
        this.activeLength = length;
    }

    void setEdge(Edge<T, S> edge) {
        this.activeEdge = edge;
    }

    void incrementLength() {
        ++this.activeLength;
        this.resetActivePointToTerminal();
    }

    void decrementLength() {
        if (this.activeLength > 0) {
            --this.activeLength;
        }
        this.resetActivePointToTerminal();
    }

    boolean isRootNode() {
        return this.activeNode.equals(this.root) && this.activeEdge == null && this.activeLength == 0;
    }

    boolean isNode() {
        return this.activeEdge == null && this.activeLength == 0;
    }

    Node<T, S> getNode() {
        return this.activeNode;
    }

    boolean isEdge() {
        return this.activeEdge != null;
    }

    Edge<T, S> getEdge() {
        return this.activeEdge;
    }

    int getLength() {
        return this.activeLength;
    }

    public void updateAfterInsert(Suffix<T, S> suffix) {
        if (this.activeNode == this.root && suffix.isEmpty()) {
            this.activeNode = this.root;
            this.activeEdge = null;
            this.activeLength = 0;
        } else if (this.activeNode == this.root) {
            Object item = suffix.getStart();
            this.activeEdge = this.root.getEdgeStarting(item);
            this.decrementLength();
            this.fixActiveEdgeAfterSuffixLink(suffix);
            if (this.activeLength == 0) {
                this.activeEdge = null;
            }
        } else if (this.activeNode.hasSuffixLink()) {
            this.activeNode = this.activeNode.getSuffixLink();
            this.findTrueActiveEdge();
            this.fixActiveEdgeAfterSuffixLink(suffix);
            if (this.activeLength == 0) {
                this.activeEdge = null;
            }
        } else {
            this.activeNode = this.root;
            this.findTrueActiveEdge();
            this.fixActiveEdgeAfterSuffixLink(suffix);
            if (this.activeLength == 0) {
                this.activeEdge = null;
            }
        }
    }

    private void fixActiveEdgeAfterSuffixLink(Suffix<T, S> suffix) {
        while (this.activeEdge != null && this.activeLength > this.activeEdge.getLength()) {
            this.activeLength -= this.activeEdge.getLength();
            this.activeNode = this.activeEdge.getTerminal();
            Object item = suffix.getItemXFromEnd(this.activeLength + 1);
            this.activeEdge = this.activeNode.getEdgeStarting(item);
        }
        this.resetActivePointToTerminal();
    }

    private void findTrueActiveEdge() {
        if (this.activeEdge != null) {
            T item = this.activeEdge.getStartItem();
            this.activeEdge = this.activeNode.getEdgeStarting(item);
        }
    }

    private boolean resetActivePointToTerminal() {
        if (this.activeEdge != null && this.activeEdge.getLength() == this.activeLength && this.activeEdge.isTerminating()) {
            this.activeNode = this.activeEdge.getTerminal();
            this.activeEdge = null;
            this.activeLength = 0;
            return true;
        }
        return false;
    }

    public String toString() {
        return "{" + this.activeNode.toString() + ", " + this.activeEdge + ", " + this.activeLength + "}";
    }
}

