/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.suffixtree;

import eu.interedition.collatex.suffixtree.ActivePoint;
import eu.interedition.collatex.suffixtree.Node;
import eu.interedition.collatex.suffixtree.Sequence;
import eu.interedition.collatex.suffixtree.SequenceTerminal;
import eu.interedition.collatex.suffixtree.Suffix;
import eu.interedition.collatex.suffixtree.SuffixTree;
import java.util.Iterator;

class Edge<T, S extends Iterable<T>>
implements Iterable<T> {
    private final int start;
    private int end = -1;
    private final Node<T, S> parentNode;
    private final Sequence<T, S> sequence;
    private Node<T, S> terminal = null;
    private SuffixTree<T, S> tree = null;

    Edge(int start, Node<T, S> parent, Sequence<T, S> sequence, SuffixTree<T, S> tree) {
        this.start = start;
        this.parentNode = parent;
        this.sequence = sequence;
        this.tree = tree;
    }

    boolean isStarting(Object item) {
        return this.sequence.getItem(this.start).equals(item);
    }

    void insert(Suffix<T, S> suffix, ActivePoint<T, S> activePoint) {
        T nextItem;
        Object item = suffix.getEndItem();
        if (item.equals(nextItem = this.getItemAt(activePoint.getLength()))) {
            activePoint.incrementLength();
        } else {
            this.split(suffix, activePoint);
            suffix.decrement();
            activePoint.updateAfterInsert(suffix);
            if (suffix.isEmpty()) {
                return;
            }
            this.tree.insert(suffix);
        }
    }

    private void split(Suffix<T, S> suffix, ActivePoint<T, S> activePoint) {
        Node<T, S> breakNode = new Node<T, S>(this, this.sequence, this.tree);
        Edge<T, S> newEdge = new Edge<T, S>(suffix.getEndPosition() - 1, breakNode, this.sequence, this.tree);
        breakNode.insert(newEdge);
        Edge<T, S> oldEdge = new Edge<T, S>(this.start + activePoint.getLength(), breakNode, this.sequence, this.tree);
        oldEdge.end = this.end;
        oldEdge.terminal = this.terminal;
        breakNode.insert(oldEdge);
        this.terminal = breakNode;
        this.end = this.start + activePoint.getLength();
        this.tree.setSuffixLink(breakNode);
        this.tree.incrementInsertCount();
    }

    int getEnd() {
        this.tree.getCurrentEnd();
        return this.end != -1 ? this.end : this.tree.getCurrentEnd();
    }

    boolean isTerminating() {
        return this.terminal != null;
    }

    int getLength() {
        int realEnd = this.getEnd();
        return realEnd - this.start;
    }

    Node<T, S> getTerminal() {
        return this.terminal;
    }

    T getItemAt(int position) {
        if (position > this.getLength()) {
            throw new IllegalArgumentException("Index " + position + " is greater than " + this.getLength() + " - the length of this edge.");
        }
        return (T)this.sequence.getItem(this.start + position);
    }

    T getStartItem() {
        return (T)this.sequence.getItem(this.start);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = this.start; i < this.getEnd(); ++i) {
            sb.append(this.sequence.getItem(i).toString()).append(", ");
            if (this.sequence.getItem(i).getClass().equals(SequenceTerminal.class)) break;
        }
        return sb.toString();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int currentPosition;
            private boolean hasNext;
            {
                this.currentPosition = Edge.this.start;
                this.hasNext = true;
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public T next() {
                this.hasNext = Edge.this.end == -1 ? !Edge.this.sequence.getItem(this.currentPosition).getClass().equals(SequenceTerminal.class) : this.currentPosition < Edge.this.getEnd() - 1;
                return Edge.this.sequence.getItem(this.currentPosition++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The remove method is not supported.");
            }
        };
    }
}

