/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.tools;

import eu.interedition.collatex.tools.CollationPipe;
import eu.interedition.collatex.tools.CollationServer;
import eu.interedition.collatex.tools.PluginScript;
import java.io.IOException;
import java.io.PrintWriter;
import javax.script.ScriptException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.xml.sax.SAXException;

public class CollateX {
    public static final PrintWriter ERROR_LOG = new PrintWriter(System.err);
    static final Options OPTIONS = new Options();

    public static void main(String ... args) {
        try {
            CommandLine commandLine = new GnuParser().parse(OPTIONS, args);
            if (commandLine.hasOption("h")) {
                CollateX.help();
            } else if (commandLine.hasOption("S")) {
                CollationServer.start(commandLine);
            } else {
                CollationPipe.start(commandLine);
            }
        }
        catch (ParseException e) {
            CollateX.error("Error while parsing command line arguments (-h for usage instructions)", e);
        }
        catch (IllegalArgumentException e) {
            CollateX.error("Illegal argument", e);
        }
        catch (IOException e) {
            CollateX.error("I/O error", e);
        }
        catch (SAXException e) {
            CollateX.error("XML error", e);
        }
        catch (XPathExpressionException e) {
            CollateX.error("XPath error", e);
        }
        catch (PluginScript.PluginScriptExecutionException | ScriptException e) {
            CollateX.error("Script error", e);
        }
        catch (Throwable t) {
            CollateX.error("Unexpected error", t);
            t.printStackTrace(ERROR_LOG);
        }
        finally {
            ERROR_LOG.flush();
        }
    }

    private static void help() {
        new HelpFormatter().printHelp(ERROR_LOG, 78, "collatex [<options>]\n (<json_input> | <witness_1> <witness_2> [[<witness_3>] ...])", "", OPTIONS, 2, 4, "");
    }

    public static void error(String str, Throwable t) {
        ERROR_LOG.println(str);
        ERROR_LOG.println(t.getMessage());
    }

    static {
        OPTIONS.addOption("h", "help", false, "print usage instructions");
        OPTIONS.addOption("o", "output", true, "output file; '-' for standard output (default)");
        OPTIONS.addOption("ie", "input-encoding", true, "charset to use for decoding non-XML witnesses; default: UTF-8");
        OPTIONS.addOption("oe", "output-encoding", true, "charset to use for encoding the output; default: UTF-8");
        OPTIONS.addOption("xml", "xml-mode", false, "witnesses are treated as XML documents");
        OPTIONS.addOption("xp", "xpath", true, "XPath 1.0 expression evaluating to tokens of XML witnesses; default: '//text()'");
        OPTIONS.addOption("a", "algorithm", true, "progressive alignment algorithm to use 'dekker' (default), 'medite', 'needleman-wunsch'");
        OPTIONS.addOption("t", "tokenized", false, "consecutive matches of tokens will *not* be joined to segments");
        OPTIONS.addOption("f", "format", true, "result/output format: 'json', 'csv', 'dot', 'graphml', 'tei'");
        OPTIONS.addOption("s", "script", true, "ECMA/JavaScript resource with functions to be plugged into the alignment algorithm");
        OPTIONS.addOption("S", "http", false, "start RESTful HTTP server");
        OPTIONS.addOption("cp", "context-path", true, "URL base/context path of the service, default: '/'");
        OPTIONS.addOption("dot", "dot-path", true, "path to Graphviz 'dot', auto-detected by default");
        OPTIONS.addOption("p", "port", true, "HTTP port to bind server to, default: 7369");
        OPTIONS.addOption("mpc", "max-parallel-collations", true, "maximum number of collations to perform in parallel, default: 2");
        OPTIONS.addOption("mcs", "max-collation-size", true, "maximum number of characters (counted over all witnesses) to perform collations on, default: unlimited");
    }
}

