/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.tools;

import eu.interedition.collatex.VariantGraph;
import eu.interedition.collatex.simple.SimpleCollation;
import eu.interedition.collatex.simple.SimpleToken;
import eu.interedition.collatex.simple.SimpleVariantGraphSerializer;
import eu.interedition.collatex.simple.SimpleWitness;
import eu.interedition.collatex.tools.CollationPipe;
import eu.interedition.collatex.tools.JsonProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.cli.CommandLine;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.http.CompressionConfig;
import org.glassfish.grizzly.http.server.CLStaticHttpHandler;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.HttpServerProbe;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.http.server.StaticHttpHandler;
import org.glassfish.grizzly.http.server.StaticHttpHandlerBase;
import org.glassfish.grizzly.http.server.accesslog.AccessLogAppender;
import org.glassfish.grizzly.http.server.accesslog.AccessLogProbe;
import org.glassfish.grizzly.http.server.accesslog.ApacheLogFormat;
import org.glassfish.grizzly.http.util.Header;

public class CollationServer {
    private static final Logger LOG = Logger.getLogger(CollationServer.class.getName());
    private final int maxCollationSize;
    private final String dotPath;
    private final ExecutorService collationThreads;
    private final ExecutorService processThreads = Executors.newCachedThreadPool();

    public CollationServer(int maxParallelCollations, int maxCollationSize, String dotPath) {
        this.collationThreads = Executors.newFixedThreadPool(maxParallelCollations, new ThreadFactory(){
            private final AtomicLong counter = new AtomicLong();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "collator-" + this.counter.incrementAndGet());
                t.setDaemon(true);
                t.setPriority(1);
                return t;
            }
        });
        this.maxCollationSize = maxCollationSize;
        this.dotPath = dotPath;
    }

    public static void start(CommandLine commandLine) {
        final CollationServer collator = new CollationServer(Integer.parseInt(commandLine.getOptionValue("mpc", "2")), Integer.parseInt(commandLine.getOptionValue("mcs", "0")), Optional.ofNullable(commandLine.getOptionValue("dot")).orElse(CollationServer.detectDotPath()));
        String staticPath = System.getProperty("collatex.static.path", "");
        StaticHttpHandlerBase httpHandler = staticPath.isEmpty() ? new CLStaticHttpHandler(CollationPipe.class.getClassLoader(), new String[]{"/static/"}){

            @Override
            protected void onMissingResource(Request request, Response response) throws Exception {
                collator.service(request, response);
            }
        } : new StaticHttpHandler(new String[]{staticPath.replaceAll("/+$", "") + "/"}){

            @Override
            protected void onMissingResource(Request request, Response response) throws Exception {
                collator.service(request, response);
            }
        };
        NetworkListener httpListener = new NetworkListener("http", "0.0.0.0", Integer.parseInt(commandLine.getOptionValue("p", "7369")));
        CompressionConfig compressionConfig = httpListener.getCompressionConfig();
        compressionConfig.setCompressionMode(CompressionConfig.CompressionMode.ON);
        compressionConfig.setCompressionMinSize(860);
        compressionConfig.setCompressableMimeTypes("application/javascript", "application/json", "application/xml", "text/css", "text/html", "text/javascript", "text/plain", "text/xml");
        HttpServer httpServer = new HttpServer();
        ServerConfiguration httpServerConfig = httpServer.getServerConfiguration();
        httpServer.addListener(httpListener);
        httpServerConfig.addHttpHandler((HttpHandler)httpHandler, commandLine.getOptionValue("cp", "").replaceAll("/+$", "") + "/*");
        httpServerConfig.getMonitoringConfig().getWebServerConfig().addProbes((HttpServerProbe[])new HttpServerProbe[]{new AccessLogProbe(new StandardOutAccessLogAppender(), ApacheLogFormat.COMBINED)});
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LOG.info("Stopping HTTP server");
            httpServer.shutdown();
        }));
        try {
            httpServer.start();
            Thread.sleep(Long.MAX_VALUE);
        }
        catch (IOException | InterruptedException e) {
            LOG.log(Level.SEVERE, e, e::getMessage);
        }
    }

    public void service(Request request, Response response) throws Exception {
        Deque<String> path = CollationServer.path(request);
        if (path.isEmpty() || !"collate".equals(path.pop())) {
            response.sendError(404);
            return;
        }
        SimpleCollation collation = JsonProcessor.read(request.getInputStream());
        if (this.maxCollationSize > 0) {
            for (SimpleWitness witness : collation.getWitnesses()) {
                int witnessLength = witness.getTokens().stream().filter(t -> t instanceof SimpleToken).map(t -> (SimpleToken)t).collect(Collectors.summingInt(t -> t.getContent().length()));
                if (witnessLength <= this.maxCollationSize) continue;
                response.sendError(413, "Request Entity Too Large");
                return;
            }
        }
        response.suspend(60L, TimeUnit.SECONDS, new EmptyCompletionHandler<Response>());
        this.collationThreads.submit(() -> {
            block69: {
                try {
                    VariantGraph graph = new VariantGraph();
                    collation.collate(graph);
                    response.setHeader("Access-Control-Allow-Origin", Optional.ofNullable(request.getHeader("Origin")).orElse("*"));
                    response.setHeader("Access-Control-Allow-Methods", Optional.ofNullable(request.getHeader("Access-Control-Request-Method")).orElse("GET, POST, HEAD, OPTIONS"));
                    response.setHeader("Access-Control-Allow-Headers", Optional.ofNullable(request.getHeader("Access-Control-Request-Headers")).orElse("Content-Type, Accept, X-Requested-With"));
                    response.setHeader("Access-Control-Max-Age", "86400");
                    response.setHeader("Access-Control-Allow-Credentials", "true");
                    String clientAccepts = Optional.ofNullable(request.getHeader(Header.Accept)).orElse("");
                    if (clientAccepts.contains("text/plain")) {
                        response.setContentType("text/plain");
                        response.setCharacterEncoding("utf-8");
                        try (Writer out = response.getWriter();){
                            new SimpleVariantGraphSerializer(graph).toDot(out);
                        }
                        response.resume();
                        break block69;
                    }
                    if (clientAccepts.contains("application/tei+xml")) {
                        XMLStreamWriter xml = null;
                        try {
                            response.setContentType("application/tei+xml");
                            try (OutputStream responseStream = response.getOutputStream();){
                                xml = XMLOutputFactory.newInstance().createXMLStreamWriter(responseStream);
                                xml.writeStartDocument();
                                new SimpleVariantGraphSerializer(graph).toTEI(xml);
                                xml.writeEndDocument();
                            }
                            finally {
                                if (xml != null) {
                                    xml.close();
                                }
                            }
                            response.resume();
                        }
                        catch (XMLStreamException e) {
                            e.printStackTrace();
                        }
                        break block69;
                    }
                    if (clientAccepts.contains("application/graphml+xml")) {
                        XMLStreamWriter xml = null;
                        try {
                            response.setContentType("application/graphml+xml");
                            try (OutputStream responseStream = response.getOutputStream();){
                                xml = XMLOutputFactory.newInstance().createXMLStreamWriter(responseStream);
                                xml.writeStartDocument();
                                new SimpleVariantGraphSerializer(graph).toGraphML(xml);
                                xml.writeEndDocument();
                            }
                            finally {
                                if (xml != null) {
                                    xml.close();
                                }
                            }
                            response.resume();
                        }
                        catch (XMLStreamException e) {
                            e.printStackTrace();
                        }
                        break block69;
                    }
                    if (clientAccepts.contains("image/svg+xml")) {
                        if (this.dotPath == null) {
                            response.sendError(204);
                            response.resume();
                        } else {
                            StringWriter dot = new StringWriter();
                            new SimpleVariantGraphSerializer(graph).toDot(dot);
                            Process dotProc = new ProcessBuilder(this.dotPath, "-Grankdir=LR", "-Gid=VariantGraph", "-Tsvg").start();
                            StringWriter errors = new StringWriter();
                            ((CompletableFuture)CompletableFuture.allOf(CompletableFuture.runAsync(() -> {
                                char[] buf = new char[8192];
                                try (InputStreamReader errorStream = new InputStreamReader(dotProc.getErrorStream());){
                                    int len;
                                    while ((len = errorStream.read(buf)) >= 0) {
                                        errors.write(buf, 0, len);
                                    }
                                }
                                catch (IOException e) {
                                    throw new CompletionException(e);
                                }
                            }, this.processThreads), CompletableFuture.runAsync(() -> {
                                try (OutputStreamWriter dotProcStream = new OutputStreamWriter(dotProc.getOutputStream(), "UTF-8");){
                                    dotProcStream.write(dot.toString());
                                }
                                catch (IOException e) {
                                    throw new CompletionException(e);
                                }
                            }, this.processThreads), CompletableFuture.runAsync(() -> {
                                response.setContentType("image/svg+xml");
                                byte[] buf = new byte[8192];
                                try (InputStream in = dotProc.getInputStream();
                                     OutputStream out = response.getOutputStream();){
                                    int len;
                                    while ((len = in.read(buf)) >= 0) {
                                        out.write(buf, 0, len);
                                    }
                                }
                                catch (IOException e) {
                                    throw new CompletionException(e);
                                }
                            }, this.processThreads), CompletableFuture.runAsync(() -> {
                                try {
                                    if (dotProc.waitFor() != 0) {
                                        throw new CompletionException(new IllegalStateException(errors.toString()));
                                    }
                                }
                                catch (InterruptedException e) {
                                    throw new CompletionException(e);
                                }
                            }, this.processThreads)).exceptionally(t -> {
                                t.printStackTrace();
                                return null;
                            })).thenRunAsync(response::resume, this.processThreads);
                        }
                        break block69;
                    }
                    response.setContentType("application/json");
                    try (OutputStream responseStream = response.getOutputStream();){
                        JsonProcessor.write(graph, responseStream);
                    }
                    response.resume();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    private static Deque<String> path(Request request) {
        return Pattern.compile("/+").splitAsStream(Optional.ofNullable(request.getPathInfo()).orElse("")).filter(s -> !s.isEmpty()).collect(Collectors.toCollection(ArrayDeque::new));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String detectDotPath() {
        String[] stringArray = new String[]{"which dot", "where dot.exe"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String detectionCommand = stringArray[n2];
            try {
                Process process = Runtime.getRuntime().exec(detectionCommand);
                try (BufferedReader processReader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.defaultCharset()));){
                    CompletableFuture<Optional> path = CompletableFuture.supplyAsync(() -> processReader.lines().map(String::trim).filter(l -> l.toLowerCase().contains("dot")).findFirst());
                    process.waitFor();
                    String dotPath = (String)path.get().get();
                    LOG.info(() -> "Detected GraphViz' dot at '" + dotPath + "'");
                    String string = dotPath;
                    return string;
                }
            }
            catch (Throwable t) {
                LOG.log(Level.FINE, detectionCommand, t);
                ++n2;
            }
        }
        return null;
    }

    private static class StandardOutAccessLogAppender
    implements AccessLogAppender {
        private StandardOutAccessLogAppender() {
        }

        @Override
        public void append(String accessLogEntry) throws IOException {
            System.out.println(accessLogEntry);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

