/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.util;

import eu.interedition.collatex.Token;
import eu.interedition.collatex.VariantGraph;
import eu.interedition.collatex.Witness;
import eu.interedition.collatex.util.VariantGraphRanking;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class ParallelSegmentationApparatus {
    public static void generate(VariantGraphRanking ranking, GeneratorCallback callback) {
        callback.start();
        Set<Witness> allWitnesses = ranking.witnesses();
        for (Map.Entry<Integer, Set<VariantGraph.Vertex>> row : ranking.getByRank().entrySet()) {
            int rank = row.getKey();
            Collection verticesOfRank = row.getValue();
            if (verticesOfRank.size() == 1 && verticesOfRank.stream().findFirst().map(VariantGraph.Vertex::tokens).map(Set::isEmpty).orElse(false).booleanValue()) continue;
            TreeMap<Integer, List> verticesByTranspositionRank = new TreeMap<Integer, List>();
            for (VariantGraph.Vertex v : verticesOfRank) {
                int transpositionRank = 0;
                for (Set<VariantGraph.Vertex> transposition : v.transpositions()) {
                    for (VariantGraph.Vertex tv : transposition) {
                        transpositionRank += ranking.apply(tv) - rank;
                    }
                }
                verticesByTranspositionRank.computeIfAbsent(transpositionRank, r -> new LinkedList()).add(v);
            }
            verticesByTranspositionRank.values().forEach(vertices -> {
                HashMap tokensByWitness = new HashMap();
                for (VariantGraph.Vertex v : vertices) {
                    for (Token token : v.tokens()) {
                        tokensByWitness.computeIfAbsent(token.getWitness(), w -> new LinkedList()).add(token);
                    }
                }
                TreeMap<Witness, Iterable<Token>> cellContents = new TreeMap<Witness, Iterable<Token>>(Witness.SIGIL_COMPARATOR);
                for (Witness witness : allWitnesses) {
                    cellContents.put(witness, Collections.unmodifiableCollection(tokensByWitness.getOrDefault(witness, Collections.emptyList())));
                }
                callback.segment(cellContents);
            });
        }
        callback.end();
    }

    public static interface GeneratorCallback {
        public void start();

        public void segment(SortedMap<Witness, Iterable<Token>> var1);

        public void end();
    }
}

