/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Session;
import org.glassfish.grizzly.http.server.SessionManager;
import org.glassfish.grizzly.utils.DataStructures;

public class DefaultSessionManager
implements SessionManager {
    private final ConcurrentMap<String, Session> sessions = DataStructures.getConcurrentMap();
    private final Random rnd = new Random();
    private final ScheduledThreadPoolExecutor sessionExpirer = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "Grizzly-HttpSession-Expirer");
            t.setDaemon(true);
            return t;
        }
    });

    public static SessionManager instance() {
        return LazyHolder.INSTANCE;
    }

    private DefaultSessionManager() {
        this.sessionExpirer.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                long currentTime = System.currentTimeMillis();
                Iterator iterator = DefaultSessionManager.this.sessions.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Session session = (Session)entry.getValue();
                    if (session.isValid() && (session.getSessionTimeout() == -1L || currentTime - session.getTimestamp() <= session.getSessionTimeout())) continue;
                    session.setValid(false);
                    iterator.remove();
                }
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    @Override
    public Session getSession(Request request, String requestedSessionId) {
        Session session;
        if (requestedSessionId != null && (session = (Session)this.sessions.get(requestedSessionId)) != null && session.isValid()) {
            return session;
        }
        return null;
    }

    @Override
    public Session createSession(Request request) {
        String requestedSessionId;
        Session session = new Session();
        do {
            requestedSessionId = String.valueOf(this.generateRandomLong());
            session.setIdInternal(requestedSessionId);
        } while (this.sessions.putIfAbsent(requestedSessionId, session) != null);
        return session;
    }

    @Override
    public String changeSessionId(Request request, Session session) {
        String oldSessionId = session.getIdInternal();
        String newSessionId = String.valueOf(this.generateRandomLong());
        session.setIdInternal(newSessionId);
        this.sessions.remove(oldSessionId);
        this.sessions.put(newSessionId, session);
        return oldSessionId;
    }

    @Override
    public void configureSessionCookie(Request request, Cookie cookie) {
    }

    private long generateRandomLong() {
        return this.rnd.nextLong() & Long.MAX_VALUE;
    }

    private static class LazyHolder {
        private static final DefaultSessionManager INSTANCE = new DefaultSessionManager();

        private LazyHolder() {
        }
    }
}

