
var SR = (function () {
    "use strict";
    return {
        
    	test: false,
    	subreadings_are: 'lost',
    	
    	hello: function () {
            console.log('subreadings code');
        },
        
        
        
        /**This identifies readings that could have subreadings and separates them from their parent reading in the datastructure.
             * It looks at the decisions added in RG and any standoff markup added in SV
             * the first type get sent of to SR._make_subreading and from there SR._add_to_subreadings
             * the latter type get sent straight to SR._add_to_subreadings
             * This function directly manipulates the data structure CL._JSON.input there is no return value
             * 
             * @method _find_subreadings
             * @param {dict} options (optional) rule_classes:       
             * 					A dictionary of rule classes that are to be extracted 
             * 					(generated by CL._get_rule_classes function)
             * 					if not supplied then subreadings of all rule classes will be extracted
             * 				unit_id: The id of the single unit to manipulate
             * */
        _find_subreadings: function (find_options) {
        	var i, j, k, key, parent, child, apparatus, readings, subreadings, type, for_deletion, options, 
        	marked_reading, rule_classes, app_id, unit, unit_pos, reading_pos;
        	SR.subreadings_are = 'found';
        	if (SR.test) {
        		console.log('SR._find_subreadings')
        	}
        	if (typeof find_options === 'undefined') {
        		find_options = {};
        	}
        	if (find_options.hasOwnProperty('rule_classes')) {
        		rule_classes = find_options.rule_classes;
        	}
        	for (key in CL._data) {
        		if (CL._data.hasOwnProperty(key)) {
        			if (key.indexOf('apparatus') !== -1) {
        				apparatus = CL._data[key];
        				for (i = 0; i < apparatus.length; i += 1) {
        					if (!find_options.hasOwnProperty('unit_id') || apparatus[i]._id === find_options.unit_id) {
        						if (find_options.hasOwnProperty('unit_id')) {
        							//remember app_id so we can just delete the unused marked readings for this unit
        							app_id = key;
        						}
        						readings = apparatus[i].readings;
        						for_deletion = [];
        						//this deals with the words regularised in RG
        						for (j = 0; j < readings.length; j += 1) {				
        							readings[j] = SR._make_subreadings(readings[j], rule_classes);
        						}
        						//this deals with the stand off marked readings (i.e. those created in set variants)
        						for (type in CL._data.marked_readings) {       			       						
        							if (CL._data.marked_readings.hasOwnProperty(type)) {
        								for (j = 0; j < CL._data.marked_readings[type].length; j += 1) {
        									marked_reading = CL._data.marked_readings[type][j];
        									if (marked_reading.apparatus === key) { //if in right apparatus row
        										if (marked_reading.start ===  apparatus[i].start 
        												&& marked_reading.end ===  apparatus[i].end) { //if unit extent is correct	
        											//get the parent 
        											parent = SR._find_parent_reading(apparatus[i], key, marked_reading, true);
        											if (SR.test) {
        												console.log('parent is...')
        												console.log(parent)
        											}
        											if (parent !== null) {
        												if (parent.hasOwnProperty('subreadings')) {
        													subreadings = parent.subreadings;
        												} else {
        													subreadings = {};
        												}
        												//then find the child reading
        												child = SR._find_child_reading(apparatus[i], marked_reading, SR.test);
        												if (SR.test ) {
        													console.log('child is...')
        													console.log(child)
        												}							
        												if (child !== null) {
        													marked_reading.applied = true;
        													SR._add_combined_gap_data_to_parent(parent, marked_reading);
        													//sort out the options
        													options = {'standoff': true};
        													if (typeof rule_classes !== 'undefined') {
        														options.rules = rule_classes;
        													}
        													if (typeof marked_reading.reading_text !== 'undefined') {
        														options.text = marked_reading.reading_text;
        														options.text = SR._get_correct_standoff_reading_text(marked_reading, rule_classes);        														
        													}
        													if (typeof marked_reading.combined_gap_before !== 'undefined') {
        														options.combined_gap_before = marked_reading.combined_gap_before;
        													}
        													if (typeof marked_reading.combined_gap_after !== 'undefined') {
        														options.combined_gap_after = marked_reading.combined_gap_after;
        													}
        													if (typeof marked_reading.combined_gap_before_details !== 'undefined') {
        														options.combined_gap_before_details = marked_reading.combined_gap_before_details;
        													}	
        													if (SR.test) {
        														console.log(options)
        														console.log(JSON.parse(JSON.stringify(subreadings)))
        													}
        													//then make the subreading for that witness (you might have to split a reading)
        													subreadings = SR._add_to_subreadings(subreadings, child, marked_reading.witness, marked_reading.value.split('|'), options);
        													if (SR.witness_in(subreadings, marked_reading.witness)) {
        														parent['subreadings'] = subreadings;
        														for_deletion.push([marked_reading.witness, child]);
        													}
        													//for each reading we need to record the witnesses that were made subreading by standoff readings rather than regularised readings
        													//This is so we can put all standoff subreadings in SR_text when we lose them (makes extracting text easier) 
        													if (!parent.hasOwnProperty('standoff_subreadings')) {
        														parent.standoff_subreadings = [];
        													}
        													if (parent.standoff_subreadings.indexOf(marked_reading.witness) === -1) {
        														parent.standoff_subreadings.push(marked_reading.witness);
        													}
        												}
        											}
        										}
        									}
        								}
        							}
        						}
        						SR._remove_from_main_reading(for_deletion);

        						for (j = 0; j < apparatus[i].readings.length; j += 1) {                     	
        							if (apparatus[i].readings[j].witnesses.length === 0 && !apparatus[i].readings[j].hasOwnProperty('subreadings')) {
        								apparatus[i].readings[j] = null;
        							}
        						}
        						CL.remove_null_items(apparatus[i].readings);
        					}
        				}
        			}
        		}
        	}
        	if (find_options.hasOwnProperty('unit_id')) {
        		SR.clean_standoff_marking(app_id, find_options.unit_id); //then limit 'cleaning' to this unit
        	} else {
        		SR.clean_standoff_marking(); //clean the lot
        	}
        	if (CL._data.hasOwnProperty('separated_witnesses')) {
        		for (i = 0; i < CL._data.separated_witnesses.length; i += 1) {
        			unit = CL.find_unit_by_id(CL._data.separated_witnesses[i].app_id, CL._data.separated_witnesses[i].unit_id);
        			unit_pos = CL.find_unit_pos_by_id(CL._data.separated_witnesses[i].app_id, CL._data.separated_witnesses[i].unit_id);
        			for (j = 0; j < unit.readings.length; j += 1) {
        				if (unit.readings[j].witnesses.indexOf(CL._data.separated_witnesses[i].witnesses[0]) !== -1) {
        					reading_pos = j;
        				} else if (unit.readings[j].hasOwnProperty('subreadings')) {
        					for (key in unit.readings[j].subreadings) {
        						for (k = 0; k < unit.readings[j].subreadings[key].length; k += 1) {
        							if (unit.readings[j].subreadings[key][k].witnesses.indexOf(CL._data.separated_witnesses[i].witnesses[0]) !== -1) {
        								reading_pos = j;
        							}
        						}
        					}
        				}
        			}
        			SV.do_split_reading_witnesses(unit_pos, reading_pos, CL._data.separated_witnesses[i].witnesses, undefined, undefined, CL._data.separated_witnesses[i].reading_id);
        		}
        	}
        },
        
        _get_correct_standoff_reading_text: function (marked_reading, rule_classes) {
        	var key, rule_list, i, values, found_reading;
        	if (typeof rule_classes === 'undefined') {
        		return marked_reading.reading_text;
        	}
        	rule_list = [];
        	for (key in rule_classes) {
        		if (rule_classes.hasOwnProperty(key)) {
        			rule_list.push(key);
        		}
        	}
        	values = marked_reading.value.split('|');
        	for (i = values.length-1; i >=0; i-=1) {
        		if (rule_list.indexOf(values[i]) !== -1 && marked_reading.hasOwnProperty('reading_history')) {
        			found_reading = marked_reading.reading_history[i];
        		}
        	}
        	if (typeof found_reading !== 'undefined') {
        		return found_reading;
        	} else {
        		return marked_reading.reading_text;
        	}      	
        },
    	
        _add_combined_gap_data_to_parent: function (parent, standoff_data) {
        	//put subreadings combined gap data in now
        	if (standoff_data.hasOwnProperty('combined_gap_after')) {
        		if (parent.text.length > 0) {
        			parent.text[parent.text.length-1].combined_gap_after = [];
        		}
        		if (parent.hasOwnProperty('combined_gap_after_subreadings')) {
        			if (parent.combined_gap_after_subreadings.indexOf(standoff_data.witness) === -1) {
        				parent.combined_gap_after_subreadings.push(standoff_data.witness);
        			}
        		} else {
        			parent.combined_gap_after_subreadings = [standoff_data.witness];
        		}
        	}
        	if (standoff_data.hasOwnProperty('combined_gap_before')) {
        		if (parent.text.length > 0) {
        			parent.text[0].combined_gap_before = [];
        		}
        		if (parent.hasOwnProperty('combined_gap_before_subreadings')) {
        			if (parent.combined_gap_before_subreadings.indexOf(standoff_data.witness) === -1) {
        				parent.combined_gap_before_subreadings.push(standoff_data.witness);
        			}
        		} else {
        			parent.combined_gap_before_subreadings = [standoff_data.witness];
        		}
        		if (!parent.hasOwnProperty('combined_gap_before_subreadings_details')) {
        			parent.combined_gap_before_subreadings_details = {};	   
        		}
        		//even if we have it already overwrite because should be the same data
        		parent.combined_gap_before_subreadings_details[standoff_data.witness] = standoff_data.combined_gap_before_details;
        	}
        },

    	
        /** This deletes any entries from the standoff marked_readings that were not applied in the last pass
         * and deletes the applied key from all standoff marked_readings so that is clean for the next pass
         * (entries cease to apply when units change length or readings move etc.) 
         * This is also sensitive to find_subreadings being called on a single unit in which case only
         * unused marked readings belonging to that unit should be deleted
         * */
        clean_standoff_marking: function (app_id, unit_id) {
        	var key, i, unit;
        	if (typeof app_id !== 'undefined' && typeof unit_id !== 'undefined') {
        		unit = CL.find_unit_by_id(app_id, unit_id);
        	}
        	for (key in CL._data.marked_readings) {
        		if (CL._data.marked_readings.hasOwnProperty(key)) {
        			for (i = 0; i < CL._data.marked_readings[key].length; i += 1) {
        				if (typeof unit === 'undefined' || (CL._data.marked_readings[key][i].start === unit.start 
        						&& CL._data.marked_readings[key][i].end === unit.end
        						&& CL._data.marked_readings[key][i].apparatus === app_id)) {
        					if (CL._data.marked_readings[key][i].hasOwnProperty('applied')) {
        						delete CL._data.marked_readings[key][i].applied;
        					} else {
        						CL._data.marked_readings[key][i] = null;
        					}
        				}
        			}
        			CL.remove_null_items(CL._data.marked_readings[key]);
        			if (CL._data.marked_readings[key].length === 0) {
        				delete CL._data.marked_readings[key];
        			}
        		}
        	}
        },
    	
        
        //TODO: what does this do and why is last line of code commented out?
        /**removes supplied data from the main reading */
        _remove_from_main_reading: function (list) {
        	var i, j, token, reading, witness, index, witnesses;
        	for (i = 0; i < list.length; i += 1) {
        		witness = list[i][0];
        		reading = list[i][1];
        		if (reading.witnesses.indexOf(witness) !== -1) {
        			witnesses = reading.witnesses.slice();
        			witnesses.splice(witnesses.indexOf(witness), 1);
        			reading.witnesses = witnesses;
        		}
        		for (j = 0; j < reading.text.length; j += 1) {
        			token = reading.text[j];
        			index = token.reading.indexOf(witness);
        			if (index !== -1) {
        				token.reading.splice(index, 1);
        			}                    
        			delete token[witness];
        		}
        		if (reading.hasOwnProperty('subreadings')) {
        			// SV._remove_from_subreaading(reading, witness);
        		}
        	}
        },
    	
        _find_child_reading: function (unit, standoff_reading) {
        	var i, j, key;
        	if (SR.test) {
        		console.log('this one')
        		console.log(JSON.parse(JSON.stringify(unit)))
        	}
        	for (i = 0; i < unit.readings.length; i += 1) { 
        		if (SR.test) {
        			console.log(i)
        			console.log(JSON.parse(JSON.stringify(unit.readings[i])))
        		}
        		if (unit.readings[i].witnesses.indexOf(standoff_reading.witness) !== -1) { //if our target witness is in this reading
        			if (SR.test) {
        				console.log('here')
        				console.log(CL.extract_witness_text(unit.readings[i], {'witness': standoff_reading.witness, 'reading_type': 'subreading'}));
        				console.log(standoff_reading.reading_text);
        			}
        			if (standoff_reading.reading_text === CL.extract_witness_text(unit.readings[i], {'witness': standoff_reading.witness, 'reading_type': 'subreading'})) {
        				return unit.readings[i];
        			}
        		} else if (unit.readings[i].hasOwnProperty('subreadings')) {
        			for (key in unit.readings[i].subreadings) {
        				if (unit.readings[i].subreadings.hasOwnProperty(key)) {
        					for (j = 0; j < unit.readings[i].subreadings[key].length; j += 1) {
        						if (unit.readings[i].subreadings[key][j].witnesses.indexOf(standoff_reading.witness) !== -1) {
        							if (standoff_reading.reading_text === CL.extract_witness_text(unit.readings[i], {'witness': standoff_reading.witness, 'reading_type': 'subreading'})) {
        								return unit.readings[i];
        							}
        						}
        					}
        				}
        			}
        		}
        	}
        	return null;
        },
        

        is_separated_reading: function (app_id, unit_id, witness) {
        	var i;
        	if (!CL._data.hasOwnProperty('separated_witnesses')) {
        		return [false];
        	}
        	for (i = 0; i < CL._data.separated_witnesses.length; i += 1) {
        		if (app_id === CL._data.separated_witnesses[i].app_id && unit_id === CL._data.separated_witnesses[i].unit_id) {
        			if (CL._data.separated_witnesses[i].witnesses.indexOf(witness) !== -1) {
            			return [true, JSON.parse(JSON.stringify(CL._data.separated_witnesses[i].witnesses))];
            		}
        		}
        	}       	
        	return [false];
        },
        

	
        /** we want this to find genuine readings so never give extract_witness_text the unit id otherwise it will find non-existent readings */
        _find_parent_reading: function (unit, app_id, standoff_reading, create_parent) {
        	var i, j, readings, separated_witnesses, temp;
        	readings = [];
        	if (SR.test) {
        		console.log('looking for a match to this')
        		console.log(standoff_reading.parent_text)
        		console.log('in')
        	}

        	for (i = 0; i < unit.readings.length; i += 1) {
        		if (SR.test) {
        			console.log(CL.extract_witness_text(unit.readings[i], undefined, SR.test))
        		}
        		if (CL.extract_witness_text(unit.readings[i]) === standoff_reading.parent_text) {
        			readings.push(unit.readings[i]);
        		}    
        	}
        	if (SR.test) {
        		console.log(readings)
        	}    
        	if (readings.length === 1) {
        		return readings[0];
        	} 
        	if (readings.length > 0) {
        		temp = SR.is_separated_reading(app_id, unit._id, standoff_reading.witness);
        		if (temp[0]) {
        			temp[1].splice(temp[1].indexOf(standoff_reading.witness, 1))
        			for (i = 0; i < readings.length; i += 1) {
        				separated_witnesses = CL.get_all_reading_witnesses(readings[i]);
        				if (temp[1].length > 0 && separated_witnesses.indexOf(temp[1][0]) !== -1) {
        					return readings[i];
        				}
        			}
        		}
        		return readings[0]; //else always chose the first we found because it should always be the main reading for that set (any split offs will be put after the main one)
        	}
        	if (create_parent === true) {
        		if (SR.test) {
        			console.log('creating new parent')
        		}
        		if (standoff_reading.hasOwnProperty('om_details')) {
        			SV.create_new_reading(unit, 'gap', standoff_reading.om_details);
        		} else if (standoff_reading.parent_text === 'om.') {
        			SV.create_new_reading(unit, 'om');
        		} else {
        			SV.create_new_reading(unit, 'other', standoff_reading.parent_text);
        		}
        		for (i = 0; i < unit.readings.length; i += 1) {
        			if (CL.extract_witness_text(unit.readings[i]) === standoff_reading.parent_text) {
        				return unit.readings[i];
        			}    
        		}       
        	}
        	return null;
        },
	
        witness_in: function (subreadings, witness) {
        	var key, i;
        	for (key in subreadings) {
        		if (subreadings.hasOwnProperty(key)) {
        			for (i = 0; i < subreadings[key].length; i += 1) {
        				if (subreadings[key][i].witnesses.indexOf(witness) !== -1) {
        					return true;
        				}
        			}
        		}
        	}
        	return false;
        },
    	
        /** for each witness finds all decision classes that apply to the reading and passes it all 
         * on to SR._add_to_subreadings */
        _make_subreadings: function (reading, rule_classes) {
        	var i, j, k, token, witness, subreadings, decision_class, for_deletion, ident_list, combined_gap_before, combined_gap_after, options;
        	if (typeof rule_classes === 'undefined') {
        		rule_classes = CL._get_rule_classes(undefined, undefined, 'value', ['identifier', 'subreading']);
        	}
        	subreadings = {};
        	for_deletion = [];
        	for (i = 0; i < reading.witnesses.length; i += 1) {     	
        		combined_gap_before = undefined;
        		combined_gap_after = undefined;
        		witness = reading.witnesses[i];
        		ident_list = [];
        		for (j = 0; j < reading.text.length; j += 1) {
        			token = reading.text[j];
        			if (token.hasOwnProperty(witness)) {
        				if (token[witness].hasOwnProperty('decision_class')) {
        					decision_class = token[witness].decision_class;
        					for (k = 0; k < decision_class.length; k += 1) {
        						if (ident_list.indexOf(decision_class[k]) === -1 
        								&& rule_classes.hasOwnProperty(decision_class[k])) {
        							ident_list.push(decision_class[k]);
        						}
        					}
        				}
        			}
        		}
        		if (reading.hasOwnProperty('combined_gap_before_subreadings') && reading.combined_gap_before_subreadings.indexOf(witness) !== -1) {
        			combined_gap_before = [];
        		}
        		if (reading.hasOwnProperty('combined_gap_after_subreadings') && reading.combined_gap_after_subreadings.indexOf(witness) !== -1) {
        			combined_gap_after = [];
        		}
        		if (ident_list.length > 0) {
        			ident_list.sort();
        			options = {};
        			if (typeof rule_classes !== 'undefined') {
        				options.rules = rule_classes;
        			}
        			if (typeof combined_gap_before !== 'undefined') {
        				options.combined_gap_before = combined_gap_before;
        			}
        			if (typeof combined_gap_after !== 'undefined') {
        				options.combined_gap_after = combined_gap_after;
        			}
        			if (SR.test) {
        				console.log(JSON.parse(JSON.stringify(ident_list)));
        				console.log(JSON.parse(JSON.stringify(subreadings)));
        				console.log(JSON.parse(JSON.stringify(reading)));
        			}
        			subreadings = SR._add_to_subreadings(subreadings, reading, witness, ident_list, options);
        			if (!$.isEmptyObject(subreadings)) {
        				reading.subreadings = subreadings;
        				for_deletion.push([witness, reading]);
        			}
        		}
        	}
        	SR._remove_from_main_reading(for_deletion);
        	return reading;
        },
        
        
        
        /** 
         * adds a new subreading to the subreading dictionary supplied
         * 
         * @param {Object} subreadings - the current dictionary of subreadings (or an empty object if this parent doesn't have any)
         * @param {Object} reading - the reading which needs to be made into a subreading
         * @param {String} witness - the witness that is becoming the subreading
         * @param {Array} type_list - a list of abbreviation type labels to be applied to the new subreading 
         * @param {Object} options - other optional data provided which are: 	rules - a list of the regularisation rules that are relevant for creating the subreadings
         * 									text - the text of the subreading being created
         * 									combined_gap_before - boolean 
         * 									combined_gap_after - boolean
         * 									combined_gap_before_details - string
         * 									standoff - boolean
         * 
         * */
        _add_to_subreadings: function (subreadings, reading, witness, type_list, options) {    
        	var i, j, match_found, text_string, type, real_suffix_list, fake_suffix_list, suffix_string,
        	key, subreading, target;
        	if (typeof options === 'undefined') {
        		options = {};
        	}
        	if (typeof options.rules === 'undefined') {
        		options.rules = CL._get_rule_classes(undefined, undefined, 'value', ['identifier', 'subreading']);
        	}
        	//target is the reading at the object level where two of the keys are witnesses and text
        	target = CL.get_subreading_of_witness(reading, witness, true);
//        	if (reading.hasOwnProperty('SR_text') && reading.SR_text.hasOwnProperty(witness)) {
//        		target = reading.SR_text[witness];       
//        	} else if (reading.hasOwnProperty('subreadings')) {
//        		target = SR._find_target_subreading
//        	} 
        	if (target === null) {
        		target = reading;
        	}
        	if (options.combined_gap_before) {
        		target.text[0].combined_gap_before = [];
        	}
        	if (options.combined_gap_before_details) {
        		target.text[0].combined_gap_before_details = options.combined_gap_before_details;
        	}
        	if (options.combined_gap_after) {
        		target.text[target.text.length-1].combined_gap_after = [];
        	}
        	//make the suffix
        	//the suffix is split into real and fake, real being those that will end up as subreadings in the apparatus and fake being all other subreadings
        	real_suffix_list = [];
        	fake_suffix_list = [];
        	for (i = 0; i < type_list.length; i += 1) {
        		if (!options.rules.hasOwnProperty(type_list[i])) {
        			type_list[i] = null;
        			continue;
        		}
        		if (typeof options.rules[type_list[i]][0] === 'undefined') {
        			suffix_string = '-';
        		} else {
        			suffix_string = options.rules[type_list[i]][0];
        		}
        		if (options.rules[type_list[i]][1]) {
        			if (suffix_string !== '-' || (suffix_string === '-' && real_suffix_list.indexOf('-') === -1)) {
        				real_suffix_list.push(suffix_string);
        			}
        		} else {
        			if (suffix_string !== '-' || (suffix_string === '-' && fake_suffix_list.indexOf('-') === -1)) {
        				fake_suffix_list.push(suffix_string);
        			}
        		}
        	}
        	CL.remove_null_items(type_list);
        	real_suffix_list.sort();
        	fake_suffix_list.sort();
        	//add parenthesis to the fake suffixes
        	if (fake_suffix_list.length > 0) {
        		fake_suffix_list.splice(0, 0, '(');
        		fake_suffix_list.push(')');
        		real_suffix_list.push.apply(real_suffix_list, fake_suffix_list);
        	}
        	type = type_list.join('|');
        	//extract the witness text and check we only have one instance of each text
        	if (type.length > 0) {
        		if (subreadings.hasOwnProperty(type)) {
        			if (typeof options.text !== 'undefined') {
        				text_string = options.text;
        			} else {
        				text_string = CL.extract_witness_text(target, {'witness': witness, 'reading_type': 'subreading', 'required_rules': type_list});
        			}
        			if (text_string === '') {
        				if (target.hasOwnProperty('type') && target.type === 'om') {
        					text_string = 'om.';
        				} else if (target.hasOwnProperty('type') && target.type === 'lac') {
        					if (target.hasOwnProperty('details')) {
        						text_string = target.details;
        					}       	    
        				}
        			}
        			
        			match_found = false;
        			for (i = 0; i < subreadings[type].length; i += 1) {
        				if (subreadings[type][i].text_string === text_string || '&lt;' + subreadings[type][i].text_string + '&gt;' === text_string) {
        					if (subreadings[type][i].witnesses.indexOf(witness) === -1) {
        						subreadings[type][i].witnesses.push(witness);
        						for (j = 0; j < subreadings[type][i].text.length; j += 1) {
        							subreadings[type][i].text[j].reading.push(witness);
        							subreadings[type][i].text[j][witness] = target.text[j][witness];
        							if (options.hasOwnProperty('standoff') && options.standoff === true) {
        								subreadings[type][i].text[j][witness]['interface'] = target.text[j]['interface'];
        							}
        						}                           
        					}
        					match_found = true;
        					break;
        				}
        			}
        			if (match_found === false) {
        				subreadings = SR._add_new_subreading(subreadings, target, witness, type, real_suffix_list.join(''), options.text, type_list);
        			}
        		} else {
        			subreadings[type] = [];
        			subreadings = SR._add_new_subreading(subreadings, target, witness, type, real_suffix_list.join(''), options.text, type_list);
        		}
        	}
        	return subreadings;
        },   
        
        _add_new_subreading: function (subreadings, reading, witness, type, suffix, text, required_rules) {
        	var new_entry, i, new_tok, text_string;
        	if (reading.text.length > 0) {
        		if (typeof text !== 'undefined') {
        			text_string = text;
        		} else {
        			text_string = CL.extract_witness_text(reading, {'witness': witness, 'reading_type': 'subreading', 'required_rules': required_rules});
        		}
        		if (SR.test) {
    				console.log(text_string);
    			}
        	} else {
        		if (reading.hasOwnProperty('details')) {
        			text_string = reading.details;
        		} else {
        			text_string = 'om.';
        		}
        	}
        	new_entry = {'text' : [],
        			'text_string' : text_string,
        			'witnesses' : [witness],
        			'suffix' : suffix};
        	if (reading.hasOwnProperty('type')){
        		new_entry.type = reading.type;
        	}
        	if (reading.hasOwnProperty('details')){
        		new_entry.details = reading.details;
        	}
        	for (i = 0; i < reading.text.length; i += 1) {
        		new_tok = {};
        		new_tok.index = reading.text[i].index;
        		new_tok.verse = reading.text[i].verse;
        		new_tok[witness] = reading.text[i][witness];
        		//If this token has a decision applied then get the n (as we are after the subreading)
        		if (reading.text[i].hasOwnProperty('decision_details')) {
        			new_tok['interface'] = reading.text[i].decision_details[0].t; //TODO: is the 0 right? what happens with chaining!!! also check extract_witness_text and other places with this structure
        		} else {
        			new_tok['interface'] = reading.text[i]['interface'];
        		}
        		new_tok.reading = [witness];
        		if (reading.text[i].hasOwnProperty('was_gap')) {
        			new_tok.was_gap = reading.text[i].was_gap;
        		}
        		new_entry.text.push(new_tok);
        	}
        	subreadings[type].push(new_entry);
        	return subreadings;
        },
            
        /**This merges the subreadings back in with their parent readings */
        _lose_subreadings: function () {
        	var data, i, apparatus, readings, j,reading, key;
        	SR.subreadings_are = 'lost';
        	data = CL._data;
        	for (key in data) {
        		if (data.hasOwnProperty(key)) {
        			if (key.indexOf('apparatus') !== -1) { //loop through lines of apparatus
        				apparatus = data[key];
        				for (i = 0; i < apparatus.length; i += 1) { //loop through units in apparatus
        					readings = apparatus[i].readings;
        					for (j = 0; j < readings.length; j += 1) { //loop through readings in unit
        						reading = readings[j];
        						if (reading.hasOwnProperty('subreadings')) { //if there are subreadings
        							SR._do_lose_subreadings(reading);
        						}
        					}
        				}
        			}
        		}
        	}
//      	console.log('RESULT OF LOSE SUBREADINGS BELOW')
//      	console.log(JSON.parse(JSON.stringify(CL._data)))
        },
        
        _do_lose_subreadings: function (reading) {
        	var type, witness, parent_length, token, i, j, k, text;        
        	parent_length = reading.text.length;
        	for (type in reading.subreadings) { //loop through subreading types
        		if (reading.subreadings.hasOwnProperty(type)) {
        			for (i = 0; i < reading.subreadings[type].length; i += 1) { //loop through all the subreading of that type
        				for (j = 0; j < reading.subreadings[type][i].witnesses.length; j += 1) {
        					witness = reading.subreadings[type][i].witnesses[j];
        					reading.witnesses.push(witness);
        					
        					if (reading.subreadings[type][i].text.length == parent_length //we shouldn't need this first condition                		
        							&& ((!reading.hasOwnProperty('standoff_subreadings') || reading.standoff_subreadings.indexOf(witness) === -1))) {
        						for (k = 0; k < reading.subreadings[type][i].text.length; k += 1) {
        							token = reading.subreadings[type][i].text[k];
        							reading.text[k].reading.push(token.reading[token.reading.indexOf(witness)]);
        							reading.text[k][witness] = reading.subreadings[type][i].text[k][witness];
        						}
        					} else { //this is a standoff reading so SR_text must be employed   
        						if (!reading.hasOwnProperty('SR_text')) {
        							reading.SR_text = {};
        						}              		
        						//remove the extra readings from each word, siglum and reading                	
        						text = CL.strip_extra_witness_details_from_text_list(JSON.parse(JSON.stringify(reading.subreadings[type][i].text)), witness);
        						reading.SR_text[witness] = {'text': text};
        						for (k = 0; k < reading.SR_text[witness].text.length; k += 1) {
        							if (reading.SR_text[witness].text[k][witness].hasOwnProperty('decision_details')) {
        								reading.SR_text[witness].text[k]['interface'] = reading.SR_text[witness].text[k][witness].decision_details[0].t;
        							} else {
        								//else its okay already - this is pointless! its here until I know its all settled down then it can go
        								//reading.SR_text[witness].text[k]['interface'] = reading.SR_text[witness].text[k]['interface'];
        								//I think the above might be wrong and am SR.testing this with ref to bug report #11
        								if (reading.SR_text[witness].text[k].hasOwnProperty('t')) {
        									reading.SR_text[witness].text[k]['interface'] = reading.SR_text[witness].text[k].t;
        								} else {
        									if (reading.SR_text[witness].text[k][witness]['interface'] === undefined) {
        										reading.SR_text[witness].text[k]['interface'] = reading.SR_text[witness].text[k]['interface'];
        										reading.SR_text[witness].text[k][witness]['interface'] = reading.SR_text[witness].text[k]['interface'];
        									} else {
        										reading.SR_text[witness].text[k]['interface'] = reading.SR_text[witness].text[k][witness]['interface'];
        									}   	    
        								}
        							}
        						}
        						if (reading.subreadings[type][i].hasOwnProperty('type')) {
        							reading.SR_text[witness].type = reading.subreadings[type][i].type;
        						}
        						if (reading.subreadings[type][i].hasOwnProperty('details')) {
        							reading.SR_text[witness].details = reading.subreadings[type][i].details;
        						}
        						if (reading.hasOwnProperty('standoff_subreadings')) {
        							reading.standoff_subreadings.splice(reading.standoff_subreadings.indexOf(witness), 1);
        							if (reading.standoff_subreadings.length === 0) {
        								delete reading.standoff_subreadings;
        							}
        						}
        					}
        				}
        			}
        		}
        	}
        	reading.witnesses = CL.set_list(reading.witnesses);
        	delete reading.subreadings;
        },
        
    };
}());