/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class ClosableByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;
    protected boolean closed;
    protected boolean freed;

    public ClosableByteArrayOutputStream() {
        this(32);
    }

    public ClosableByteArrayOutputStream(int size) throws IllegalArgumentException {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new byte[size];
    }

    public synchronized void write(int b) throws IOException {
        this.checkClosed();
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.buf = this.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.buf = this.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public void flush() throws IOException {
        this.checkClosed();
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        this.checkFreed();
        out.write(this.buf, 0, this.count);
    }

    public synchronized int capacity() throws IOException {
        this.checkFreed();
        return this.buf.length;
    }

    public synchronized void reset() throws IOException {
        this.checkClosed();
        this.count = 0;
    }

    public synchronized void trimToSize() throws IOException {
        this.checkFreed();
        if (this.buf.length > this.count) {
            this.buf = this.copyOf(this.buf, this.count);
        }
    }

    public synchronized byte[] toByteArray() throws IOException {
        this.checkFreed();
        return this.copyOf(this.buf, this.count);
    }

    public synchronized int size() throws IOException {
        return this.count;
    }

    public synchronized void setSize(int newSize) {
        if (newSize < 0) {
            throw new ArrayIndexOutOfBoundsException(newSize);
        }
        if (newSize > this.buf.length) {
            this.buf = this.copyOf(this.buf, Math.max(this.buf.length << 1, newSize));
        }
        this.count = newSize;
    }

    public synchronized ByteArrayInputStream toByteArrayInputStream() throws IOException {
        this.checkFreed();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.buf, 0, this.count);
        this.free();
        return inputStream;
    }

    public synchronized String toString() {
        try {
            this.checkFreed();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.toString());
        }
        return new String(this.buf, 0, this.count);
    }

    public synchronized String toString(String enc) throws IOException, UnsupportedEncodingException {
        this.checkFreed();
        return new String(this.buf, 0, this.count, enc);
    }

    public synchronized void close() throws IOException {
        this.closed = true;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized void free() throws IOException {
        this.closed = true;
        this.freed = true;
        this.buf = null;
        this.count = 0;
    }

    public synchronized boolean isFreed() {
        return this.freed;
    }

    protected synchronized void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed.");
        }
    }

    protected synchronized void checkFreed() throws IOException {
        if (this.freed) {
            throw new IOException("stream buffer is freed.");
        }
    }

    protected byte[] copyOf(byte[] original, int newLength) {
        byte[] copy = new byte[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }
}

