/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.Set;

public class OrderedHashSet
extends HashSet
implements HsqlList,
Set {
    public OrderedHashSet() {
        super(8);
        this.isList = true;
    }

    public boolean remove(Object key) {
        int oldSize = this.size();
        super.removeObject(key, true);
        return oldSize != this.size();
    }

    public Object remove(int index) throws IndexOutOfBoundsException {
        this.checkRange(index);
        Object result = this.objectKeyTable[index];
        this.remove(result);
        return result;
    }

    public boolean insert(int index, Object key) throws IndexOutOfBoundsException {
        int i;
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.contains(key)) {
            return false;
        }
        if (index == this.size()) {
            return this.add(key);
        }
        Object[] set = this.toArray(new Object[this.size()]);
        super.clear();
        for (i = 0; i < index; ++i) {
            this.add(set[i]);
        }
        this.add(key);
        for (i = index; i < set.length; ++i) {
            this.add(set[i]);
        }
        return true;
    }

    public Object set(int index, Object key) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException();
    }

    public void add(int index, Object key) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException();
    }

    public Object get(int index) throws IndexOutOfBoundsException {
        this.checkRange(index);
        return this.objectKeyTable[index];
    }

    public int getIndex(Object key) {
        return this.getLookup(key, key.hashCode());
    }

    public int getLargestIndex(OrderedHashSet other) {
        int max = -1;
        int size = other.size();
        for (int i = 0; i < size; ++i) {
            int index = this.getIndex(other.get(i));
            if (index <= max) continue;
            max = index;
        }
        return max;
    }

    public int getCommonElementCount(Set other) {
        int count = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!other.contains(this.objectKeyTable[i])) continue;
            ++count;
        }
        return count;
    }

    public static OrderedHashSet addAll(OrderedHashSet first, OrderedHashSet second) {
        if (second == null) {
            return first;
        }
        if (first == null) {
            first = new OrderedHashSet();
        }
        first.addAll(second);
        return first;
    }

    public static OrderedHashSet add(OrderedHashSet first, Object value) {
        if (value == null) {
            return first;
        }
        if (first == null) {
            first = new OrderedHashSet();
        }
        first.add(value);
        return first;
    }

    private void checkRange(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

