/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileArchiver;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.Cache;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileBlockManager;
import org.hsqldb.persist.DataFileDefrag;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RAShadowFile;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.persist.ScaledRAFileSimple;
import org.hsqldb.rowio.RowInputBinary180;
import org.hsqldb.rowio.RowInputBinaryDecode;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputBinary180;
import org.hsqldb.rowio.RowOutputBinaryEncode;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.store.BitMap;

public class DataFileCache {
    protected FileAccess fa;
    public static final int FLAG_ISSHADOWED = 1;
    public static final int FLAG_ISSAVED = 2;
    public static final int FLAG_ROWINFO = 3;
    public static final int FLAG_190 = 4;
    public static final int FLAG_HX = 5;
    static final int LONG_EMPTY_SIZE = 4;
    static final int LONG_FREE_POS_POS = 12;
    static final int LONG_EMPTY_INDEX_POS = 20;
    static final int FLAGS_POS = 28;
    static final int MIN_INITIAL_FREE_POS = 32;
    DataFileBlockManager freeBlocks;
    private static final int initIOBufferSize = 256;
    protected String dataFileName;
    protected String backupFileName;
    protected Database database;
    protected boolean fileModified;
    protected int cacheFileScale;
    protected boolean cacheReadonly;
    protected int cachedRowPadding = 8;
    protected int initialFreePos = 32;
    protected boolean hasRowInfo = false;
    protected int storeCount;
    protected RowInputInterface rowIn;
    public RowOutputInterface rowOut;
    public long maxDataFileSize;
    boolean is180;
    protected RandomAccessInterface dataFile;
    protected volatile long fileFreePosition;
    protected int maxCacheRows;
    protected long maxCacheBytes;
    protected int maxFreeBlocks;
    protected Cache cache;
    private RAShadowFile shadowFile;
    ReadWriteLock lock = new ReentrantReadWriteLock();
    Lock readLock = this.lock.readLock();
    Lock writeLock = this.lock.writeLock();

    public DataFileCache(Database db, String baseFileName) {
        this.initParams(db, baseFileName);
        this.cache = new Cache(this);
    }

    protected void initParams(Database database, String baseFileName) {
        this.dataFileName = baseFileName + ".data";
        this.backupFileName = baseFileName + ".backup";
        this.database = database;
        this.fa = database.logger.getFileAccess();
        this.cacheFileScale = database.logger.getCacheFileScale();
        this.cachedRowPadding = 8;
        if (this.cacheFileScale > 8) {
            this.cachedRowPadding = this.cacheFileScale;
        }
        if (this.initialFreePos < this.cacheFileScale) {
            this.initialFreePos = this.cacheFileScale;
        }
        this.cacheReadonly = database.logger.propFilesReadOnly;
        this.maxCacheRows = database.logger.propCacheMaxRows;
        this.maxCacheBytes = database.logger.propCacheMaxSize;
        this.maxDataFileSize = Integer.MAX_VALUE * (long)this.cacheFileScale;
        this.maxFreeBlocks = database.logger.propMaxFreeBlocks;
        this.dataFile = null;
        this.shadowFile = null;
    }

    public void open(boolean readonly) {
        this.fileFreePosition = 0L;
        this.database.logger.logInfoEvent("open start");
        try {
            boolean isNio = this.database.logger.propNioDataFile;
            int fileType = this.database.logger.isStoredFileAccess() ? 3 : (this.database.isFilesInJar() ? 2 : (isNio ? 1 : 0));
            if (readonly || this.database.isFilesInJar()) {
                this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, readonly, fileType);
                this.initBuffers();
                return;
            }
            long freesize = 0L;
            boolean preexists = this.fa.isStreamElement(this.dataFileName);
            if (preexists) {
                int fileTypeTemp = this.database.logger.isStoredFileAccess() ? 3 : 0;
                this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, readonly, fileTypeTemp);
                this.dataFile.seek(28L);
                int flags = this.dataFile.readInt();
                boolean isSaved = BitMap.isSet(flags, 2);
                boolean isIncremental = BitMap.isSet(flags, 1);
                this.is180 = !BitMap.isSet(flags, 4);
                this.dataFile.close();
                if (BitMap.isSet(flags, 5)) {
                    throw Error.error(453);
                }
                if (isSaved) {
                    if (isIncremental) {
                        this.deleteBackup();
                    } else {
                        boolean existsBackup = this.fa.isStreamElement(this.backupFileName);
                        if (!existsBackup) {
                            this.backupFile();
                        }
                    }
                    this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, readonly, fileType);
                } else {
                    boolean restored = isIncremental ? this.restoreBackupIncremental() : this.restoreBackup();
                    if (!restored) {
                        throw Error.error(454);
                    }
                    this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, readonly, fileType);
                }
                this.dataFile.seek(4L);
                freesize = this.dataFile.readLong();
                this.dataFile.seek(12L);
                this.fileFreePosition = this.dataFile.readLong();
                if (this.fileFreePosition < (long)this.initialFreePos) {
                    this.initNewFile();
                }
                this.openShadowFile();
            } else {
                boolean restored = false;
                boolean isIncremental = this.database.logger.propIncrementBackup;
                if (isIncremental) {
                    this.deleteBackup();
                } else {
                    restored = this.restoreBackup();
                }
                this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, readonly, fileType);
                if (!restored) {
                    this.initNewFile();
                }
            }
            this.initBuffers();
            this.fileModified = false;
            this.freeBlocks = new DataFileBlockManager(this.maxFreeBlocks, this.cacheFileScale, freesize);
            this.database.logger.logInfoEvent("open end");
        }
        catch (Throwable t) {
            this.database.logger.logSevereEvent("open failed", t);
            this.close(false);
            throw Error.error(t, 452, 52, new Object[]{t.toString(), this.dataFileName});
        }
    }

    void initNewFile() throws IOException {
        this.fileFreePosition = this.initialFreePos;
        this.dataFile.seek(12L);
        this.dataFile.writeLong(this.initialFreePos);
        int flags = 0;
        if (this.database.logger.propIncrementBackup) {
            flags = BitMap.set(flags, 1);
        }
        flags = BitMap.set(flags, 2);
        flags = BitMap.set(flags, 4);
        this.dataFile.seek(28L);
        this.dataFile.writeInt(flags);
        this.dataFile.synch();
        this.is180 = false;
    }

    void openShadowFile() {
        if (this.database.logger.propIncrementBackup && this.fileFreePosition != (long)this.initialFreePos) {
            this.shadowFile = new RAShadowFile(this.database, this.dataFile, this.backupFileName, this.fileFreePosition, 16384);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIncrementBackup(boolean value) {
        this.writeLock.lock();
        try {
            try {
                this.dataFile.seek(28L);
                int flags = this.dataFile.readInt();
                flags = value ? BitMap.set(flags, 1) : BitMap.unset(flags, 1);
                this.dataFile.seek(28L);
                this.dataFile.writeInt(flags);
                this.dataFile.synch();
                this.fileModified = true;
            }
            catch (Throwable t) {
                this.database.logger.logSevereEvent("backupFile failed", t);
                Object var4_5 = null;
                this.writeLock.unlock();
            }
            Object var4_4 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    private boolean restoreBackup() {
        this.deleteOrResetFreePos();
        try {
            FileAccess fa = this.database.logger.getFileAccess();
            if (fa.isStreamElement(this.backupFileName)) {
                FileArchiver.unarchive(this.backupFileName, this.dataFileName, fa, 1);
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            throw Error.error(t, 452, 26, new Object[]{t.toString(), this.backupFileName});
        }
    }

    private boolean restoreBackupIncremental() {
        try {
            if (this.fa.isStreamElement(this.backupFileName)) {
                RAShadowFile.restoreFile(this.database, this.backupFileName, this.dataFileName);
                this.deleteBackup();
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw Error.error(452, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close(boolean write) {
        block12: {
            this.writeLock.lock();
            try {
                block11: {
                    try {
                        boolean empty;
                        if (write) {
                            this.commitChanges();
                        } else if (this.shadowFile != null) {
                            this.shadowFile.close();
                            this.shadowFile = null;
                        }
                        this.dataFile.close();
                        this.database.logger.logDetailEvent("dataFileCache file close");
                        this.dataFile = null;
                        if (!write) {
                            Object var4_2 = null;
                            break block11;
                        }
                        boolean bl = empty = this.fileFreePosition == (long)this.initialFreePos;
                        if (empty) {
                            this.deleteFile();
                            this.deleteBackup();
                        }
                        break block12;
                    }
                    catch (HsqlException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        this.database.logger.logSevereEvent("dataFileCache close failed", t);
                        throw Error.error(t, 452, 53, new Object[]{t.toString(), this.dataFileName});
                    }
                }
                this.writeLock.unlock();
                return;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }
        Object var4_3 = null;
        this.writeLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.writeLock.lock();
        try {
            this.cache.clear();
            this.fileFreePosition = 32L;
            if (this.freeBlocks != null) {
                this.freeBlocks.clear();
            }
            this.initBuffers();
            Object var2_1 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustStoreCount(int adjust) {
        this.writeLock.lock();
        try {
            this.storeCount += adjust;
            if (this.storeCount == 0) {
                this.clear();
            }
            Object var3_2 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    public void commitChanges() {
        block6: {
            this.writeLock.lock();
            try {
                try {
                    if (this.cacheReadonly) {
                        Object var3_1 = null;
                        this.writeLock.unlock();
                        return;
                    }
                    this.database.logger.logInfoEvent("dataFileCache commit start");
                    this.cache.saveAll();
                    this.database.logger.logDetailEvent("dataFileCache save data");
                    if (this.fileModified || this.freeBlocks.isModified()) {
                        this.dataFile.seek(4L);
                        this.dataFile.writeLong(this.freeBlocks.getLostBlocksSize());
                        this.dataFile.seek(12L);
                        this.dataFile.writeLong(this.fileFreePosition);
                        this.dataFile.seek(28L);
                        int flags = this.dataFile.readInt();
                        flags = BitMap.set(flags, 2);
                        this.dataFile.seek(28L);
                        this.dataFile.writeInt(flags);
                        this.database.logger.logDetailEvent("DataFileCache flags");
                    }
                    this.dataFile.synch();
                    this.fileModified = false;
                    if (this.shadowFile == null) break block6;
                    this.shadowFile.close();
                    this.shadowFile = null;
                }
                catch (Throwable t) {
                    this.database.logger.logSevereEvent("dataFileCache commit failed", t);
                    throw Error.error(t, 452, 53, new Object[]{t.toString(), this.dataFileName});
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }
        Object var3_2 = null;
        this.writeLock.unlock();
    }

    protected void initBuffers() {
        if (this.rowOut == null || this.rowOut.getOutputStream().getBuffer().length > 256) {
            this.rowOut = this.is180 ? new RowOutputBinary180(256, this.cachedRowPadding) : new RowOutputBinaryEncode(this.database.logger.getCrypto(), 256, this.cachedRowPadding);
        }
        if (this.rowIn == null || this.rowIn.getBuffer().length > 256) {
            this.rowIn = this.is180 ? new RowInputBinary180(new byte[256]) : new RowInputBinaryDecode(this.database.logger.getCrypto(), new byte[256]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataFileDefrag defrag() {
        this.writeLock.lock();
        try {
            this.cache.saveAll();
            DataFileDefrag dfd = new DataFileDefrag(this.database, this, this.dataFileName);
            dfd.process();
            this.close(true);
            this.cache.clear();
            if (!this.database.logger.propIncrementBackup) {
                this.backupFile();
            }
            this.database.schemaManager.setTempIndexRoots(dfd.getIndexRoots());
            this.database.logger.log.writeScript(false);
            this.database.getProperties().setProperty("hsqldb.script_format", this.database.logger.propScriptFormat);
            this.database.getProperties().setDBModified(2);
            this.database.logger.log.closeLog();
            this.database.logger.log.deleteLog();
            this.database.logger.log.renameNewScript();
            this.renameBackupFile();
            this.renameDataFile();
            this.database.getProperties().setDBModified(0);
            this.open(false);
            dfd.updateTransactionRowIDs();
            this.database.schemaManager.setIndexRoots(dfd.getIndexRoots());
            if (this.database.logger.log.dbLogWriter != null) {
                this.database.logger.log.openLog();
            }
            this.database.getProperties().setDBModified(1);
            DataFileDefrag dataFileDefrag = dfd;
            Object var4_3 = null;
            this.writeLock.unlock();
            return dataFileDefrag;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int i, PersistentStore store) {
        this.writeLock.lock();
        try {
            CachedObject r = this.release(i);
            if (r != null) {
                int size = r.getStorageSize();
                this.freeBlocks.add(i, size);
            }
            Object var6_5 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    public void removePersistence(int i, PersistentStore store) {
    }

    int setFilePos(CachedObject r) {
        int i;
        int rowSize = r.getStorageSize();
        int n = i = this.freeBlocks == null ? -1 : this.freeBlocks.get(rowSize);
        if (i == -1) {
            i = (int)(this.fileFreePosition / (long)this.cacheFileScale);
            long newFreePosition = this.fileFreePosition + (long)rowSize;
            if (newFreePosition > this.maxDataFileSize) {
                this.database.logger.logSevereEvent("data file reached maximum size " + this.dataFileName, null);
                throw Error.error(468);
            }
            boolean result = this.dataFile.ensureLength(newFreePosition);
            if (!result) {
                this.database.logger.logSevereEvent("data file cannot be enlarged - disk spacee " + this.dataFileName, null);
                throw Error.error(468);
            }
            this.fileFreePosition = newFreePosition;
        }
        r.setPos(i);
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CachedObject object) {
        this.writeLock.lock();
        try {
            int i = this.setFilePos(object);
            this.cache.put(i, object);
            Object var4_3 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStorageSize(int i) {
        block3: {
            this.readLock.lock();
            try {
                CachedObject value = this.cache.get(i);
                if (value == null) break block3;
                int n = value.getStorageSize();
                Object var5_4 = null;
                this.readLock.unlock();
                return n;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        Object var5_5 = null;
        this.readLock.unlock();
        return this.readSize(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(CachedObject object) {
        this.writeLock.lock();
        try {
            int pos = object.getPos();
            this.cache.replace(pos, object);
            Object var4_3 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(CachedObject object, PersistentStore store, boolean keep) {
        int pos;
        block9: {
            block8: {
                block7: {
                    this.readLock.lock();
                    try {
                        if (!object.isInMemory()) break block7;
                        if (keep) {
                            object.keepInMemory(true);
                        }
                        CachedObject cachedObject = object;
                        Object var7_7 = null;
                        this.readLock.unlock();
                        return cachedObject;
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        this.readLock.unlock();
                        throw throwable;
                    }
                }
                pos = object.getPos();
                if (pos >= 0) break block8;
                CachedObject cachedObject = null;
                Object var7_8 = null;
                this.readLock.unlock();
                return cachedObject;
            }
            object = this.cache.get(pos);
            if (object == null) break block9;
            if (keep) {
                object.keepInMemory(true);
            }
            CachedObject cachedObject = object;
            Object var7_9 = null;
            this.readLock.unlock();
            return cachedObject;
        }
        Object var7_10 = null;
        this.readLock.unlock();
        return this.getFromFile(pos, store, keep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(int pos, PersistentStore store, boolean keep) {
        block5: {
            if (pos < 0) {
                return null;
            }
            this.readLock.lock();
            try {
                CachedObject object = this.cache.get(pos);
                if (object == null) break block5;
                if (keep) {
                    object.keepInMemory(true);
                }
                CachedObject cachedObject = object;
                Object var7_6 = null;
                this.readLock.unlock();
                return cachedObject;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        Object var7_7 = null;
        this.readLock.unlock();
        return this.getFromFile(pos, store, keep);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CachedObject getFromFile(int pos, PersistentStore store, boolean keep) {
        CachedObject object = null;
        this.writeLock.lock();
        try {
            CachedObject j2;
            try {
                object = this.cache.get(pos);
                if (object != null) {
                    if (keep) {
                        object.keepInMemory(true);
                    }
                    CachedObject cachedObject = object;
                    Object var9_9 = null;
                    this.writeLock.unlock();
                    return cachedObject;
                }
                for (int j2 = 0; j2 < 2; ++j2) {
                    RowInputInterface rowInput;
                    block11: {
                        CachedObject cachedObject;
                        try {
                            rowInput = this.readObject(pos);
                            if (rowInput != null) break block11;
                            cachedObject = null;
                        }
                        catch (OutOfMemoryError err) {
                            this.cache.forceCleanUp();
                            System.gc();
                            if (j2 <= 0) continue;
                            throw err;
                        }
                        Object var9_10 = null;
                        this.writeLock.unlock();
                        return cachedObject;
                    }
                    object = store.get(rowInput);
                    break;
                }
                pos = object.getPos();
                this.cache.put(pos, object);
                if (keep) {
                    object.keepInMemory(true);
                }
                store.set(object);
                j2 = object;
                Object var9_11 = null;
            }
            catch (HsqlException e) {
                this.database.logger.logSevereEvent(this.dataFileName + " getFromFile " + pos, e);
                throw e;
            }
            this.writeLock.unlock();
            return j2;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RowInputInterface getRaw(int i) {
        this.writeLock.lock();
        try {
            RowInputInterface rowInputInterface = this.readObject(i);
            Object var4_3 = null;
            this.writeLock.unlock();
            return rowInputInterface;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    protected int readSize(int pos) {
        this.writeLock.lock();
        try {
            this.dataFile.seek((long)pos * (long)this.cacheFileScale);
            int n = this.dataFile.readInt();
            Object var4_4 = null;
            this.writeLock.unlock();
            return n;
        }
        catch (IOException e) {
            try {
                throw Error.error(466, e);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }
    }

    protected RowInputInterface readObject(int pos) {
        try {
            this.dataFile.seek((long)pos * (long)this.cacheFileScale);
            int size = this.dataFile.readInt();
            this.rowIn.resetRow(pos, size);
            this.dataFile.read(this.rowIn.getBuffer(), 4, size - 4);
            return this.rowIn;
        }
        catch (IOException e) {
            throw Error.error(466, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject release(int pos) {
        this.writeLock.lock();
        try {
            CachedObject cachedObject = this.cache.release(pos);
            Object var4_3 = null;
            this.writeLock.unlock();
            return cachedObject;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    protected void saveRows(CachedObject[] rows, int offset, int count) {
        if (count == 0) {
            return;
        }
        try {
            try {
                this.copyShadow(rows, offset, count);
                this.setFileModified();
                for (int i = offset; i < offset + count; ++i) {
                    CachedObject r = rows[i];
                    this.saveRowNoLock(r);
                    rows[i] = null;
                }
                Object var7_8 = null;
            }
            catch (HsqlException e) {
                this.database.logger.logSevereEvent("saveRows failed", e);
                throw e;
            }
            catch (Throwable e) {
                this.database.logger.logSevereEvent("saveRows failed", e);
                throw Error.error(466, e);
            }
            this.initBuffers();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.initBuffers();
            throw throwable;
        }
    }

    public void saveRow(CachedObject row) {
        this.writeLock.lock();
        try {
            try {
                this.copyShadow(row);
                this.setFileModified();
                this.saveRowNoLock(row);
            }
            catch (Throwable e) {
                this.database.logger.logSevereEvent("saveRow failed", e);
                throw Error.error(466, e);
            }
            Object var4_2 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    protected void saveRowNoLock(CachedObject row) {
        try {
            this.rowOut.reset();
            row.write(this.rowOut);
            this.dataFile.seek((long)row.getPos() * (long)this.cacheFileScale);
            this.dataFile.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
        }
        catch (IOException e) {
            throw Error.error(466, e);
        }
    }

    protected void copyShadow(CachedObject[] rows, int offset, int count) throws IOException {
        if (this.shadowFile != null) {
            for (int i = offset; i < offset + count; ++i) {
                CachedObject row = rows[i];
                long seekpos = (long)row.getPos() * (long)this.cacheFileScale;
                this.shadowFile.copy(seekpos, row.getStorageSize());
            }
            this.shadowFile.synch();
        }
    }

    protected void copyShadow(CachedObject row) throws IOException {
        if (this.shadowFile != null) {
            long seekpos = (long)row.getPos() * (long)this.cacheFileScale;
            this.shadowFile.copy(seekpos, row.getStorageSize());
            this.shadowFile.synch();
        }
    }

    void backupFile() {
        block6: {
            this.writeLock.lock();
            try {
                try {
                    if (this.database.logger.propIncrementBackup) {
                        if (this.fa.isStreamElement(this.backupFileName)) {
                            this.deleteBackup();
                        }
                        Object var3_1 = null;
                        this.writeLock.unlock();
                        return;
                    }
                    if (!this.fa.isStreamElement(this.dataFileName)) break block6;
                    FileArchiver.archive(this.dataFileName, this.backupFileName + ".new", this.database.logger.getFileAccess(), 1);
                }
                catch (IOException e) {
                    this.database.logger.logSevereEvent("backupFile failed", e);
                    throw Error.error(466, e);
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }
        Object var3_2 = null;
        this.writeLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renameBackupFile() {
        this.writeLock.lock();
        try {
            if (this.database.logger.propIncrementBackup) {
                this.deleteBackup();
                Object var2_1 = null;
                this.writeLock.unlock();
                return;
            }
            if (this.fa.isStreamElement(this.backupFileName + ".new")) {
                this.deleteBackup();
                this.fa.renameElement(this.backupFileName + ".new", this.backupFileName);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
        Object var2_2 = null;
        this.writeLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renameDataFile() {
        this.writeLock.lock();
        try {
            if (this.fa.isStreamElement(this.dataFileName + ".new")) {
                this.deleteFile();
                this.fa.renameElement(this.dataFileName + ".new", this.dataFileName);
            }
            Object var2_1 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteFile() {
        this.writeLock.lock();
        try {
            this.fa.removeElement(this.dataFileName);
            if (this.database.logger.isStoredFileAccess()) {
                Object var3_1 = null;
                this.writeLock.unlock();
                return;
            }
            if (this.fa.isStreamElement(this.dataFileName)) {
                this.database.logger.log.deleteOldDataFiles();
                this.fa.removeElement(this.dataFileName);
                if (this.fa.isStreamElement(this.dataFileName)) {
                    String discardName = this.newDiscardFileName();
                    this.fa.renameElement(this.dataFileName, discardName);
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
        Object var3_2 = null;
        this.writeLock.unlock();
    }

    String newDiscardFileName() {
        String timestamp = StringUtil.toPaddedString(Integer.toHexString((int)System.currentTimeMillis()), 8, '0', true);
        String discardName = this.dataFileName + "." + timestamp + ".old";
        return discardName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteBackup() {
        this.writeLock.lock();
        try {
            if (this.fa.isStreamElement(this.backupFileName)) {
                this.fa.removeElement(this.backupFileName);
            }
            Object var2_1 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void deleteOrResetFreePos() {
        this.deleteFile();
        if (this.database.logger.isStoredFileAccess()) {
            return;
        }
        if (!this.database.logger.getFileAccess().isStreamElement(this.dataFileName)) {
            return;
        }
        this.dataFile = new ScaledRAFileSimple(this.dataFileName, "rws");
        this.initNewFile();
        Object var3_1 = null;
        if (this.dataFile == null) return;
        try {
            this.dataFile.close();
            this.dataFile = null;
            return;
        }
        catch (IOException e2) {
            this.database.logger.logWarningEvent("error closing RA file", e2);
        }
        return;
        {
            catch (IOException e) {
                this.database.logger.logSevereEvent("deleteOrResetFreePos failed", e);
                Object var3_2 = null;
                if (this.dataFile == null) return;
                try {
                    this.dataFile.close();
                    this.dataFile = null;
                    return;
                }
                catch (IOException e2) {
                    this.database.logger.logWarningEvent("error closing RA file", e2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.dataFile == null) throw throwable;
            try {
                this.dataFile.close();
                this.dataFile = null;
                throw throwable;
            }
            catch (IOException e2) {
                this.database.logger.logWarningEvent("error closing RA file", e2);
            }
            throw throwable;
        }
    }

    public int capacity() {
        return this.maxCacheRows;
    }

    public long bytesCapacity() {
        return this.maxCacheBytes;
    }

    public long getTotalCachedBlockSize() {
        return this.cache.getTotalCachedBlockSize();
    }

    public int getFreeBlockCount() {
        return this.freeBlocks == null ? 0 : this.freeBlocks.size();
    }

    public int getTotalFreeBlockSize() {
        return 0;
    }

    public long getFileFreePos() {
        return this.fileFreePosition;
    }

    public int getCachedObjectCount() {
        return this.cache.size();
    }

    public int getAccessCount() {
        return this.cache.incrementAccessCount();
    }

    public String getFileName() {
        return this.dataFileName;
    }

    public boolean hasRowInfo() {
        return this.hasRowInfo;
    }

    public boolean isFileModified() {
        return this.fileModified;
    }

    public boolean isFileOpen() {
        return this.dataFile != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFileModified() {
        this.writeLock.lock();
        try {
            block4: {
                try {
                    if (this.fileModified) break block4;
                    long start = this.cache.saveAllTimer.elapsedTime();
                    this.cache.saveAllTimer.start();
                    this.dataFile.seek(28L);
                    int flags = this.dataFile.readInt();
                    flags = BitMap.unset(flags, 2);
                    this.dataFile.seek(28L);
                    this.dataFile.writeInt(flags);
                    this.dataFile.synch();
                    this.cache.saveAllTimer.stop();
                    this.database.logger.logDetailEvent("flags set " + this.cache.saveAllTimer.elapsedTime());
                    this.fileModified = true;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.writeLock.unlock();
                }
            }
            Object var5_4 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    public int getFlags() {
        try {
            this.dataFile.seek(28L);
            int flags = this.dataFile.readInt();
            return flags;
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public boolean isDataReadOnly() {
        return this.cacheReadonly;
    }
}

