/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.hsqldb.Database;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.persist.ScaledRAFile;

final class ScaledRAFileNIO
implements RandomAccessInterface {
    private final Database database;
    private final boolean readOnly;
    private final long maxLength;
    private long fileLength;
    private RandomAccessFile file;
    private FileDescriptor fileDescriptor;
    private MappedByteBuffer buffer;
    private long bufferPosition;
    private int bufferLength;
    private long currentPosition;
    private FileChannel channel;
    private boolean buffersModified;
    private MappedByteBuffer[] buffers = new MappedByteBuffer[0];
    private static final String JVM_ERROR = "JVM threw unsupported Exception";
    static final int largeBufferScale = 24;
    static final int largeBufferSize = 0x1000000;
    static final long largeBufferMask = -16777216L;

    ScaledRAFileNIO(Database database, String name, boolean readOnly, long requiredLength, long maxLength) throws Throwable {
        this.database = database;
        this.maxLength = maxLength;
        File fi = new File(name);
        long fileLength = fi.length();
        if (readOnly) {
            requiredLength = fileLength;
        } else {
            if (fileLength > requiredLength) {
                requiredLength = fileLength;
            }
            requiredLength = ScaledRAFile.getBinaryNormalisedCeiling(requiredLength, 24);
        }
        this.file = new RandomAccessFile(name, readOnly ? "r" : "rw");
        this.readOnly = readOnly;
        this.channel = this.file.getChannel();
        this.fileDescriptor = this.file.getFD();
        if (!this.ensureLength(requiredLength)) {
            IOException io = new IOException("NIO buffer allocation failed");
            throw io;
        }
        this.buffer = this.buffers[0];
        this.bufferLength = this.buffer.limit();
        this.bufferPosition = 0L;
        this.currentPosition = 0L;
    }

    public long length() throws IOException {
        try {
            return this.file.length();
        }
        catch (IOException e) {
            this.database.logger.logWarningEvent("nio", e);
            throw e;
        }
        catch (Throwable e) {
            this.database.logger.logWarningEvent(JVM_ERROR, e);
            IOException io = new IOException(e.toString());
            try {
                io.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw io;
        }
    }

    public void seek(long newPos) throws IOException {
        try {
            this.positionBufferSeek(newPos);
            this.buffer.position((int)(newPos - this.bufferPosition));
        }
        catch (IllegalArgumentException e) {
            this.database.logger.logWarningEvent("nio", e);
            IOException io = new IOException(e.toString());
            try {
                io.initCause(e);
            }
            catch (Throwable e1) {
                // empty catch block
            }
            throw io;
        }
        catch (Throwable e) {
            this.database.logger.logWarningEvent(JVM_ERROR, e);
            IOException io = new IOException(e.toString());
            try {
                io.initCause(e);
            }
            catch (Throwable e1) {
                // empty catch block
            }
            throw io;
        }
    }

    public long getFilePointer() throws IOException {
        try {
            return this.currentPosition;
        }
        catch (Throwable e) {
            this.database.logger.logWarningEvent(JVM_ERROR, e);
            IOException io = new IOException(e.toString());
            try {
                io.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw io;
        }
    }

    public int read() throws IOException {
        try {
            byte value = this.buffer.get();
            this.positionBufferMove(1);
            return value;
        }
        catch (Throwable e) {
            this.database.logger.logWarningEvent(JVM_ERROR, e);
            IOException io = new IOException(e.toString());
            try {
                io.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw io;
        }
    }

    public void read(byte[] b, int offset, int length) throws IOException {
        try {
            do {
                long transferLength;
                if ((transferLength = this.bufferPosition + (long)this.bufferLength - this.currentPosition) > (long)length) {
                    transferLength = length;
                }
                this.buffer.get(b, offset, (int)transferLength);
                this.positionBufferMove((int)transferLength);
                length = (int)((long)length - transferLength);
                offset = (int)((long)offset + transferLength);
            } while (length != 0);
        }
        catch (Throwable e) {
            this.database.logger.logWarningEvent(JVM_ERROR, e);
            IOException io = new IOException(e.toString());
            try {
                io.initCause(e);
            }
            catch (Throwable e1) {
                // empty catch block
            }
            throw io;
        }
    }

    public int readInt() throws IOException {
        try {
            int value = this.buffer.getInt();
            this.positionBufferMove(4);
            return value;
        }
        catch (Throwable e) {
            this.database.logger.logWarningEvent(JVM_ERROR, e);
            IOException io = new IOException(e.toString());
            try {
                io.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw io;
        }
    }

    public long readLong() throws IOException {
        try {
            long value = this.buffer.getLong();
            this.positionBufferMove(8);
            return value;
        }
        catch (Throwable e) {
            this.database.logger.logWarningEvent(JVM_ERROR, e);
            IOException io = new IOException(e.toString());
            try {
                io.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw io;
        }
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        try {
            this.buffersModified = true;
            do {
                long transferLength;
                if ((transferLength = this.bufferPosition + (long)this.bufferLength - this.currentPosition) > (long)length) {
                    transferLength = length;
                }
                this.buffer.put(b, offset, (int)transferLength);
                this.positionBufferMove((int)transferLength);
                length = (int)((long)length - transferLength);
                offset = (int)((long)offset + transferLength);
            } while (length != 0);
        }
        catch (Throwable e) {
            this.database.logger.logWarningEvent(JVM_ERROR, e);
            IOException io = new IOException(e.toString());
            try {
                io.initCause(e);
            }
            catch (Throwable e1) {
                // empty catch block
            }
            throw io;
        }
    }

    public void writeInt(int i) throws IOException {
        try {
            this.buffersModified = true;
            this.buffer.putInt(i);
            this.positionBufferMove(4);
        }
        catch (Throwable e) {
            this.database.logger.logWarningEvent(JVM_ERROR, e);
            IOException io = new IOException(e.toString());
            try {
                io.initCause(e);
            }
            catch (Throwable e1) {
                // empty catch block
            }
            throw io;
        }
    }

    public void writeLong(long i) throws IOException {
        try {
            this.buffersModified = true;
            this.buffer.putLong(i);
            this.positionBufferMove(8);
        }
        catch (Throwable e) {
            this.database.logger.logWarningEvent(JVM_ERROR, e);
            IOException io = new IOException(e.toString());
            try {
                io.initCause(e);
            }
            catch (Throwable e1) {
                // empty catch block
            }
            throw io;
        }
    }

    public void close() throws IOException {
        try {
            this.database.logger.logDetailEvent("NIO file close, size: " + this.fileLength);
            this.buffer = null;
            this.channel = null;
            for (int i = 0; i < this.buffers.length; ++i) {
                this.unmap(this.buffers[i]);
                this.buffers[i] = null;
            }
            this.file.close();
        }
        catch (Throwable e) {
            this.database.logger.logWarningEvent("NIO buffer close error JVM threw unsupported Exception ", e);
            IOException io = new IOException(e.toString());
            try {
                io.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw io;
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean wasNio() {
        return true;
    }

    public boolean ensureLength(long newLength) {
        if (newLength > this.maxLength) {
            return false;
        }
        while (newLength > this.fileLength) {
            if (this.enlargeFile(newLength)) continue;
            return false;
        }
        return true;
    }

    private boolean enlargeFile(long newFileLength) {
        try {
            FileChannel.MapMode mapMode;
            long newBufferLength = newFileLength;
            if (!this.readOnly) {
                newBufferLength = 0x1000000L;
            }
            FileChannel.MapMode mapMode2 = mapMode = this.readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            if (!this.readOnly && this.file.length() < this.fileLength + newBufferLength) {
                this.file.seek(this.fileLength + newBufferLength - 1L);
                this.file.writeByte(0);
            }
            MappedByteBuffer newBuffer = this.channel.map(mapMode, this.fileLength, newBufferLength);
            MappedByteBuffer[] newBuffers = new MappedByteBuffer[this.buffers.length + 1];
            System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
            newBuffers[this.buffers.length] = newBuffer;
            this.buffers = newBuffers;
            this.fileLength += newBufferLength;
            this.database.logger.logDetailEvent("NIO buffer instance, file size " + this.fileLength);
        }
        catch (Throwable e) {
            this.database.logger.logDetailEvent("NOI buffer allocate failed, file size " + newFileLength);
            try {
                this.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public boolean setLength(long newLength) {
        if (newLength > this.fileLength) {
            return this.enlargeFile(newLength);
        }
        try {
            this.seek(0L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public Database getDatabase() {
        return null;
    }

    public void synch() {
        int i;
        boolean error = false;
        for (i = 0; i < this.buffers.length; ++i) {
            try {
                this.buffers[i].force();
                continue;
            }
            catch (Throwable t) {
                this.database.logger.logWarningEvent("NIO buffer force error JVM threw unsupported Exception ", t);
                error = true;
            }
        }
        if (error) {
            for (i = 0; i < this.buffers.length; ++i) {
                try {
                    this.buffers[i].force();
                    continue;
                }
                catch (Throwable t) {
                    this.database.logger.logWarningEvent("NIO buffer force error JVM threw unsupported Exception ", t);
                }
            }
        }
        try {
            this.fileDescriptor.sync();
            this.buffersModified = false;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void positionBufferSeek(long offset) {
        if (offset < this.bufferPosition || offset >= this.bufferPosition + (long)this.bufferLength) {
            this.setCurrentBuffer(offset);
        }
        this.buffer.position((int)(offset - this.bufferPosition));
        this.currentPosition = offset;
    }

    private void positionBufferMove(int relOffset) {
        long offset = this.currentPosition + (long)relOffset;
        if (offset >= this.bufferPosition + (long)this.bufferLength) {
            this.setCurrentBuffer(offset);
        }
        this.buffer.position((int)(offset - this.bufferPosition));
        this.currentPosition = offset;
    }

    private void setCurrentBuffer(long offset) {
        int bufferIndex = (int)(offset >> 24);
        this.buffer = this.buffers[bufferIndex];
        this.bufferPosition = offset &= 0xFFFFFFFFFF000000L;
    }

    private void unmap(MappedByteBuffer buffer) throws IOException {
        if (buffer == null) {
            return;
        }
        try {
            Method cleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
            cleanerMethod.setAccessible(true);
            Object cleaner = cleanerMethod.invoke((Object)buffer, new Object[0]);
            Method clearMethod = cleaner.getClass().getMethod("clean", new Class[0]);
            clearMethod.invoke(cleaner, new Object[0]);
        }
        catch (InvocationTargetException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

