/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Scanner;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.rowio.RowInputBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowInputTextLog
extends RowInputBase
implements RowInputInterface {
    Scanner scanner = new Scanner();
    String tableName = null;
    String schemaName = null;
    int statementType;
    Object value;
    boolean version18;
    boolean noSeparators;

    public RowInputTextLog() {
        super(new byte[0]);
    }

    public RowInputTextLog(boolean version18) {
        super(new byte[0]);
        this.version18 = version18;
    }

    public void setSource(String text) {
        this.scanner.reset(text);
        this.statementType = 1;
        this.scanner.scanNext();
        String s = this.scanner.getString();
        if (s.equals("INSERT")) {
            this.statementType = 3;
            this.scanner.scanNext();
            this.scanner.scanNext();
            this.tableName = this.scanner.getString();
            this.scanner.scanNext();
        } else if (s.equals("DELETE")) {
            this.statementType = 2;
            this.scanner.scanNext();
            this.scanner.scanNext();
            this.tableName = this.scanner.getString();
        } else if (s.equals("COMMIT")) {
            this.statementType = 4;
        } else if (s.equals("SET")) {
            this.scanner.scanNext();
            if ("SCHEMA".equals(this.scanner.getString())) {
                this.scanner.scanNext();
                this.schemaName = this.scanner.getString();
                this.statementType = 6;
            }
        }
    }

    public int getStatementType() {
        return this.statementType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    protected void readField() {
        this.readFieldPrefix();
        this.scanner.scanNext();
        this.value = this.scanner.getValue();
    }

    protected void readNumberField(Type type) {
        boolean minus;
        this.readFieldPrefix();
        this.scanner.scanNext();
        boolean bl = minus = this.scanner.getTokenType() == 784;
        if (minus) {
            this.scanner.scanNext();
        }
        this.value = this.scanner.getValue();
        if (minus) {
            try {
                this.value = ((NumberType)this.scanner.getDataType()).negate(this.value);
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
    }

    protected void readFieldPrefix() {
        if (!this.noSeparators) {
            this.scanner.scanNext();
            if (this.statementType == 2) {
                this.scanner.scanNext();
                this.scanner.scanNext();
            }
        }
    }

    public String readString() throws IOException {
        this.readField();
        return (String)this.value;
    }

    public short readShort() throws IOException {
        throw Error.runtimeError(201, "");
    }

    public int readInt() throws IOException {
        throw Error.runtimeError(201, "");
    }

    public long readLong() throws IOException {
        throw Error.runtimeError(201, "");
    }

    public int readType() throws IOException {
        return 0;
    }

    protected boolean readNull() {
        return false;
    }

    protected String readChar(Type type) throws IOException {
        this.readField();
        return (String)this.value;
    }

    protected Integer readSmallint() throws IOException {
        this.readNumberField(Type.SQL_SMALLINT);
        return (Integer)this.value;
    }

    protected Integer readInteger() throws IOException {
        this.readNumberField(Type.SQL_INTEGER);
        if (this.value instanceof Long) {
            this.value = Type.SQL_INTEGER.convertToDefaultType(null, this.value);
        }
        return (Integer)this.value;
    }

    protected Long readBigint() throws IOException {
        this.readNumberField(Type.SQL_BIGINT);
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof BigDecimal) {
            return (Long)Type.SQL_BIGINT.convertToDefaultType(null, this.value);
        }
        return ValuePool.getLong(((Number)this.value).longValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Double readReal() throws IOException {
        this.readNumberField(Type.SQL_DOUBLE);
        if (this.value == null) {
            return null;
        }
        if (!this.scanner.scanSpecialIdentifier("/")) return (Double)this.value;
        this.scanner.scanNext();
        Object divisor = this.scanner.getValue();
        double i = ((Number)divisor).doubleValue();
        if (i != 0.0) throw Error.error(5584);
        if (((Number)this.value).doubleValue() == 1.0) {
            i = Double.NEGATIVE_INFINITY;
        } else if (((Number)this.value).doubleValue() == -1.0) {
            i = Double.POSITIVE_INFINITY;
        } else {
            if (((Number)this.value).doubleValue() != 0.0) throw Error.error(5584);
            i = Double.NaN;
        }
        this.value = i;
        return (Double)this.value;
    }

    protected BigDecimal readDecimal(Type type) throws IOException {
        this.readNumberField(type);
        if (this.value == null) {
            return null;
        }
        BigDecimal bd = (BigDecimal)type.convertToDefaultType(null, this.value);
        return (BigDecimal)type.convertToTypeLimits(null, bd);
    }

    protected TimeData readTime(Type type) throws IOException {
        this.readField();
        if (this.value == null) {
            return null;
        }
        if (this.version18) {
            Time dateTime = Time.valueOf((String)this.value);
            long millis = HsqlDateTime.convertMillisFromCalendar(HsqlDateTime.tempCalDefault, dateTime.getTime());
            millis = HsqlDateTime.getNormalisedTime(millis);
            return new TimeData((int)millis / 1000, 0, 0);
        }
        return this.scanner.newTime((String)this.value);
    }

    protected TimestampData readDate(Type type) throws IOException {
        this.readField();
        if (this.value == null) {
            return null;
        }
        if (this.version18) {
            Date dateTime = Date.valueOf((String)this.value);
            long millis = HsqlDateTime.convertMillisFromCalendar(HsqlDateTime.tempCalDefault, dateTime.getTime());
            millis = HsqlDateTime.getNormalisedDate(millis);
            return new TimestampData(millis / 1000L);
        }
        return this.scanner.newDate((String)this.value);
    }

    protected TimestampData readTimestamp(Type type) throws IOException {
        this.readField();
        if (this.value == null) {
            return null;
        }
        if (this.version18) {
            Timestamp dateTime = Timestamp.valueOf((String)this.value);
            long millis = HsqlDateTime.convertMillisFromCalendar(HsqlDateTime.tempCalDefault, dateTime.getTime());
            int nanos = dateTime.getNanos();
            DateTimeType cfr_ignored_0 = (DateTimeType)type;
            nanos = DateTimeType.normaliseFraction(nanos, type.scale);
            return new TimestampData(millis / 1000L, nanos, 0);
        }
        return this.scanner.newTimestamp((String)this.value);
    }

    protected IntervalMonthData readYearMonthInterval(Type type) throws IOException {
        this.readField();
        if (this.value == null) {
            return null;
        }
        return (IntervalMonthData)this.scanner.newInterval((String)this.value, (IntervalType)type);
    }

    protected IntervalSecondData readDaySecondInterval(Type type) throws IOException {
        this.readField();
        if (this.value == null) {
            return null;
        }
        return (IntervalSecondData)this.scanner.newInterval((String)this.value, (IntervalType)type);
    }

    protected Boolean readBoole() throws IOException {
        this.readFieldPrefix();
        this.scanner.scanNext();
        String token = this.scanner.getString();
        this.value = null;
        if (token.equalsIgnoreCase("TRUE")) {
            this.value = Boolean.TRUE;
        } else if (token.equalsIgnoreCase("FALSE")) {
            this.value = Boolean.FALSE;
        }
        return (Boolean)this.value;
    }

    protected Object readOther() throws IOException {
        this.readFieldPrefix();
        if (this.scanner.scanNull()) {
            return null;
        }
        this.scanner.scanBinaryStringWithQuote();
        if (this.scanner.getTokenType() == 856) {
            throw Error.error(5587);
        }
        this.value = this.scanner.getValue();
        return new JavaObjectData(((BinaryData)this.value).getBytes());
    }

    protected BinaryData readBit() throws IOException {
        this.readFieldPrefix();
        if (this.scanner.scanNull()) {
            return null;
        }
        this.scanner.scanBitStringWithQuote();
        if (this.scanner.getTokenType() == 855) {
            throw Error.error(5587);
        }
        this.value = this.scanner.getValue();
        return (BinaryData)this.value;
    }

    protected BinaryData readBinary() throws IOException {
        this.readFieldPrefix();
        if (this.scanner.scanNull()) {
            return null;
        }
        this.scanner.scanBinaryStringWithQuote();
        if (this.scanner.getTokenType() == 856) {
            throw Error.error(5587);
        }
        this.value = this.scanner.getValue();
        return (BinaryData)this.value;
    }

    protected ClobData readClob() throws IOException {
        this.readNumberField(Type.SQL_BIGINT);
        if (this.value == null) {
            return null;
        }
        long id = ((Number)this.value).longValue();
        return new ClobDataID(id);
    }

    protected BlobData readBlob() throws IOException {
        this.readNumberField(Type.SQL_BIGINT);
        if (this.value == null) {
            return null;
        }
        long id = ((Number)this.value).longValue();
        return new BlobDataID(id);
    }

    protected Object[] readArray(Type type) throws IOException {
        type = type.collectionBaseType();
        this.readFieldPrefix();
        this.scanner.scanNext();
        String token = this.scanner.getString();
        this.value = null;
        if (token.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (!token.equalsIgnoreCase("ARRAY")) {
            throw Error.error(5584);
        }
        this.scanner.scanNext();
        token = this.scanner.getString();
        if (!token.equalsIgnoreCase("[")) {
            throw Error.error(5584);
        }
        HsqlArrayList list = new HsqlArrayList();
        this.noSeparators = true;
        int i = 0;
        while (!this.scanner.scanSpecialIdentifier("]")) {
            if (i > 0 && !this.scanner.scanSpecialIdentifier(",")) {
                throw Error.error(5584);
            }
            Object value = this.readData(type);
            list.add(value);
            ++i;
        }
        this.noSeparators = false;
        Object[] data = new Object[list.size()];
        list.toArray(data);
        return data;
    }
}

