/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.hsqldb.Row;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.rowio.RowOutputBase;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowOutputBinary
extends RowOutputBase {
    protected static final int INT_STORE_SIZE = 4;
    int storageSize;
    final int scale;
    final int mask;

    public RowOutputBinary(int initialSize, int scale) {
        super(initialSize);
        this.scale = scale;
        this.mask = ~(scale - 1);
    }

    public RowOutputBinary(byte[] buffer) {
        super(buffer);
        this.scale = 1;
        this.mask = ~(this.scale - 1);
    }

    public void writeIntData(int i, int position) {
        int temp = this.count;
        this.count = position;
        this.writeInt(i);
        if (this.count < temp) {
            this.count = temp;
        }
    }

    public void writeData(Row row, Type[] types) {
        super.writeData(row, types);
    }

    public void writeEnd() {
        if (this.count > this.storageSize) {
            Error.runtimeError(201, "RowOutputBinary");
        }
        while (this.count < this.storageSize) {
            this.write(0);
        }
    }

    public void writeSize(int size) {
        this.storageSize = size;
        this.writeInt(size);
    }

    public void writeType(int type) {
        this.writeShort(type);
    }

    public void writeString(String s) {
        int temp = this.count;
        this.writeInt(0);
        if (s != null && s.length() != 0) {
            StringConverter.stringToUTFBytes(s, this);
            this.writeIntData(this.count - temp - 4, temp);
        }
    }

    public int getSize(Row row) {
        Object[] data = row.getData();
        Type[] types = row.getTable().getColumnTypes();
        int cols = row.getTable().getDataColumnCount();
        return 4 + this.getSize(data, cols, types);
    }

    public int getStorageSize(int size) {
        return size + this.scale - 1 & this.mask;
    }

    protected void writeFieldType(Type type) {
        this.write(1);
    }

    protected void writeNull(Type type) {
        this.write(0);
    }

    protected void writeChar(String s, Type t) {
        this.writeString(s);
    }

    protected void writeSmallint(Number o) {
        this.writeShort(o.intValue());
    }

    protected void writeInteger(Number o) {
        this.writeInt(o.intValue());
    }

    protected void writeBigint(Number o) {
        this.writeLong(o.longValue());
    }

    protected void writeReal(Double o) {
        this.writeLong(Double.doubleToLongBits(o));
    }

    protected void writeDecimal(BigDecimal o, Type type) {
        int scale = o.scale();
        BigInteger bigint = JavaSystem.unscaledValue(o);
        byte[] bytearr = bigint.toByteArray();
        this.writeByteArray(bytearr);
        this.writeInt(scale);
    }

    protected void writeBoolean(Boolean o) {
        this.write(o != false ? 1 : 0);
    }

    protected void writeDate(TimestampData o, Type type) {
        this.writeLong(o.getSeconds());
    }

    protected void writeTime(TimeData o, Type type) {
        this.writeInt(o.getSeconds());
        this.writeInt(o.getNanos());
        if (type.typeCode == 94) {
            this.writeInt(o.getZone());
        }
    }

    protected void writeTimestamp(TimestampData o, Type type) {
        this.writeLong(o.getSeconds());
        this.writeInt(o.getNanos());
        if (type.typeCode == 95) {
            this.writeInt(o.getZone());
        }
    }

    protected void writeYearMonthInterval(IntervalMonthData o, Type type) {
        this.writeLong(o.units);
    }

    protected void writeDaySecondInterval(IntervalSecondData o, Type type) {
        this.writeLong(o.units);
        this.writeInt(o.nanos);
    }

    protected void writeOther(JavaObjectData o) {
        this.writeByteArray(o.getBytes());
    }

    protected void writeBit(BinaryData o) {
        this.writeInt((int)o.bitLength(null));
        this.write(o.getBytes(), 0, o.getBytes().length);
    }

    protected void writeBinary(BinaryData o) {
        this.writeByteArray(o.getBytes());
    }

    protected void writeClob(ClobData o, Type type) {
        this.writeLong(o.getId());
    }

    protected void writeBlob(BlobData o, Type type) {
        this.writeLong(o.getId());
    }

    protected void writeArray(Object[] o, Type type) {
        type = type.collectionBaseType();
        this.writeInt(o.length);
        for (int i = 0; i < o.length; ++i) {
            this.writeData(type, o[i]);
        }
    }

    public void writeByteArray(byte[] b) {
        this.writeInt(b.length);
        this.write(b, 0, b.length);
    }

    public void writeCharArray(char[] c) {
        this.writeInt(c.length);
        this.write(c, 0, c.length);
    }

    private int getSize(Object[] data, int l, Type[] types) {
        int s = 0;
        for (int i = 0; i < l; ++i) {
            Object o = data[i];
            s += this.getSize(o, types[i]);
        }
        return s;
    }

    private int getSize(Object o, Type type) {
        int s = 1;
        if (o == null) {
            return s;
        }
        switch (type.typeCode) {
            case 0: {
                break;
            }
            case 1: 
            case 12: 
            case 100: {
                s += 4;
                s += StringConverter.getUTFSize((String)o);
                break;
            }
            case -6: 
            case 5: {
                s += 2;
                break;
            }
            case 4: {
                s += 4;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 25: {
                s += 8;
                break;
            }
            case 2: 
            case 3: {
                s += 8;
                BigDecimal bigdecimal = (BigDecimal)o;
                BigInteger bigint = JavaSystem.unscaledValue(bigdecimal);
                s += bigint.toByteArray().length;
                break;
            }
            case 16: {
                ++s;
                break;
            }
            case 91: {
                s += 8;
                break;
            }
            case 92: {
                s += 8;
                break;
            }
            case 94: {
                s += 12;
                break;
            }
            case 93: {
                s += 12;
                break;
            }
            case 95: {
                s += 16;
                break;
            }
            case 101: 
            case 102: 
            case 107: {
                s += 8;
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                s += 12;
                break;
            }
            case 60: 
            case 61: {
                s += 4;
                s = (int)((long)s + ((BinaryData)o).length(null));
                break;
            }
            case 14: 
            case 15: {
                s += 4;
                s = (int)((long)s + ((BinaryData)o).length(null));
                break;
            }
            case 30: 
            case 40: {
                s += 8;
                break;
            }
            case 50: {
                s += 4;
                Object[] array = (Object[])o;
                type = type.collectionBaseType();
                for (int i = 0; i < array.length; ++i) {
                    s += this.getSize(array[i], type);
                }
                break;
            }
            case 1111: {
                JavaObjectData jo = (JavaObjectData)o;
                s += 4;
                s += jo.getBytesLength();
                break;
            }
            default: {
                throw Error.runtimeError(201, "RowOutputBinary");
            }
        }
        return s;
    }

    public void ensureRoom(int extra) {
        super.ensureRoom(extra);
    }

    public void reset() {
        super.reset();
        this.storageSize = 0;
    }

    public void reset(int newSize) {
        super.reset(newSize);
        this.storageSize = 0;
    }

    public void setBuffer(byte[] buffer) {
        this.buffer = buffer;
        this.reset();
    }

    public RowOutputInterface duplicate() {
        return new RowOutputBinary(128, this.scale);
    }
}

