/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.search;

import com.liferay.portal.kernel.dao.search.ButtonSearchEntry;
import com.liferay.portal.kernel.dao.search.DateSearchEntry;
import com.liferay.portal.kernel.dao.search.JSPSearchEntry;
import com.liferay.portal.kernel.dao.search.SearchEntry;
import com.liferay.portal.kernel.dao.search.StatusSearchEntry;
import com.liferay.portal.kernel.dao.search.TextSearchEntry;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletURL;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResultRow {
    private boolean _bold;
    private String _classHoverName;
    private String _className;
    private Map<String, Object> _data;
    private Object _obj;
    private Map<String, Object> _params;
    private int _pos;
    private String _primaryKey;
    private boolean _restricted;
    private String _rowId;
    private List<SearchEntry> _searchEntries;
    private boolean _skip;

    public ResultRow(Object obj, long primaryKey, int pos) {
        this(obj, String.valueOf(primaryKey), pos);
    }

    public ResultRow(Object obj, long primaryKey, int pos, boolean bold) {
        this(obj, String.valueOf(primaryKey), pos, bold);
    }

    public ResultRow(Object obj, String primaryKey, int pos) {
        this(obj, primaryKey, pos, false);
    }

    public ResultRow(Object obj, String primaryKey, int pos, boolean bold) {
        this(String.valueOf(pos + 1), obj, primaryKey, pos, bold);
    }

    public ResultRow(String rowId, Object obj, String primaryKey, int pos, boolean bold) {
        this._rowId = rowId;
        this._obj = obj;
        this._primaryKey = primaryKey;
        this._pos = pos;
        this._bold = bold;
        this._searchEntries = new ArrayList<SearchEntry>();
    }

    public void addButton(int index, String name, String href) {
        this.addButton(index, "left", "middle", 1, name, href);
    }

    public void addButton(int index, String align, String valign, int colspan, String name, String href) {
        if (this._restricted) {
            href = null;
        }
        ButtonSearchEntry buttonSearchEntry = new ButtonSearchEntry();
        buttonSearchEntry.setAlign(align);
        buttonSearchEntry.setColspan(colspan);
        buttonSearchEntry.setHref(href);
        buttonSearchEntry.setName(name);
        buttonSearchEntry.setValign(valign);
        this._searchEntries.add(index, buttonSearchEntry);
    }

    public void addButton(String name, String href) {
        this.addButton(this._searchEntries.size(), name, href);
    }

    public void addButton(String align, String valign, int colspan, String name, String href) {
        this.addButton(this._searchEntries.size(), align, valign, colspan, name, href);
    }

    public void addButton(String align, String valign, String name, String href) {
        this.addButton(this._searchEntries.size(), align, valign, 1, name, href);
    }

    public void addDate(Date date) {
        this.addDate(this._searchEntries.size(), date, null);
    }

    public void addDate(Date date, PortletURL portletURL) {
        if (portletURL != null) {
            this.addDate(this._searchEntries.size(), date, portletURL.toString());
        } else {
            this.addDate(this._searchEntries.size(), date, null);
        }
    }

    public void addDate(Date date, String href) {
        this.addDate(this._searchEntries.size(), date, null);
    }

    public void addDate(int index, Date date, String href) {
        DateSearchEntry dateSearchEntry = new DateSearchEntry();
        dateSearchEntry.setAlign("left");
        dateSearchEntry.setColspan(1);
        dateSearchEntry.setDate(date);
        dateSearchEntry.setHref(href);
        dateSearchEntry.setValign("middle");
        this._searchEntries.add(index, dateSearchEntry);
    }

    public void addJSP(int index, String path) {
        this.addJSP(index, "left", "middle", 1, path);
    }

    public void addJSP(int index, String path, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        this.addJSP(index, "left", "middle", 1, path, servletContext, request, response);
    }

    public void addJSP(int index, String align, String valign, int colspan, String path) {
        JSPSearchEntry jspSearchEntry = new JSPSearchEntry();
        jspSearchEntry.setAlign(align);
        jspSearchEntry.setColspan(colspan);
        jspSearchEntry.setPath(path);
        jspSearchEntry.setValign(valign);
        this._searchEntries.add(index, jspSearchEntry);
    }

    public void addJSP(int index, String align, String valign, int colspan, String path, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        JSPSearchEntry jspSearchEntry = new JSPSearchEntry();
        jspSearchEntry.setAlign(align);
        jspSearchEntry.setColspan(colspan);
        jspSearchEntry.setPath(path);
        jspSearchEntry.setRequest(request);
        jspSearchEntry.setResponse(response);
        jspSearchEntry.setServletContext(servletContext);
        jspSearchEntry.setValign(valign);
        this._searchEntries.add(index, jspSearchEntry);
    }

    public void addJSP(String path) {
        this.addJSP(this._searchEntries.size(), path);
    }

    public void addJSP(String path, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        this.addJSP(this._searchEntries.size(), path, servletContext, request, response);
    }

    public void addJSP(String align, String valign, int colspan, String path) {
        this.addJSP(this._searchEntries.size(), align, valign, colspan, path);
    }

    public void addJSP(String align, String valign, int colspan, String path, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        this.addJSP(this._searchEntries.size(), align, valign, colspan, path, servletContext, request, response);
    }

    public void addJSP(String align, String valign, String path) {
        this.addJSP(this._searchEntries.size(), align, valign, 1, path);
    }

    public void addJSP(String align, String valign, String path, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        this.addJSP(this._searchEntries.size(), align, valign, 1, path, servletContext, request, response);
    }

    public void addSearchEntry(int index, SearchEntry searchEntry) {
        this._searchEntries.add(index, searchEntry);
    }

    public void addSearchEntry(SearchEntry searchEntry) {
        this._searchEntries.add(searchEntry);
    }

    public void addStatus(int status) {
        this.addStatus(this._searchEntries.size(), status, 0L, null, null);
    }

    public void addStatus(int index, int status, long statusByUserId, Date statusDate, String href) {
        StatusSearchEntry statusSearchEntry = new StatusSearchEntry();
        statusSearchEntry.setAlign("left");
        statusSearchEntry.setColspan(1);
        statusSearchEntry.setHref(href);
        statusSearchEntry.setStatus(status);
        statusSearchEntry.setStatusDate(statusDate);
        statusSearchEntry.setStatusByUserId(statusByUserId);
        statusSearchEntry.setValign("middle");
        this._searchEntries.add(index, statusSearchEntry);
    }

    public void addStatus(int index, int status, String href, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        StatusSearchEntry statusSearchEntry = new StatusSearchEntry();
        statusSearchEntry.setAlign("left");
        statusSearchEntry.setColspan(1);
        statusSearchEntry.setHref(href);
        statusSearchEntry.setRequest(request);
        statusSearchEntry.setResponse(response);
        statusSearchEntry.setServletContext(servletContext);
        statusSearchEntry.setStatus(status);
        statusSearchEntry.setValign("middle");
        this._searchEntries.add(index, statusSearchEntry);
    }

    public void addStatus(int status, long statusByUserId, Date statusDate) {
        this.addStatus(this._searchEntries.size(), status, statusByUserId, statusDate, null);
    }

    public void addStatus(int status, long statusByUserId, Date statusDate, PortletURL portletURL) {
        if (portletURL != null) {
            this.addStatus(this._searchEntries.size(), status, statusByUserId, statusDate, portletURL.toString());
        } else {
            this.addStatus(this._searchEntries.size(), status, statusByUserId, statusDate, null);
        }
    }

    public void addStatus(int status, long statusByUserId, Date statusDate, String href) {
        this.addStatus(this._searchEntries.size(), status, statusByUserId, statusDate, href);
    }

    public void addStatus(int status, PortletURL portletURL) {
        if (portletURL != null) {
            this.addStatus(this._searchEntries.size(), status, 0L, null, portletURL.toString());
        } else {
            this.addStatus(this._searchEntries.size(), status, 0L, null, null);
        }
    }

    public void addStatus(int status, String href) {
        this.addStatus(this._searchEntries.size(), status, 0L, null, href);
    }

    public void addText(int index, String name) {
        this.addText(index, "left", "middle", 1, name);
    }

    public void addText(int index, String name, PortletURL portletURL) {
        if (portletURL == null) {
            this.addText(index, name);
        } else {
            this.addText(index, name, portletURL.toString());
        }
    }

    public void addText(int index, String name, String href) {
        this.addText(index, "left", "middle", 1, name, href);
    }

    public void addText(int index, String align, String valign, int colspan, String name) {
        TextSearchEntry textSearchEntry = new TextSearchEntry();
        textSearchEntry.setAlign(align);
        textSearchEntry.setColspan(colspan);
        textSearchEntry.setName(name);
        textSearchEntry.setValign(valign);
        this._searchEntries.add(index, textSearchEntry);
    }

    public void addText(int index, String align, String valign, int colspan, String name, PortletURL portletURL) {
        if (portletURL == null) {
            this.addText(index, align, valign, colspan, name);
        } else {
            this.addText(index, align, valign, colspan, name, portletURL.toString());
        }
    }

    public void addText(int index, String align, String valign, int colspan, String name, String href) {
        if (this._restricted) {
            href = null;
        }
        TextSearchEntry textSearchEntry = new TextSearchEntry();
        textSearchEntry.setAlign(align);
        textSearchEntry.setColspan(colspan);
        textSearchEntry.setHref(href);
        textSearchEntry.setName(name);
        textSearchEntry.setValign(valign);
        this._searchEntries.add(index, textSearchEntry);
    }

    public void addText(int index, TextSearchEntry searchEntry) {
        if (this._restricted) {
            searchEntry.setHref(null);
        }
        this._searchEntries.add(index, searchEntry);
    }

    public void addText(String name) {
        this.addText(this._searchEntries.size(), name);
    }

    public void addText(String name, PortletURL portletURL) {
        if (portletURL == null) {
            this.addText(name);
        } else {
            this.addText(name, portletURL.toString());
        }
    }

    public void addText(String name, String href) {
        this.addText(this._searchEntries.size(), name, href);
    }

    public void addText(String align, String valign, int colspan, String name) {
        this.addText(this._searchEntries.size(), align, valign, colspan, name);
    }

    public void addText(String align, String valign, int colspan, String name, PortletURL portletURL) {
        if (portletURL == null) {
            this.addText(align, valign, colspan, name);
        } else {
            this.addText(align, valign, colspan, name, portletURL.toString());
        }
    }

    public void addText(String align, String valign, int colspan, String name, String href) {
        this.addText(this._searchEntries.size(), align, valign, colspan, name, href);
    }

    public void addText(String align, String valign, String name) {
        this.addText(this._searchEntries.size(), align, valign, 1, name);
    }

    public void addText(String align, String valign, String name, PortletURL portletURL) {
        this.addText(align, valign, 1, name, portletURL);
    }

    public void addText(String align, String valign, String name, String href) {
        this.addText(this._searchEntries.size(), align, valign, 1, name, href);
    }

    public void addText(TextSearchEntry searchEntry) {
        if (this._restricted) {
            searchEntry.setHref(null);
        }
        this._searchEntries.add(this._searchEntries.size(), searchEntry);
    }

    public String getClassHoverName() {
        return this._classHoverName;
    }

    public String getClassName() {
        return this._className;
    }

    public Map<String, Object> getData() {
        return this._data;
    }

    public List<SearchEntry> getEntries() {
        return this._searchEntries;
    }

    public Object getObject() {
        return this._obj;
    }

    public Object getParameter(String param) {
        if (this._params == null) {
            this._params = new HashMap<String, Object>();
        }
        return this._params.get(param);
    }

    public int getPos() {
        return this._pos;
    }

    public String getPrimaryKey() {
        return this._primaryKey;
    }

    public String getRowId() {
        return this._rowId;
    }

    public boolean isBold() {
        return this._bold;
    }

    public boolean isRestricted() {
        return this._restricted;
    }

    public boolean isSkip() {
        return this._skip;
    }

    public void removeSearchEntry(int pos) {
        this._searchEntries.remove(pos);
    }

    public void setBold(boolean bold) {
        this._bold = bold;
    }

    public void setClassHoverName(String classHoverName) {
        this._classHoverName = classHoverName;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setData(Map<String, Object> data) {
        this._data = data;
    }

    public void setObject(Object obj) {
        this._obj = obj;
    }

    public void setParameter(String param, Object value) {
        if (this._params == null) {
            this._params = new HashMap<String, Object>();
        }
        this._params.put(param, value);
    }

    public void setPrimaryKey(String primaryKey) {
        this._primaryKey = primaryKey;
    }

    public void setRestricted(boolean restricted) {
        this._restricted = restricted;
    }

    public void setRowId(String rowId) {
        this._rowId = rowId;
    }

    public void setSkip(boolean skip) {
        this._skip = skip;
    }
}

