/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.mobile.device;

import com.liferay.portal.kernel.mobile.device.Capability;
import com.liferay.portal.kernel.mobile.device.Device;
import com.liferay.portal.kernel.mobile.device.DeviceRecognitionProvider;
import com.liferay.portal.kernel.mobile.device.KnownDevices;
import com.liferay.portal.kernel.mobile.device.VersionableName;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class DeviceDetectionUtil {
    private static volatile DeviceRecognitionProvider _deviceRecognitionProvider;

    public static Device detectDevice(HttpServletRequest request) {
        return DeviceDetectionUtil.getDeviceRecognitionProvider().detectDevice(request);
    }

    public static DeviceRecognitionProvider getDeviceRecognitionProvider() {
        PortalRuntimePermission.checkGetBeanProperty(DeviceDetectionUtil.class);
        return _deviceRecognitionProvider;
    }

    public static Set<VersionableName> getKnownBrands() {
        KnownDevices knownDevices = DeviceDetectionUtil.getDeviceRecognitionProvider().getKnownDevices();
        return knownDevices.getBrands();
    }

    public static Set<VersionableName> getKnownBrowsers() {
        KnownDevices knownDevices = DeviceDetectionUtil.getDeviceRecognitionProvider().getKnownDevices();
        return knownDevices.getBrowsers();
    }

    public static Set<String> getKnownDeviceIdsByCapability(Capability capability) {
        KnownDevices knownDevices = DeviceDetectionUtil.getDeviceRecognitionProvider().getKnownDevices();
        Map<Capability, Set<String>> deviceIds = knownDevices.getDeviceIds();
        return deviceIds.get(capability);
    }

    public static Set<VersionableName> getKnownOperatingSystems() {
        KnownDevices knownDevices = DeviceDetectionUtil.getDeviceRecognitionProvider().getKnownDevices();
        return knownDevices.getOperatingSystems();
    }

    public static Set<String> getKnownPointingMethods() {
        KnownDevices knownDevices = DeviceDetectionUtil.getDeviceRecognitionProvider().getKnownDevices();
        return knownDevices.getPointingMethods();
    }

    public void setDeviceRecognitionProvider(DeviceRecognitionProvider deviceRecognitionProvider) {
        PortalRuntimePermission.checkSetBeanProperty(this.getClass());
        _deviceRecognitionProvider = deviceRecognitionProvider;
    }
}

