/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband.cache;

import com.liferay.portal.kernel.cache.CacheListener;
import com.liferay.portal.kernel.cache.CacheListenerScope;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.io.Deserializer;
import com.liferay.portal.kernel.io.Serializer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.nio.intraband.Datagram;
import com.liferay.portal.kernel.nio.intraband.Intraband;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.SystemDataType;
import com.liferay.portal.kernel.nio.intraband.cache.PortalCacheActionType;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class IntrabandPortalCache<K extends Serializable, V extends Serializable>
implements PortalCache<K, V>,
Serializable {
    private static Log _log = LogFactoryUtil.getLog(IntrabandPortalCache.class);
    private final Intraband _intraband;
    private final String _name;
    private final byte _portalCacheType;
    private final RegistrationReference _registrationReference;

    public IntrabandPortalCache(String name, RegistrationReference registrationReference) {
        this._name = name;
        this._registrationReference = registrationReference;
        this._intraband = registrationReference.getIntraband();
        SystemDataType systemDataType = SystemDataType.PORTAL_CACHE;
        this._portalCacheType = systemDataType.getValue();
    }

    @Override
    public void destroy() {
        Serializer serializer = this._createSerializer(PortalCacheActionType.DESTROY);
        this._intraband.sendDatagram(this._registrationReference, Datagram.createRequestDatagram(this._portalCacheType, serializer.toByteBuffer()));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Collection<V> get(Collection<K> keys) {
        serializer = this._createSerializer(PortalCacheActionType.GET_BULK);
        serializer.writeObject((Serializable)keys);
        try {
            return (Collection)this._syncSend(serializer.toByteBuffer());
        }
        catch (Exception e) {
            if (IntrabandPortalCache._log.isWarnEnabled()) {
                IntrabandPortalCache._log.warn("Unable to bulk get, coverting to cache miss", e);
            }
            values = new ArrayList<Object>(keys.size());
            i = 0;
            ** while (i < keys.size())
        }
lbl-1000:
        // 1 sources

        {
            values.add(null);
            ++i;
            continue;
        }
lbl15:
        // 1 sources

        return values;
    }

    @Override
    public List<K> getKeys() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V get(K key) {
        Serializer serializer = this._createSerializer(PortalCacheActionType.GET);
        serializer.writeObject((Serializable)key);
        try {
            return (V)this._syncSend(serializer.toByteBuffer());
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn("Unable to get, coverting to cache miss", e);
            }
            return null;
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void put(K key, V value) {
        Serializer serializer = this._createSerializer(PortalCacheActionType.PUT);
        serializer.writeObject((Serializable)key);
        serializer.writeObject((Serializable)value);
        this._intraband.sendDatagram(this._registrationReference, Datagram.createRequestDatagram(this._portalCacheType, serializer.toByteBuffer()));
    }

    @Override
    public void put(K key, V value, int timeToLive) {
        Serializer serializer = this._createSerializer(PortalCacheActionType.PUT_TTL);
        serializer.writeObject((Serializable)key);
        serializer.writeObject((Serializable)value);
        serializer.writeInt(timeToLive);
        this._intraband.sendDatagram(this._registrationReference, Datagram.createRequestDatagram(this._portalCacheType, serializer.toByteBuffer()));
    }

    @Override
    public void registerCacheListener(CacheListener<K, V> cacheListener) {
    }

    @Override
    public void registerCacheListener(CacheListener<K, V> cacheListener, CacheListenerScope cacheListenerScope) {
    }

    @Override
    public void remove(K key) {
        Serializer serializer = this._createSerializer(PortalCacheActionType.REMOVE);
        serializer.writeObject((Serializable)key);
        this._intraband.sendDatagram(this._registrationReference, Datagram.createRequestDatagram(this._portalCacheType, serializer.toByteBuffer()));
    }

    @Override
    public void removeAll() {
        Serializer serializer = this._createSerializer(PortalCacheActionType.REMOVE_ALL);
        this._intraband.sendDatagram(this._registrationReference, Datagram.createRequestDatagram(this._portalCacheType, serializer.toByteBuffer()));
    }

    @Override
    public void unregisterCacheListener(CacheListener<K, V> cacheListener) {
    }

    @Override
    public void unregisterCacheListeners() {
    }

    private Serializer _createSerializer(PortalCacheActionType portalCacheActionType) {
        Serializer serializer = new Serializer();
        serializer.writeInt(portalCacheActionType.ordinal());
        serializer.writeString(this._name);
        return serializer;
    }

    private <T extends Serializable> T _syncSend(ByteBuffer byteBuffer) throws Exception {
        Datagram responseDatagram = this._intraband.sendSyncDatagram(this._registrationReference, Datagram.createRequestDatagram(this._portalCacheType, byteBuffer));
        Deserializer deserializer = new Deserializer(responseDatagram.getDataByteBuffer());
        return deserializer.readObject();
    }
}

