/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.workflow;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackRegistryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.workflow.WorkflowEngineManagerUtil;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistry;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManagerUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.model.WorkflowDefinitionLink;
import com.liferay.portal.model.WorkflowInstanceLink;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.WorkflowInstanceLinkLocalServiceUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class WorkflowHandlerRegistryUtil {
    private static Log _log = LogFactoryUtil.getLog(WorkflowHandlerRegistryUtil.class);
    private static WorkflowHandlerRegistryUtil _instance = new WorkflowHandlerRegistryUtil();
    private static WorkflowHandlerRegistry _workflowHandlerRegistry;

    public static List<WorkflowHandler> getScopeableWorkflowHandlers() {
        return WorkflowHandlerRegistryUtil.getWorkflowHandlerRegistry().getScopeableWorkflowHandlers();
    }

    public static WorkflowHandler getWorkflowHandler(String className) {
        return WorkflowHandlerRegistryUtil.getWorkflowHandlerRegistry().getWorkflowHandler(className);
    }

    public static WorkflowHandlerRegistry getWorkflowHandlerRegistry() {
        PortalRuntimePermission.checkGetBeanProperty(WorkflowHandlerRegistryUtil.class);
        return _workflowHandlerRegistry;
    }

    public static List<WorkflowHandler> getWorkflowHandlers() {
        return WorkflowHandlerRegistryUtil.getWorkflowHandlerRegistry().getWorkflowHandlers();
    }

    public static void register(List<WorkflowHandler> workflowHandlers) {
        for (WorkflowHandler workflowHandler : workflowHandlers) {
            WorkflowHandlerRegistryUtil.register(workflowHandler);
        }
    }

    public static void register(WorkflowHandler workflowHandler) {
        WorkflowHandlerRegistryUtil.getWorkflowHandlerRegistry().register(workflowHandler);
    }

    public static void startWorkflowInstance(final long companyId, final long groupId, final long userId, String className, final long classPK, final Object model, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException, SystemException {
        if (serviceContext.getWorkflowAction() != 1) {
            return;
        }
        final WorkflowHandler workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler(className);
        if (workflowHandler == null) {
            if (WorkflowThreadLocal.isEnabled()) {
                throw new WorkflowException("No workflow handler found for " + className);
            }
            return;
        }
        boolean hasWorkflowInstanceInProgress = _instance._hasWorkflowInstanceInProgress(companyId, groupId, className, classPK);
        if (hasWorkflowInstanceInProgress) {
            if (_log.isWarnEnabled()) {
                _log.warn("Workflow already started for class " + className + " with primary key " + classPK + " in group " + groupId);
            }
            return;
        }
        WorkflowDefinitionLink workflowDefinitionLink = null;
        if (WorkflowThreadLocal.isEnabled() && WorkflowEngineManagerUtil.isDeployed()) {
            workflowDefinitionLink = workflowHandler.getWorkflowDefinitionLink(companyId, groupId, classPK);
        }
        int status = 1;
        if (workflowDefinitionLink == null) {
            status = 0;
        }
        workflowContext = new HashMap<String, Serializable>(workflowContext);
        workflowContext.put("companyId", (Serializable)((Object)String.valueOf(companyId)));
        workflowContext.put("groupId", (Serializable)((Object)String.valueOf(groupId)));
        workflowContext.put("userId", (Serializable)((Object)String.valueOf(userId)));
        workflowContext.put("entryClassName", (Serializable)((Object)className));
        workflowContext.put("entryClassPK", (Serializable)((Object)String.valueOf(classPK)));
        workflowContext.put("entryType", (Serializable)((Object)workflowHandler.getType(LocaleUtil.getDefault())));
        workflowContext.put("serviceContext", serviceContext);
        workflowContext.put("taskComments", (Serializable)((Object)GetterUtil.getString(serviceContext.getAttribute("comments"))));
        workflowHandler.updateStatus(status, workflowContext);
        if (workflowDefinitionLink != null) {
            final Map<String, Serializable> tempWorkflowContext = workflowContext;
            TransactionCommitCallbackRegistryUtil.registerCallback(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    workflowHandler.startWorkflowInstance(companyId, groupId, userId, classPK, model, tempWorkflowContext);
                    return null;
                }
            });
        }
    }

    public static void startWorkflowInstance(long companyId, long groupId, long userId, String className, long classPK, Object model, ServiceContext serviceContext) throws PortalException, SystemException {
        Map<String, Serializable> workflowContext = (Map<String, Serializable>)((Object)serviceContext.removeAttribute("workflowContext"));
        if (workflowContext == null) {
            workflowContext = Collections.emptyMap();
        }
        WorkflowHandlerRegistryUtil.startWorkflowInstance(companyId, groupId, userId, className, classPK, model, serviceContext, workflowContext);
    }

    public static void startWorkflowInstance(long companyId, long userId, String className, long classPK, Object model, ServiceContext serviceContext) throws PortalException, SystemException {
        Map<String, Serializable> workflowContext = (Map<String, Serializable>)((Object)serviceContext.removeAttribute("workflowContext"));
        if (workflowContext == null) {
            workflowContext = Collections.emptyMap();
        }
        WorkflowHandlerRegistryUtil.startWorkflowInstance(companyId, 0L, userId, className, classPK, model, serviceContext, workflowContext);
    }

    public static void startWorkflowInstance(long companyId, long userId, String className, long classPK, Object model, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException, SystemException {
        WorkflowHandlerRegistryUtil.startWorkflowInstance(companyId, 0L, userId, className, classPK, model, serviceContext, workflowContext);
    }

    public static void unregister(List<WorkflowHandler> workflowHandlers) {
        for (WorkflowHandler workflowHandler : workflowHandlers) {
            WorkflowHandlerRegistryUtil.unregister(workflowHandler);
        }
    }

    public static void unregister(WorkflowHandler workflowHandler) {
        WorkflowHandlerRegistryUtil.getWorkflowHandlerRegistry().unregister(workflowHandler);
    }

    public static Object updateStatus(int status, Map<String, Serializable> workflowContext) throws PortalException, SystemException {
        String className = (String)((Object)workflowContext.get("entryClassName"));
        WorkflowHandler workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler(className);
        if (workflowHandler != null) {
            return workflowHandler.updateStatus(status, workflowContext);
        }
        return null;
    }

    public void setWorkflowHandlerRegistry(WorkflowHandlerRegistry workflowHandlerRegistry) {
        PortalRuntimePermission.checkSetBeanProperty(this.getClass());
        _workflowHandlerRegistry = workflowHandlerRegistry;
    }

    private boolean _hasWorkflowInstanceInProgress(long companyId, long groupId, String className, long classPK) throws PortalException, SystemException {
        WorkflowInstanceLink workflowInstanceLink = WorkflowInstanceLinkLocalServiceUtil.fetchWorkflowInstanceLink(companyId, groupId, className, classPK);
        if (workflowInstanceLink == null) {
            return false;
        }
        WorkflowInstance workflowInstance = WorkflowInstanceManagerUtil.getWorkflowInstance(companyId, workflowInstanceLink.getWorkflowInstanceId());
        return !workflowInstance.isComplete();
    }
}

